/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsMessage;
import com.tibco.tibjms.Tibjmsx;
import com.tibco.tibjms.TibjmsxConst;
import com.tibco.tibjms.TibjmsxIntKey;
import com.tibco.tibjms.TibjmsxLinkSSL;
import com.tibco.tibjms.TibjmsxLinkSendCallback;
import com.tibco.tibjms.TibjmsxLinkTcp;
import com.tibco.tibjms.TibjmsxResponse;
import com.tibco.tibjms.TibjmsxResponseCallback;
import com.tibco.tibjms.TibjmsxURL;
import java.io.EOFException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;

abstract class TibjmsxLink
implements TibjmsxConst {
    static final int _TYPE_UNKNOWN = -1;
    static final int _TYPE_SERVER = 0;
    static final int _TYPE_MULTICAST_DAEMON = 1;
    static final int _STATE_NOT_CONNECTED = 0;
    static final int _STATE_CONNECTED = 1;
    static final int _STATE_CLOSING = 2;
    static final int _STATE_CLOSED = 3;
    static final int _RESEND_NO_RECONNECT_IGNORE = 1;
    static final int _RESEND_RECONNECT_RESEND = 2;
    static final int _RESEND_RECONNECT_EXCEPTION = 3;
    static final int _RESEND_RECONNECT_IGNORE = 4;
    TibjmsxURL _linkURL = null;
    long _lastActiveTime = 0L;
    private HashMap _responses = new HashMap();
    int _state = 0;
    Object _lock = new Object();
    Object _sendLock = new Object();
    boolean _debug = false;
    boolean _debugPrintBrief = false;
    static final int TRACE_INCOMING = 1;
    static final int TRACE_OUTGOING = 2;
    static final int TRACE_BOTH = 4;
    int _trace = 0;
    boolean _ssl_failed = false;
    int _protocolVersion = -1;
    String _userName = null;
    String _password = null;
    String _proxyHost = null;
    int _proxyPort = 0;
    String _proxyUsername = null;
    String _proxyPassword = null;
    String _linkId = null;
    boolean _shouldReconnect = false;
    Map _properties = null;
    LinkEventHandler _linkHandler = null;
    Object _closingLock = new Object();
    boolean _closing = false;
    int _type = -1;
    TibjmsxIntKey _responseKey = new TibjmsxIntKey();

    public static final String getProtocolName(int n) {
        switch (n) {
            case 1: {
                return "TCP";
            }
            case 2: {
                return "SSL";
            }
            case 3: {
                return "HTTP";
            }
            case 4: {
                return "HTTPS";
            }
        }
        return "Invalid";
    }

    protected TibjmsxLink(LinkEventHandler linkEventHandler) {
        this._linkHandler = linkEventHandler;
        this._lastActiveTime = System.currentTimeMillis();
    }

    static TibjmsxLink create(LinkEventHandler linkEventHandler, TibjmsxURL tibjmsxURL) throws JMSException {
        if (tibjmsxURL == null) {
            tibjmsxURL = TibjmsxURL.parse("tcp://localhost:7222");
        }
        switch (tibjmsxURL.protocol) {
            case 2: {
                return new TibjmsxLinkSSL(linkEventHandler);
            }
            case 1: {
                return new TibjmsxLinkTcp(linkEventHandler);
            }
            case 12: {
                return new TibjmsxLinkTcp(linkEventHandler);
            }
        }
        throw new JMSException("Protocol not supported");
    }

    abstract void connect(TibjmsxURL var1) throws JMSException;

    abstract boolean reconnect(TibjmsxURL var1);

    abstract void start() throws JMSException;

    abstract boolean isConnected();

    abstract boolean isClosed();

    abstract void closeSocket();

    abstract void disconnect();

    void setPing(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeResponse(TibjmsxIntKey tibjmsxIntKey) {
        Object object = this._lock;
        synchronized (object) {
            this._responses.remove(tibjmsxIntKey);
        }
    }

    abstract TibjmsMessage syncSendRequest(Object var1, long var2) throws JMSException;

    abstract void send(Object var1, int var2, TibjmsxResponse var3) throws JMSException;

    void send(Object object, int n) throws JMSException {
        this.send(object, n, null);
    }

    public TibjmsMessage sendRequestMsg(TibjmsMessage tibjmsMessage, long l) throws JMSException {
        return this.sendRequest(tibjmsMessage, tibjmsMessage._responseID, l, null, true);
    }

    public TibjmsMessage sendRequestMsg(TibjmsMessage tibjmsMessage, long l, TibjmsxResponseCallback tibjmsxResponseCallback) throws JMSException {
        return this.sendRequest(tibjmsMessage, tibjmsMessage._responseID, l, tibjmsxResponseCallback, true);
    }

    public TibjmsMessage sendRequest(Object object, int n, long l, TibjmsxResponseCallback tibjmsxResponseCallback, boolean bl) throws JMSException {
        return this.sendRequest(object, n, l, tibjmsxResponseCallback, bl, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public TibjmsMessage sendRequest(Object object, int n, long l, TibjmsxResponseCallback tibjmsxResponseCallback, boolean bl, boolean bl2, TibjmsxLinkSendCallback tibjmsxLinkSendCallback) throws JMSException {
        Object object2;
        TibjmsxIntKey tibjmsxIntKey = null;
        TibjmsxResponse tibjmsxResponse = null;
        int n2 = 0;
        n2 = bl ? 2 : 3;
        do {
            tibjmsxIntKey = new TibjmsxIntKey(n);
            tibjmsxResponse = new TibjmsxResponse();
            tibjmsxResponse.callback = tibjmsxResponseCallback;
            tibjmsxResponse.id = n;
            tibjmsxResponse.block = bl2;
            object2 = this._sendLock;
            // MONITORENTER : object2
            Object object3 = this._lock;
            // MONITORENTER : object3
            if (this._state != 1) {
                throw new JMSException("Connection is closed");
            }
            if (tibjmsxLinkSendCallback != null) {
                tibjmsxLinkSendCallback.linkPreSend(tibjmsxResponse);
            }
            this._responses.put(tibjmsxIntKey, tibjmsxResponse);
            // MONITOREXIT : object3
            try {
                this.send(object, n2, tibjmsxResponse);
            }
            catch (JMSException jMSException) {
                boolean bl3 = true;
                Object object4 = this._lock;
                // MONITORENTER : object4
                this._responses.remove(tibjmsxIntKey);
                if (tibjmsxLinkSendCallback != null) {
                    bl3 = tibjmsxLinkSendCallback.linkSendError(tibjmsxResponse);
                }
                // MONITOREXIT : object4
                if (bl3) {
                    throw jMSException;
                }
                // MONITOREXIT : object2
                return null;
            }
            if (!bl2) {
                return null;
            }
            object2 = null;
            object3 = tibjmsxResponse;
            // MONITORENTER : object3
            while (tibjmsxResponse.status == 0) {
                try {
                    if (l < -1L) {
                        tibjmsxResponse.wait(-l);
                        continue;
                    }
                    tibjmsxResponse.wait();
                }
                catch (InterruptedException interruptedException) {
                    object2 = Tibjmsx.buildException("InterruptedException has occurred while waiting for server response", null, interruptedException);
                }
            }
            // MONITOREXIT : object3
            object3 = this._lock;
            // MONITORENTER : object3
            this._responses.remove(tibjmsxIntKey);
            // MONITOREXIT : object3
            if (tibjmsxResponse.status != 4) break;
            if (bl) continue;
            object2 = Tibjmsx.buildException("Send failed due to fault-tolerant switch", null, null);
            break;
        } while (tibjmsxResponse.completionEvent == null);
        if (object2 == null) return tibjmsxResponse.reply;
        boolean bl4 = true;
        if (tibjmsxLinkSendCallback != null) {
            bl4 = tibjmsxLinkSendCallback.linkSendError(tibjmsxResponse);
        }
        if (!bl4) return tibjmsxResponse.reply;
        throw object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processResponse(TibjmsMessage tibjmsMessage, long l) {
        TibjmsxResponse tibjmsxResponse = null;
        Object object = this._lock;
        synchronized (object) {
            this._responseKey.set((int)l);
            tibjmsxResponse = (TibjmsxResponse)this._responses.remove(this._responseKey);
        }
        if (tibjmsxResponse == null) {
            return;
        }
        object = tibjmsxResponse;
        synchronized (object) {
            tibjmsxResponse.reply = tibjmsMessage;
            tibjmsxResponse.status = 1;
            if (tibjmsxResponse.callback != null) {
                tibjmsxResponse.callback.onResponse(tibjmsMessage);
            }
            if (tibjmsxResponse.completionEvent != null) {
                tibjmsxResponse.completionEvent.setCompleted(tibjmsMessage);
            }
            if (tibjmsxResponse.block) {
                tibjmsxResponse.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recoverResponse(TibjmsxResponse tibjmsxResponse) {
        if (tibjmsxResponse == null) {
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            tibjmsxResponse.status = 0;
            tibjmsxResponse.reply = null;
            TibjmsxIntKey tibjmsxIntKey = new TibjmsxIntKey(tibjmsxResponse.id);
            this._responses.put(tibjmsxIntKey, tibjmsxResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushRequests(byte by) {
        Object object = this._lock;
        synchronized (object) {
            for (TibjmsxResponse tibjmsxResponse : this._responses.values()) {
                if (tibjmsxResponse == null) continue;
                TibjmsxResponse tibjmsxResponse2 = tibjmsxResponse;
                synchronized (tibjmsxResponse2) {
                    tibjmsxResponse.status = by;
                    if (tibjmsxResponse.completionEvent != null && (by == 4 || by == 2)) {
                        tibjmsxResponse.completionEvent.setCompleted(3, null);
                    }
                    if (tibjmsxResponse.block) {
                        tibjmsxResponse.notify();
                    }
                }
            }
            this._responses.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushConnectionRequests(byte by, HashMap hashMap) {
        TibjmsxResponse tibjmsxResponse = null;
        Object object = this._lock;
        synchronized (object) {
            Iterator iterator2 = hashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                int n = (Integer)iterator2.next();
                this._responseKey.set(n);
                tibjmsxResponse = (TibjmsxResponse)this._responses.get(this._responseKey);
                if (tibjmsxResponse == null) continue;
                TibjmsxResponse tibjmsxResponse2 = tibjmsxResponse;
                synchronized (tibjmsxResponse2) {
                    tibjmsxResponse.reply = null;
                    tibjmsxResponse.status = by;
                    if (tibjmsxResponse.block) {
                        tibjmsxResponse.notify();
                    }
                }
            }
        }
    }

    public void setUserNamePassword(String string, String string2) {
        this._userName = string != null && string.length() == 0 ? null : string;
        this._password = string2 != null && string2.length() == 0 ? null : string2;
    }

    public String getUserName() {
        return this._userName;
    }

    public String getPassword() {
        return this._password;
    }

    public void setProxyInfo(String string, int n, String string2, String string3) {
        this._proxyHost = string;
        this._proxyPort = n;
        this._proxyPassword = string3;
        this._proxyUsername = string2;
    }

    public int getPrococolVersion() {
        return this._protocolVersion;
    }

    public void setProtocolVersion(int n) {
        this._protocolVersion = n;
    }

    public void setLinkId(String string) {
        this._linkId = string;
    }

    public void setType(int n) {
        this._type = n;
    }

    public void setReconnect(boolean bl) {
        this._shouldReconnect = bl;
    }

    public void setProperties(Map map) {
        this._properties = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosing() {
        Object object = this._closingLock;
        synchronized (object) {
            this._closing = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosing() {
        Object object = this._closingLock;
        synchronized (object) {
            return this._closing;
        }
    }

    public static interface LinkEventHandler {
        public void onEventDisconnected(Exception var1, boolean var2);

        public boolean onEventReconnect();

        public void onEventProcessMessage(byte[] var1) throws EOFException, JMSException;

        public String getTerminatedText();
    }
}

