/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsxDPQList;
import com.tibco.tibjms.TibjmsxDPQMember;

class TibjmsxDPQueue {
    TibjmsxDPQList[] lists = null;
    TibjmsxDPQList empty = new TibjmsxDPQList(this, -1);
    int mcount = 0;
    int max_priority = -1;

    TibjmsxDPQueue(int n) {
        this.lists = new TibjmsxDPQList[n];
        for (int j = 0; j < this.lists.length; ++j) {
            this.lists[j] = new TibjmsxDPQList(this, j);
        }
        this.mcount = 0;
        this.max_priority = -1;
    }

    int size() {
        return this.mcount;
    }

    void clear() {
        this.empty.clear();
        for (int j = 0; j < this.lists.length; ++j) {
            this.lists[j].clear();
        }
        this.mcount = 0;
        this.max_priority = -1;
    }

    void add(TibjmsxDPQMember tibjmsxDPQMember) {
        int n = tibjmsxDPQMember.getDPQPriority();
        if (n == -1) {
            this.empty.add(tibjmsxDPQMember);
        } else {
            this.lists[n].add(tibjmsxDPQMember);
        }
        ++this.mcount;
        if (this.max_priority < n) {
            this.max_priority = n;
        }
    }

    void remove(TibjmsxDPQMember tibjmsxDPQMember) {
        TibjmsxDPQList tibjmsxDPQList = tibjmsxDPQMember.list;
        if (tibjmsxDPQList == null) {
            return;
        }
        if (tibjmsxDPQList.queue != this) {
            throw new InternalError("Error in DPQ logic in remove");
        }
        tibjmsxDPQList.remove(tibjmsxDPQMember);
        --this.mcount;
        if (this.mcount == 0) {
            this.max_priority = -1;
            return;
        }
        if (tibjmsxDPQList != this.empty && tibjmsxDPQList.priority == this.max_priority && tibjmsxDPQList.size() == 0) {
            this.calcMaxPriority();
        }
    }

    void calcMaxPriority() {
        this.max_priority = -1;
        for (int j = this.lists.length - 1; j >= 0; --j) {
            if (this.lists[j].size() <= 0) continue;
            this.max_priority = j;
            return;
        }
    }

    void positionMember(TibjmsxDPQMember tibjmsxDPQMember, boolean bl) {
        int n;
        if (tibjmsxDPQMember.list == null) {
            return;
        }
        int n2 = tibjmsxDPQMember.getDPQPriority();
        if (n2 != (n = tibjmsxDPQMember.list.priority) || !bl) {
            tibjmsxDPQMember.list.remove(tibjmsxDPQMember);
            if (n2 == -1) {
                this.empty.add(tibjmsxDPQMember);
            } else {
                this.lists[n2].add(tibjmsxDPQMember);
            }
            this.calcMaxPriority();
        }
    }

    TibjmsxDPQMember get() {
        if (this.mcount == 0 || this.max_priority == -1) {
            return null;
        }
        return this.lists[this.max_priority].get();
    }
}

