/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsxStream;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class TibjmsXid
implements Xid {
    private int _formatId;
    private byte[] _branchQual;
    private int _branchQualLength;
    private byte[] _globalTxId;
    private int _globalTxIdLength;
    public static final int NULLXID = -1;

    public TibjmsXid() {
        this.create(-1, null, 0, null, 0);
    }

    public TibjmsXid(int n, byte[] byArray, int n2, byte[] byArray2, int n3) {
        this.create(n, byArray, n2, byArray2, n3);
    }

    public TibjmsXid(int n, String string, String string2) {
        byte[] byArray = string.getBytes();
        int n2 = byArray.length;
        byte[] byArray2 = string2.getBytes();
        int n3 = byArray2.length;
        this.create(n, byArray, n2, byArray2, n3);
    }

    public TibjmsXid(Xid xid) {
        byte[] byArray = xid.getGlobalTransactionId();
        int n = byArray.length;
        byte[] byArray2 = xid.getBranchQualifier();
        int n2 = byArray2.length;
        this.create(xid.getFormatId(), byArray, n, byArray2, n2);
    }

    public TibjmsXid(byte[] byArray) {
        TibjmsxStream tibjmsxStream = new TibjmsxStream(byArray);
        try {
            int n = tibjmsxStream.readInt();
            int n2 = tibjmsxStream.readInt();
            int n3 = tibjmsxStream.readInt();
            byte[] byArray2 = new byte[n2];
            tibjmsxStream.read(byArray2, 0, n2);
            byte[] byArray3 = new byte[n3];
            tibjmsxStream.read(byArray3, 0, n3);
            this.create(n, byArray2, n2, byArray3, n3);
        }
        catch (Exception exception) {
            this.create(-1, null, 0, null, 0);
        }
    }

    private void create(int n, byte[] byArray, int n2, byte[] byArray2, int n3) {
        this._globalTxId = new byte[64];
        this._branchQual = new byte[64];
        this._formatId = n;
        if (n2 > 64) {
            n2 = 64;
        }
        if (byArray != null) {
            System.arraycopy(byArray, 0, this._globalTxId, 0, n2);
        }
        this._globalTxIdLength = n2;
        if (n3 > 64) {
            n3 = 64;
        }
        if (byArray2 != null) {
            System.arraycopy(byArray2, 0, this._branchQual, 0, n3);
        }
        this._branchQualLength = n3;
    }

    @Override
    public byte[] getBranchQualifier() {
        byte[] byArray = new byte[this._branchQualLength];
        System.arraycopy(this._branchQual, 0, byArray, 0, this._branchQualLength);
        return byArray;
    }

    @Override
    public int getFormatId() {
        return this._formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        byte[] byArray = new byte[this._globalTxIdLength];
        System.arraycopy(this._globalTxId, 0, byArray, 0, this._globalTxIdLength);
        return byArray;
    }

    public static boolean isSame(Xid xid, Xid xid2) {
        if (xid == null || xid2 == null) {
            return false;
        }
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        byte[] byArray3 = xid2.getGlobalTransactionId();
        byte[] byArray4 = xid2.getBranchQualifier();
        return xid.getFormatId() == xid2.getFormatId() && byArray.length == byArray3.length && byArray2.length == byArray4.length && Arrays.equals(byArray, byArray3) && Arrays.equals(byArray2, byArray2);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(256);
        if (this._formatId == -1) {
            return "NULLXID";
        }
        stringBuffer.append("{formatID=" + this._formatId);
        stringBuffer.append(" gtrid_length=" + this._globalTxIdLength);
        stringBuffer.append(" bqual_length=" + this._branchQualLength + " data=");
        for (n = 0; n < this._globalTxIdLength; ++n) {
            if (this._globalTxId[n] >= 32 && this._globalTxId[n] <= 126 && this._globalTxId[n] != 37) {
                stringBuffer.append((char)this._globalTxId[n]);
                continue;
            }
            stringBuffer.append("%" + Byte.toString(this._globalTxId[n]));
        }
        for (n = 0; n < this._branchQualLength; ++n) {
            if (this._branchQual[n] >= 32 && this._branchQual[n] <= 126 && this._branchQual[n] != 37) {
                stringBuffer.append((char)this._branchQual[n]);
                continue;
            }
            stringBuffer.append("%" + Byte.toString(this._branchQual[n]));
        }
        stringBuffer.append("}");
        return new String(stringBuffer);
    }
}

