/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsConnection;
import com.tibco.tibjms.TibjmsMessage;
import com.tibco.tibjms.TibjmsXid;
import com.tibco.tibjms.Tibjmsx;
import com.tibco.tibjms.TibjmsxConst;
import com.tibco.tibjms.TibjmsxResponseCallback;
import com.tibco.tibjms.TibjmsxSessionImp;
import com.tibco.tibjms.TibjmsxStream;
import com.tibco.tibjms.TibjmsxTrace;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TibjmsXAResource
implements XAResource,
TibjmsxConst {
    private static final char[] _hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int _TMONEPHASE = 0x40000000;
    private int timeout;
    private static final int _TX_ACTIVE = 0;
    private static final int _TX_SUSPENDED = 2;
    TibjmsxSessionImp _session;
    Map transactions = new Hashtable();
    boolean txactive = false;
    private boolean newProtocol = false;

    private static boolean _isPrintable(char c) {
        if (c == '%') {
            return false;
        }
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        return c == '_' || c == ':' || c == '.' || c == ',' || c == '<' || c == '>' || c == '/' || c == '-' || c == '+' || c == '*' || c == '&' || c == '@' || c == '$' || c == '#' || c == '(' || c == ')' || c == '[' || c == ']';
    }

    static String _xidToString(Xid xid) {
        int n;
        int n2;
        char c;
        int n3;
        if (xid == null) {
            return "null";
        }
        byte[] byArray = xid.getBranchQualifier();
        byte[] byArray2 = xid.getGlobalTransactionId();
        int n4 = byArray == null ? 0 : byArray.length;
        int n5 = byArray2 == null ? 0 : byArray2.length;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{formatID=" + xid.getFormatId() + " gtrid_length=" + n5 + " bqual_length=" + n4 + " data=");
        for (n3 = 0; n3 < n5; ++n3) {
            c = (char)(byArray2[n3] & 0xFF);
            if (TibjmsXAResource._isPrintable(c)) {
                stringBuffer.append(c);
                continue;
            }
            n2 = c >> 4;
            n = c & 0xF;
            stringBuffer.append('%');
            stringBuffer.append(_hex[n2 &= 0xF]);
            stringBuffer.append(_hex[n]);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            c = (char)(byArray[n3] & 0xFF);
            if (TibjmsXAResource._isPrintable(c)) {
                stringBuffer.append(c);
                continue;
            }
            n2 = c >> 4;
            n = c & 0xF;
            stringBuffer.append('%');
            stringBuffer.append(_hex[n2 &= 0xF]);
            stringBuffer.append(_hex[n]);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    TibjmsXAResource(TibjmsxSessionImp tibjmsxSessionImp) {
        this._session = tibjmsxSessionImp;
        this.timeout = this._session._connection._xa_default_timeout;
        this.newProtocol = this._session._connection._xaNewProtocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTransactionTimeout(int n) throws XAException {
        if (n < 0) {
            throw new XAException(-5);
        }
        Object object = this._session._sessionLock;
        synchronized (object) {
            this.timeout = n;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionTimeout() throws XAException {
        Object object = this._session._sessionLock;
        synchronized (object) {
            return this.timeout;
        }
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (!(xAResource instanceof TibjmsXAResource)) {
            return false;
        }
        TibjmsXAResource tibjmsXAResource = (TibjmsXAResource)xAResource;
        TibjmsxSessionImp tibjmsxSessionImp = tibjmsXAResource._session;
        TibjmsConnection tibjmsConnection = tibjmsxSessionImp._connection;
        return tibjmsConnection == this._session._connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startV2(Xid xid, int n) throws XAException {
        TibjmsMessage tibjmsMessage = null;
        try {
            TibjmsMessage tibjmsMessage2 = new TibjmsMessage(81, Tibjmsx.getResponseID(), 9);
            TibjmsXAResource.setXid(tibjmsMessage2, xid);
            Object object = this._session._sessionLock;
            synchronized (object) {
                tibjmsMessage2.setLongProperty("sessid", this._session._sessid);
                tibjmsMessage2.setIntProperty("xaflgs", n);
                tibjmsMessage2.setIntProperty("xatmout", this.timeout);
                tibjmsMessage = this._session._connection._link.sendRequest(tibjmsMessage2, tibjmsMessage2._responseID, this._session._connection._requestTimeout, null, false);
                if (tibjmsMessage == null || tibjmsMessage._type != 10) {
                    throw TibjmsXAResource.buildXAException(tibjmsMessage);
                }
                this._session._startXATransaction();
            }
        }
        catch (JMSException jMSException) {
            throw new XAException(-3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Xid xid, int n) throws XAException {
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "xa start conn={0,number,###0.##} sess={1,number,###0.##} xid={2} flags={3,number,###0.##}", new Object[]{new Long(this._session._connection._connid), new Long(this._session._sessid), xid.toString() + " (" + TibjmsXAResource._xidToString(xid) + ")", new Long(Integer.toHexString(n))});
        }
        if (this.newProtocol) {
            this.startV2(xid, n);
            return;
        }
        if (this.txactive) {
            throw new XAException(-6);
        }
        Integer n2 = (Integer)this.transactions.get(xid);
        if (n == 0) {
            if (n2 != null) {
                throw new XAException(-8);
            }
        } else if (n == 0x8000000) {
            if (n2 == null) {
                throw new XAException(-4);
            }
            if (n2 != 2) {
                throw new XAException(-6);
            }
        } else if (n != 0x200000) {
            throw new XAException(-5);
        }
        Object object = this._session._sessionLock;
        synchronized (object) {
            try {
                this.startTx(xid, n, this._session._sessid);
                this._session._startXATransaction();
            }
            catch (JMSException jMSException) {
                throw new XAException(-3);
            }
        }
        this.transactions.put(xid, new Integer(0));
        this.txactive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endV2(Xid xid, int n) throws XAException {
        TibjmsMessage tibjmsMessage = null;
        try {
            TibjmsMessage tibjmsMessage2 = new TibjmsMessage(82, Tibjmsx.getResponseID(), 9);
            TibjmsXAResource.setXid(tibjmsMessage2, xid);
            tibjmsMessage2.setIntProperty("xaflgs", n);
            Object object = this._session._sessionLock;
            synchronized (object) {
                tibjmsMessage2.setLongProperty("sessid", this._session._sessid);
                this._session.transferDeliveredListIntoXARequest(tibjmsMessage2);
                this._session._endXATransaction();
                tibjmsMessage = this._session._connection._link.sendRequest(tibjmsMessage2, tibjmsMessage2._responseID, this._session._connection._requestTimeout, null, false);
                if (tibjmsMessage == null || tibjmsMessage._type != 10) {
                    XAException xAException = TibjmsXAResource.buildXAException(tibjmsMessage);
                    if (n == 0x20000000 && xAException.errorCode == 100) {
                        return;
                    }
                    throw xAException;
                }
            }
        }
        catch (JMSException jMSException) {
            throw new XAException(-3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int n) throws XAException {
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "xa end conn={0,number,###0.##} sess={1,number,###0.##} xid={2} flags={3,number,###0.##}", new Object[]{new Long(this._session._connection._connid), new Long(this._session._sessid), xid.toString() + " (" + TibjmsXAResource._xidToString(xid) + ")", new Long(Integer.toHexString(n))});
        }
        if (this.newProtocol) {
            this.endV2(xid, n);
            return;
        }
        this.txactive = false;
        this._session._endXATransaction();
        Integer n2 = (Integer)this.transactions.get(xid);
        if (n2 == null) {
            throw new XAException(-4);
        }
        Object object = this._session._sessionLock;
        synchronized (object) {
            try {
                this.endTx(xid, n);
            }
            catch (Exception exception) {
                throw new XAException(-3);
            }
        }
        if (n == 0x2000000) {
            this.transactions.put(xid, new Integer(2));
        } else {
            this.transactions.remove(xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int prepareV2(Xid xid) throws XAException {
        TibjmsMessage tibjmsMessage = null;
        try {
            TibjmsMessage tibjmsMessage2 = new TibjmsMessage(83, Tibjmsx.getResponseID(), 9);
            TibjmsXAResource.setXid(tibjmsMessage2, xid);
            Object object = this._session._sessionLock;
            synchronized (object) {
                tibjmsMessage = this._session._connection._link.sendRequest(tibjmsMessage2, tibjmsMessage2._responseID, this._session._connection._requestTimeout, null, false);
                if (tibjmsMessage == null || tibjmsMessage._type != 10) {
                    throw this.buildXARetryPossibleException(tibjmsMessage);
                }
            }
        }
        catch (JMSException jMSException) {
            throw this.buildXARetryPossibleException();
        }
        return 0;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "xa prepare conn={0,number,###0.##} xid={1}", new Object[]{new Long(this._session._connection._connid), xid.toString() + " (" + TibjmsXAResource._xidToString(xid) + ")"});
        }
        if (this.newProtocol) {
            return this.prepareV2(xid);
        }
        Integer n = (Integer)this.transactions.get(xid);
        if (n != null) {
            throw new XAException(-6);
        }
        try {
            return this.prepareTx(xid);
        }
        catch (XAException xAException) {
            if (xAException.errorCode == -4) {
                try {
                    this.rollback(xid);
                }
                catch (XAException xAException2) {
                    // empty catch block
                }
            }
            throw xAException;
        }
        catch (JMSException jMSException) {
            throw new XAException(-3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitV2(Xid xid, boolean bl) throws XAException {
        TibjmsMessage tibjmsMessage = null;
        try {
            TibjmsMessage tibjmsMessage2 = new TibjmsMessage(84, Tibjmsx.getResponseID(), 9);
            TibjmsXAResource.setXid(tibjmsMessage2, xid);
            if (bl) {
                tibjmsMessage2.setIntProperty("xaflgs", 0x40000000);
            }
            Object object = this._session._sessionLock;
            synchronized (object) {
                tibjmsMessage = this._session._connection._link.sendRequest(tibjmsMessage2, tibjmsMessage2._responseID, this._session._connection._requestTimeout, null, false);
                if (tibjmsMessage == null || tibjmsMessage._type != 10) {
                    XAException xAException = null;
                    xAException = bl ? TibjmsXAResource.buildXAException(tibjmsMessage, -7) : this.buildXARetryPossibleException(tibjmsMessage);
                    throw xAException;
                }
            }
        }
        catch (JMSException jMSException) {
            if (bl) {
                throw new XAException(-7);
            }
            throw this.buildXARetryPossibleException();
        }
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "xa commit conn={0,number,###0.##} xid={1} onephase={2}", new Object[]{new Long(this._session._connection._connid), xid.toString() + " (" + TibjmsXAResource._xidToString(xid) + ")", bl ? "true" : "false"});
        }
        if (this.newProtocol) {
            this.commitV2(xid, bl);
            return;
        }
        try {
            try {
                this.commitTx(xid, bl);
            }
            catch (XAException xAException) {
                if (bl && xAException.errorCode == -4) {
                    try {
                        this.rollback(xid);
                    }
                    catch (XAException xAException2) {
                        // empty catch block
                    }
                }
                throw xAException;
            }
            Vector vector = this._session._clearDeliveredForXid(xid);
            if (this._session._connectionConsumerSession != null && vector.size() > 0) {
                this._session._connectionConsumerSession._clearDelivered(vector);
            }
        }
        catch (JMSException jMSException) {
            throw new XAException(-3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackV2(Xid xid) throws XAException {
        TibjmsMessage tibjmsMessage = null;
        try {
            TibjmsMessage tibjmsMessage2 = new TibjmsMessage(85, Tibjmsx.getResponseID(), 9);
            TibjmsXAResource.setXid(tibjmsMessage2, xid);
            Object object = this._session._sessionLock;
            synchronized (object) {
                tibjmsMessage = this._session._connection._link.sendRequest(tibjmsMessage2, tibjmsMessage2._responseID, this._session._connection._requestTimeout, null, false);
                if (tibjmsMessage == null || tibjmsMessage._type != 10) {
                    throw this.buildXARetryPossibleException(tibjmsMessage);
                }
            }
        }
        catch (JMSException jMSException) {
            throw this.buildXARetryPossibleException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "xa rollback conn={0,number,###0.##} xid={1}", new Object[]{new Long(this._session._connection._connid), xid.toString() + " (" + TibjmsXAResource._xidToString(xid) + ")"});
        }
        if (this._session._connectionConsumerSession != null) {
            Object object = this._session._connectionConsumerSession._ccRollbackLock;
            synchronized (object) {
                if (this.newProtocol) {
                    this.rollbackV2(xid);
                } else {
                    this._rollback(xid);
                }
            }
        } else if (this.newProtocol) {
            this.rollbackV2(xid);
        } else {
            this._rollback(xid);
        }
    }

    private void _rollback(Xid xid) throws XAException {
        try {
            HashMap hashMap = this._session._getConsumersForXid(xid);
            this.rollbackTx(xid, new RollbackCB(hashMap, xid), hashMap.size() == 0);
        }
        catch (JMSException jMSException) {
            throw new XAException(-3);
        }
        this.transactions.remove(xid);
    }

    @Override
    public Xid[] recover(int n) throws XAException {
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "xa recover conn={0,number,###0.##} flags={1,number,###0.##}", new Object[]{new Long(this._session._connection._connid), new Long(Integer.toHexString(n))});
        }
        Object object = this._session._sessionLock;
        synchronized (object) {
            try {
                return this.recoverTx(n);
            }
            catch (JMSException jMSException) {
                throw new XAException(-3);
            }
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "xa forget conn={0,number,###0.##} xid={1}", new Object[]{new Long(this._session._connection._connid), xid.toString() + " (" + TibjmsXAResource._xidToString(xid) + ")"});
        }
        throw new XAException(-5);
    }

    void _clearTransactions() {
        this.transactions.clear();
    }

    void startTx(Xid xid, int n, long l) throws XAException, JMSException {
        TibjmsMessage tibjmsMessage = new TibjmsMessage(81);
        tibjmsMessage.setLongProperty("sessid", l);
        tibjmsMessage.setIntProperty("xaflgs", n);
        TibjmsXAResource.setXid(tibjmsMessage, xid);
        tibjmsMessage.setIntProperty("xatmout", this.timeout);
        try {
            this._session._connection._link.send(tibjmsMessage, 3);
        }
        catch (JMSException jMSException) {
            throw new XAException(-7);
        }
    }

    private static void setXid(TibjmsMessage tibjmsMessage, Xid xid) throws JMSException {
        TibjmsxStream tibjmsxStream = new TibjmsxStream();
        int n = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        tibjmsxStream.writeInt(n);
        tibjmsxStream.writeInt(byArray.length);
        tibjmsxStream.writeInt(byArray2.length);
        tibjmsxStream.write(byArray);
        tibjmsxStream.write(byArray2);
        tibjmsMessage._setBytesProperty("xid0", tibjmsxStream.buffer, 0, tibjmsxStream.curpos);
    }

    void commitTx(Xid xid, boolean bl) throws XAException, JMSException {
        TibjmsMessage tibjmsMessage = new TibjmsMessage(84, Tibjmsx.getResponseID(), 9);
        if (bl) {
            tibjmsMessage.setIntProperty("xaflgs", 0x40000000);
        }
        TibjmsXAResource.setXid(tibjmsMessage, xid);
        try {
            TibjmsMessage tibjmsMessage2 = this._session._connection._link.sendRequest(tibjmsMessage, tibjmsMessage._responseID, this._session._connection._requestTimeout, null, false);
            if (tibjmsMessage2 == null || tibjmsMessage2._type != 10) {
                throw TibjmsXAResource.buildXAException(tibjmsMessage2);
            }
        }
        catch (JMSException jMSException) {
            throw new XAException(-7);
        }
    }

    private static XAException buildXAException(TibjmsMessage tibjmsMessage) throws JMSException {
        return TibjmsXAResource.buildXAException(tibjmsMessage, -7);
    }

    private static XAException buildXAException(TibjmsMessage tibjmsMessage, int n) throws JMSException {
        String string;
        XAException xAException;
        if (tibjmsMessage == null) {
            return new XAException(n);
        }
        int n2 = -1;
        n2 = tibjmsMessage.getIntProperty("err");
        switch (n2) {
            case 20: {
                xAException = new XAException(-5);
                break;
            }
            case 15: {
                xAException = new XAException(-6);
                break;
            }
            case 35: {
                xAException = new XAException(-4);
                break;
            }
            case 91: {
                xAException = new XAException(-8);
                break;
            }
            case 108: {
                xAException = new XAException(4);
                break;
            }
            case 107: {
                xAException = new XAException(100);
                break;
            }
            default: {
                xAException = new XAException(-3);
            }
        }
        if (tibjmsMessage.propertyExists("cause") && (string = tibjmsMessage.getStringProperty("cause")) != null) {
            xAException.initCause(new Throwable(string));
        }
        return xAException;
    }

    private XAException buildXARetryPossibleException(TibjmsMessage tibjmsMessage) throws JMSException {
        if (!this._session._connection._closed) {
            return TibjmsXAResource.buildXAException(tibjmsMessage, 4);
        }
        return TibjmsXAResource.buildXAException(tibjmsMessage, -7);
    }

    private XAException buildXARetryPossibleException() {
        if (!this._session._connection._closed) {
            return new XAException(4);
        }
        return new XAException(-7);
    }

    void rollbackTx(Xid xid, RollbackCB rollbackCB, boolean bl) throws XAException, JMSException {
        Cloneable cloneable;
        TibjmsMessage tibjmsMessage = new TibjmsMessage(85, Tibjmsx.getResponseID(), 9);
        TibjmsXAResource.setXid(tibjmsMessage, xid);
        if (bl) {
            tibjmsMessage.setBooleanProperty("no_flush", true);
        } else {
            cloneable = new TibjmsxStream(256);
            TibjmsxStream tibjmsxStream = new TibjmsxStream(256);
            int n = this._session._writeXARollbackMessages(xid, rollbackCB._consumerIds, (TibjmsxStream)cloneable, tibjmsxStream);
            if (n > 0) {
                tibjmsMessage._setBytesProperty("cons", cloneable.buffer, 0, cloneable.curpos);
            }
            tibjmsMessage._setBytesProperty("ds", tibjmsxStream.getBuffer(), 0, tibjmsxStream.getPosition());
        }
        try {
            cloneable = this._session._connection._link.sendRequest(tibjmsMessage, tibjmsMessage._responseID, this._session._connection._requestTimeout, rollbackCB, false);
            if (cloneable == null || ((TibjmsMessage)cloneable)._type != 10) {
                throw TibjmsXAResource.buildXAException((TibjmsMessage)cloneable);
            }
        }
        catch (JMSException jMSException) {
            throw new XAException(-7);
        }
    }

    Xid[] recoverTx(int n) throws XAException, JMSException {
        TibjmsMessage tibjmsMessage;
        if ((n & 0x1000000) == 0) {
            return new Xid[0];
        }
        TibjmsMessage tibjmsMessage2 = new TibjmsMessage(80, Tibjmsx.getResponseID(), 9);
        try {
            tibjmsMessage = this._session._connection._link.sendRequest(tibjmsMessage2, tibjmsMessage2._responseID, this._session._connection._requestTimeout, null, false);
            if (tibjmsMessage == null || tibjmsMessage._type != 10) {
                throw TibjmsXAResource.buildXAException(tibjmsMessage);
            }
        }
        catch (JMSException jMSException) {
            throw new XAException(-7);
        }
        Xid[] xidArray = this.getXids(tibjmsMessage);
        return xidArray;
    }

    private Xid[] getXids(TibjmsMessage tibjmsMessage) throws XAException, JMSException {
        int n = 0;
        n = this.getXidCount(tibjmsMessage);
        Xid[] xidArray = new Xid[n];
        for (int j = 0; j < n; ++j) {
            byte[] byArray = tibjmsMessage._getBytesProperty("xid" + j);
            xidArray[j] = new TibjmsXid(byArray);
            if (xidArray[j].getFormatId() != -1) continue;
            throw new XAException(-3);
        }
        return xidArray;
    }

    private int getXidCount(TibjmsMessage tibjmsMessage) throws JMSException {
        byte[] byArray;
        int n = 0;
        while ((byArray = tibjmsMessage._getBytesProperty("xid" + n)) != null) {
            ++n;
        }
        return n;
    }

    void endTx(Xid xid, int n) throws XAException, JMSException {
        TibjmsxStream tibjmsxStream = new TibjmsxStream(256);
        TibjmsMessage tibjmsMessage = new TibjmsMessage(82);
        tibjmsMessage.setLongProperty("sessid", this._session._sessid);
        tibjmsMessage.setIntProperty("xaflgs", n);
        TibjmsXAResource.setXid(tibjmsMessage, xid);
        this._session._setXidAndWriteDelivered(tibjmsxStream, xid, n != 0x2000000);
        if (n != 0x2000000) {
            tibjmsMessage._setBytesProperty("seqs", tibjmsxStream.buffer, 0, tibjmsxStream.curpos);
        }
        try {
            this._session._connection._link.send(tibjmsMessage, 3);
        }
        catch (JMSException jMSException) {
            throw new XAException(-7);
        }
    }

    int prepareTx(Xid xid) throws XAException, JMSException {
        TibjmsMessage tibjmsMessage = new TibjmsMessage(83, Tibjmsx.getResponseID(), 9);
        TibjmsXAResource.setXid(tibjmsMessage, xid);
        try {
            TibjmsMessage tibjmsMessage2 = this._session._connection._link.sendRequest(tibjmsMessage, tibjmsMessage._responseID, this._session._connection._requestTimeout, null, false);
            if (tibjmsMessage2 == null || tibjmsMessage2._type != 10) {
                throw TibjmsXAResource.buildXAException(tibjmsMessage2);
            }
        }
        catch (JMSException jMSException) {
            throw new XAException(-7);
        }
        return 0;
    }

    class RollbackCB
    implements TibjmsxResponseCallback {
        HashMap _consumerIds;
        Xid rbxid = null;

        public RollbackCB(HashMap hashMap, Xid xid) {
            this._consumerIds = hashMap;
            this.rbxid = xid;
        }

        @Override
        public void onResponse(TibjmsMessage tibjmsMessage) {
            if (tibjmsMessage == null) {
                return;
            }
            boolean bl = false;
            if (tibjmsMessage._type == 10) {
                bl = true;
            } else if (tibjmsMessage._type == 11) {
                int n = -1;
                try {
                    n = tibjmsMessage.getIntProperty("err");
                    if (n == 35) {
                        bl = true;
                    }
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            if (bl) {
                Vector vector = TibjmsXAResource.this._session._onXARollbackReply(this.rbxid, this._consumerIds);
                if (TibjmsXAResource.this._session._connectionConsumerSession != null) {
                    TibjmsXAResource.this._session._connectionConsumerSession._onXARollbackReply(vector);
                }
                this.rbxid = null;
            }
        }
    }
}

