/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsMessage;
import com.tibco.tibjms.TibjmsSession;
import com.tibco.tibjms.TibjmsxConst;
import com.tibco.tibjms.TibjmsxStream;
import java.io.EOFException;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.TextMessage;

public class TibjmsTextMessage
extends TibjmsMessage
implements TextMessage,
Serializable,
Cloneable,
TibjmsxConst {
    private static final long serialVersionUID = -5939984304396018622L;
    private String _text = null;

    @Override
    final boolean _hasBody() throws JMSException {
        if (!this._bodyLifted) {
            this._liftBody();
        }
        return this._text != null;
    }

    @Override
    final boolean writeBody(TibjmsxStream tibjmsxStream, boolean bl) throws JMSException {
        if (!this._bodyLifted) {
            this._liftBody();
        }
        if (bl && this._text != null && this._text.length() > 0) {
            TibjmsxStream tibjmsxStream2 = new TibjmsxStream(128);
            tibjmsxStream2.encoding = tibjmsxStream.encoding;
            tibjmsxStream2.writeString(this._text, false);
            if (tibjmsxStream.writeCompressed(this._session, tibjmsxStream2.buffer, 0, tibjmsxStream2.curpos)) {
                return true;
            }
        }
        tibjmsxStream.writeString(this._text, false);
        return false;
    }

    @Override
    final void readBody(TibjmsxStream tibjmsxStream, boolean bl) throws EOFException, JMSException {
        int n = tibjmsxStream.readInt();
        int n2 = tibjmsxStream.curpos;
        if (!bl) {
            this._text = tibjmsxStream.readString(false);
        } else {
            byte[] byArray = tibjmsxStream.readCompressed();
            if (byArray == null) {
                this._text = null;
            } else if (byArray.length == 0) {
                this._text = "";
            } else {
                TibjmsxStream tibjmsxStream2 = new TibjmsxStream(byArray);
                tibjmsxStream2.encoding = tibjmsxStream.encoding;
                this._text = tibjmsxStream2.readString(false);
            }
        }
        this._readState = true;
        if (tibjmsxStream.curpos != n2 + n) {
            throw new JMSException("Corrupted TextMessage body");
        }
    }

    TibjmsTextMessage() {
        super(3);
        this._readState = false;
    }

    TibjmsTextMessage(TibjmsSession tibjmsSession) {
        super(tibjmsSession, 3);
    }

    TibjmsTextMessage(TibjmsSession tibjmsSession, String string) {
        super(tibjmsSession, 3);
        this._text = string;
    }

    public TibjmsTextMessage(byte[] byArray, int n) throws JMSException {
        super(3);
        this._read(byArray, n);
        this._readState = true;
    }

    @Override
    public Object clone() {
        TibjmsTextMessage tibjmsTextMessage = (TibjmsTextMessage)super.clone();
        if (tibjmsTextMessage == null) {
            return tibjmsTextMessage;
        }
        tibjmsTextMessage._text = this._text;
        return tibjmsTextMessage;
    }

    @Override
    public String getText() throws JMSException {
        if (!this._bodyLifted) {
            this._liftBody();
        }
        return this._text;
    }

    @Override
    public void setText(String string) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._text = string;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this._text = null;
        this._readState = false;
    }

    @Override
    public String toString() {
        try {
            if (!this._bodyLifted) {
                this._liftBody();
            }
        }
        catch (JMSException jMSException) {
            return "JMSException occurred while converting message into string: " + jMSException.getMessage();
        }
        String string = "TextMessage={" + super.toString();
        string = string + " Text={" + this._text + "}";
        string = string + " }";
        return string;
    }

    @Override
    public <T> T getBody(Class<T> clazz) throws JMSException {
        if (clazz == null) {
            throw new IllegalArgumentException("null class");
        }
        if (!this.isBodyAssignableTo(clazz)) {
            throw new MessageFormatException("Cannot convert body into " + clazz.getSimpleName() + ".");
        }
        if (!this._hasBody()) {
            return null;
        }
        return (T)this.getText();
    }

    @Override
    public boolean isBodyAssignableTo(Class clazz) throws JMSException {
        if (clazz == null) {
            throw new IllegalArgumentException("null class");
        }
        if (!this._hasBody()) {
            return true;
        }
        if (clazz == Object.class) {
            return true;
        }
        return String.class.isAssignableFrom(clazz);
    }
}

