/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsMessage;
import com.tibco.tibjms.TibjmsSession;
import com.tibco.tibjms.TibjmsxConst;
import com.tibco.tibjms.TibjmsxStream;
import java.io.EOFException;
import java.io.Serializable;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;

public class TibjmsStreamMessage
extends TibjmsMessage
implements StreamMessage,
Serializable,
Cloneable,
TibjmsxConst {
    private static final long serialVersionUID = 7017371183043433845L;
    Vector _elements = null;
    transient int _position = 0;
    transient byte[] _byteValue = null;
    transient int _bytePos = 0;
    private boolean _extmode = false;
    private static final String _RBP = "readBytes in progress";

    @Override
    final boolean _hasBody() throws JMSException {
        if (!this._bodyLifted) {
            this._liftBody();
        }
        if (this._elements == null) {
            return false;
        }
        return this._elements.size() > 0;
    }

    @Override
    final boolean writeBody(TibjmsxStream tibjmsxStream, boolean bl) throws JMSException {
        if (!this._bodyLifted) {
            this._liftBody();
        }
        if (this._elements == null) {
            return false;
        }
        if (this._elements.size() == 0) {
            return false;
        }
        TibjmsxStream tibjmsxStream2 = tibjmsxStream;
        if (bl) {
            tibjmsxStream2 = new TibjmsxStream(128);
            tibjmsxStream2.encoding = tibjmsxStream.encoding;
        }
        for (int j = 0; j < this._elements.size(); ++j) {
            tibjmsxStream2.writeObject(this._elements.elementAt(j), 255, true);
        }
        if (bl) {
            if (tibjmsxStream.writeCompressed(this._session, tibjmsxStream2.buffer, 0, tibjmsxStream2.curpos)) {
                return true;
            }
            tibjmsxStream.write(tibjmsxStream2.buffer, 0, tibjmsxStream2.curpos);
        }
        return false;
    }

    @Override
    final void readBody(TibjmsxStream tibjmsxStream, boolean bl) throws EOFException, JMSException {
        int n = tibjmsxStream.readInt();
        int n2 = tibjmsxStream.curpos;
        if (this._elements == null) {
            this._elements = new Vector();
        } else {
            this._elements.clear();
        }
        if (n > 0) {
            if (!bl) {
                while (tibjmsxStream.curpos < n2 + n) {
                    this._elements.addElement(tibjmsxStream.readObject());
                }
                if (tibjmsxStream.curpos != n2 + n) {
                    throw new JMSException("Corrupted StreamMessage body");
                }
            } else {
                byte[] byArray = tibjmsxStream.readCompressed();
                if (byArray != null) {
                    TibjmsxStream tibjmsxStream2 = new TibjmsxStream(byArray, 0, byArray.length);
                    tibjmsxStream2.encoding = tibjmsxStream.encoding;
                    while (tibjmsxStream2.curpos < tibjmsxStream2.buflen) {
                        this._elements.addElement(tibjmsxStream2.readObject());
                    }
                    if (tibjmsxStream2.curpos != tibjmsxStream2.buflen) {
                        throw new JMSException("Corrupted MapMessage body");
                    }
                }
            }
        }
        this._readState = true;
        this._position = 0;
    }

    @Override
    void _setBodyWriteable() throws JMSException {
        this._check();
        this._position = this._elements.size();
        this._byteValue = null;
        this._bytePos = 0;
        this._readState = false;
    }

    TibjmsStreamMessage() {
        super(2);
        this._position = 0;
        this._readState = false;
        this._byteValue = null;
        this._bytePos = 0;
    }

    TibjmsStreamMessage(TibjmsSession tibjmsSession) {
        super(tibjmsSession, 2);
        this._position = 0;
        this._readState = false;
        this._byteValue = null;
        this._bytePos = 0;
    }

    TibjmsStreamMessage(byte[] byArray, int n) throws JMSException {
        super(2);
        this._read(byArray, n);
        this._readState = true;
        this._position = 0;
    }

    void resetMessageAfterOnMessageException() {
        try {
            this.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object clone() {
        TibjmsStreamMessage tibjmsStreamMessage = (TibjmsStreamMessage)super.clone();
        if (tibjmsStreamMessage == null) {
            return tibjmsStreamMessage;
        }
        if (this._elements != null) {
            for (int j = 0; j < this._elements.size(); ++j) {
                Object e;
                Object object = e = this._elements.elementAt(j);
                if (e != null && e instanceof byte[]) {
                    byte[] byArray = (byte[])e;
                    byte[] byArray2 = new byte[byArray.length];
                    if (byArray.length > 0) {
                        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    }
                    object = byArray2;
                }
                tibjmsStreamMessage._elements.addElement(object);
            }
        }
        return tibjmsStreamMessage;
    }

    private final void _check() throws JMSException {
        if (!this._bodyLifted) {
            this._liftBody();
        }
        if (this._elements == null) {
            this._elements = new Vector();
        }
    }

    public int getFieldCount() throws JMSException {
        this._check();
        return this._elements.size();
    }

    @Override
    public boolean readBoolean() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this._byteValue != null) {
            throw new MessageFormatException(_RBP);
        }
        this._check();
        if (this._position >= this._elements.size()) {
            throw new MessageEOFException("End of message stream");
        }
        boolean bl = TibjmsStreamMessage.asBoolean(this._elements.elementAt(this._position), null);
        ++this._position;
        return bl;
    }

    @Override
    public byte readByte() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this._byteValue != null) {
            throw new MessageFormatException(_RBP);
        }
        this._check();
        if (this._position >= this._elements.size()) {
            throw new MessageEOFException("End of message stream");
        }
        byte by = TibjmsStreamMessage.asByte(this._elements.elementAt(this._position), null);
        ++this._position;
        return by;
    }

    @Override
    public short readShort() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this._byteValue != null) {
            throw new MessageFormatException(_RBP);
        }
        this._check();
        if (this._position >= this._elements.size()) {
            throw new MessageEOFException("End of message stream");
        }
        short s = TibjmsStreamMessage.asShort(this._elements.elementAt(this._position), null);
        ++this._position;
        return s;
    }

    @Override
    public char readChar() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this._byteValue != null) {
            throw new MessageFormatException(_RBP);
        }
        this._check();
        if (this._position >= this._elements.size()) {
            throw new MessageEOFException("End of message stream");
        }
        char c = this.asChar(this._elements.elementAt(this._position), null);
        ++this._position;
        return c;
    }

    @Override
    public int readInt() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this._byteValue != null) {
            throw new MessageFormatException(_RBP);
        }
        this._check();
        if (this._position >= this._elements.size()) {
            throw new MessageEOFException("End of message stream");
        }
        int n = TibjmsStreamMessage.asInteger(this._elements.elementAt(this._position), null);
        ++this._position;
        return n;
    }

    @Override
    public long readLong() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this._byteValue != null) {
            throw new MessageFormatException(_RBP);
        }
        this._check();
        if (this._position >= this._elements.size()) {
            throw new MessageEOFException("End of message stream");
        }
        long l = TibjmsStreamMessage.asLong(this._elements.elementAt(this._position), null);
        ++this._position;
        return l;
    }

    @Override
    public float readFloat() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this._byteValue != null) {
            throw new MessageFormatException(_RBP);
        }
        this._check();
        if (this._position >= this._elements.size()) {
            throw new MessageEOFException("End of message stream");
        }
        float f = TibjmsStreamMessage.asFloat(this._elements.elementAt(this._position), null);
        ++this._position;
        return f;
    }

    @Override
    public double readDouble() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this._byteValue != null) {
            throw new MessageFormatException(_RBP);
        }
        this._check();
        if (this._position >= this._elements.size()) {
            throw new MessageEOFException("End of message stream");
        }
        double d = TibjmsStreamMessage.asDouble(this._elements.elementAt(this._position), null);
        ++this._position;
        return d;
    }

    @Override
    public String readString() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this._byteValue != null) {
            throw new MessageFormatException(_RBP);
        }
        this._check();
        if (this._position >= this._elements.size()) {
            throw new MessageEOFException("End of message stream");
        }
        String string = TibjmsStreamMessage.asString(this._elements.elementAt(this._position), null);
        ++this._position;
        return string;
    }

    @Override
    public int readBytes(byte[] byArray) throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        this._check();
        if (this._position >= this._elements.size()) {
            throw new MessageEOFException("End of message stream");
        }
        if (byArray == null) {
            throw new NullPointerException("null parameter");
        }
        if (this._byteValue == null) {
            this._byteValue = this.asBytes(this._elements.elementAt(this._position), null, false);
            this._bytePos = 0;
        }
        if (this._byteValue == null) {
            ++this._position;
            return -1;
        }
        if (this._byteValue.length == 0) {
            this._byteValue = null;
            ++this._position;
            return 0;
        }
        int n = byArray.length;
        int n2 = this._byteValue.length - this._bytePos;
        if (n2 <= 0) {
            this._byteValue = null;
            ++this._position;
            return -1;
        }
        int n3 = n <= n2 ? n : n2;
        System.arraycopy(this._byteValue, this._bytePos, byArray, 0, n3);
        this._bytePos += n3;
        if (n3 < n) {
            this._byteValue = null;
            ++this._position;
        }
        return n3;
    }

    @Override
    public Object readObject() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this._byteValue != null) {
            throw new MessageFormatException(_RBP);
        }
        this._check();
        if (this._position >= this._elements.size()) {
            throw new MessageEOFException("End of message stream");
        }
        Object e = this._elements.elementAt(this._position);
        ++this._position;
        if (e != null && e instanceof byte[]) {
            return this.asBytes(e, null, true);
        }
        return e;
    }

    @Override
    public void writeBoolean(boolean bl) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._check();
        this._elements.addElement(bl ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void writeByte(byte by) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._check();
        this._elements.addElement(new Byte(by));
    }

    @Override
    public void writeShort(short s) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._check();
        this._elements.addElement(new Short(s));
    }

    @Override
    public void writeChar(char c) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._check();
        this._elements.addElement(new Character(c));
    }

    @Override
    public void writeInt(int n) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._check();
        this._elements.addElement(new Integer(n));
    }

    @Override
    public void writeLong(long l) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._check();
        this._elements.addElement(new Long(l));
    }

    @Override
    public void writeFloat(float f) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._check();
        this._elements.addElement(new Float(f));
    }

    @Override
    public void writeDouble(double d) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._check();
        this._elements.addElement(new Double(d));
    }

    @Override
    public void writeString(String string) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._check();
        this._elements.addElement(string);
    }

    @Override
    public void writeBytes(byte[] byArray) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._check();
        this._elements.addElement(this._copyBytes(byArray));
    }

    @Override
    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._check();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            this._elements.addElement(new byte[0]);
        } else {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this._elements.addElement(byArray2);
        }
    }

    @Override
    public void writeObject(Object object) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._check();
        if (object != null && TibjmsStreamMessage.getFieldType(object) == 255) {
            int n;
            if (!this._extmode) {
                this._extmode = this.propertyExists("JMS_TIBCO_MSG_EXT");
                if (!this._extmode) {
                    throw new MessageFormatException("Invalid value of class " + object.getClass().getName());
                }
            }
            if ((n = TibjmsStreamMessage.getExtendedType(object)) == 255) {
                throw new MessageFormatException("Invalid value of class " + object.getClass().getName());
            }
        }
        if (object instanceof byte[]) {
            this._elements.addElement(this._copyBytes((byte[])object));
        } else {
            this._elements.addElement(object);
        }
    }

    @Override
    public void reset() throws JMSException {
        this._check();
        this._readState = true;
        this._position = 0;
        this._byteValue = null;
        this._bytePos = 0;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        if (this._elements == null) {
            this._elements = new Vector();
        }
        this._elements.removeAllElements();
        this._readState = false;
        this._position = 0;
        this._byteValue = null;
        this._bytePos = 0;
    }

    @Override
    public String toString() {
        try {
            if (!this._bodyLifted) {
                this._liftBody();
            }
        }
        catch (JMSException jMSException) {
            return "JMSException occurred while converting message into string: " + jMSException.getMessage();
        }
        String string = "StreamMessage={" + super.toString();
        string = string + " Fields={" + this._fieldsToString() + " } }";
        return string;
    }

    String _fieldsToString() {
        try {
            if (!this._bodyLifted) {
                this._liftBody();
            }
        }
        catch (JMSException jMSException) {
            return "JMSException occurred while converting message into string: " + jMSException.getMessage();
        }
        if (this._elements == null || this._elements.size() == 0) {
            return "";
        }
        String string = "";
        for (int j = 0; j < this._elements.size(); ++j) {
            string = string + " {" + this._toTypedString(this._elements.elementAt(j)) + "}";
        }
        return string;
    }

    @Override
    public <T> T getBody(Class<T> clazz) throws JMSException {
        if (clazz == null) {
            throw new IllegalArgumentException("null class");
        }
        throw new MessageFormatException("StreamMessages are not supported.");
    }

    @Override
    public boolean isBodyAssignableTo(Class clazz) throws JMSException {
        if (clazz == null) {
            throw new IllegalArgumentException("null class");
        }
        return false;
    }
}

