/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsConnectionFactory;
import com.tibco.tibjms.TibjmsQueue;
import com.tibco.tibjms.TibjmsQueueConnectionFactory;
import com.tibco.tibjms.TibjmsTopic;
import com.tibco.tibjms.TibjmsTopicConnectionFactory;
import com.tibco.tibjms.TibjmsXAConnectionFactory;
import com.tibco.tibjms.TibjmsXAQueueConnectionFactory;
import com.tibco.tibjms.TibjmsXATopicConnectionFactory;
import com.tibco.tibjms.Tibjmsx;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TibjmsSAXHandler
extends DefaultHandler {
    private static Object adminObj;
    private static SAXParserFactory factory;
    private static SAXParser saxParser;
    private String url;
    private String clientID;
    private String xa;
    private String destType;
    private HashMap properties;
    private boolean inTrusted;
    private boolean inIssuer;
    private boolean inClientID;

    public TibjmsSAXHandler() {
        factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        try {
            saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(parserConfigurationException);
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            System.err.println(sAXException);
            sAXException.printStackTrace();
        }
    }

    public static Object xmlToObject(InputStream inputStream2, DefaultHandler defaultHandler) {
        try {
            saxParser.parse(inputStream2, defaultHandler);
        }
        catch (SAXParseException sAXParseException) {
            System.err.print("\n** Parsing error: ");
            System.err.println(sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return adminObj;
    }

    @Override
    public void startDocument() throws SAXException {
        adminObj = null;
        this.url = null;
        this.clientID = null;
        this.xa = null;
        this.destType = null;
        this.properties = null;
        this.inClientID = false;
        this.inTrusted = false;
        this.inIssuer = false;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.properties != null) {
            if (this.xa.equals("disabled")) {
                if (this.destType.equals("generic")) {
                    adminObj = new TibjmsConnectionFactory(this.url, this.clientID, this.properties);
                } else if (this.destType.equals("topic")) {
                    adminObj = new TibjmsTopicConnectionFactory(this.url, this.clientID, this.properties);
                } else if (this.destType.equals("queue")) {
                    adminObj = new TibjmsQueueConnectionFactory(this.url, this.clientID, this.properties);
                }
            } else if (this.destType.equals("generic")) {
                adminObj = new TibjmsXAConnectionFactory(this.url, this.clientID, this.properties);
            } else if (this.destType.equals("topic")) {
                adminObj = new TibjmsXATopicConnectionFactory(this.url, this.clientID, this.properties);
            } else if (this.destType.equals("queue")) {
                adminObj = new TibjmsXAQueueConnectionFactory(this.url, this.clientID, this.properties);
            }
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (attributes == null) {
            return;
        }
        if (string3.equals("queue")) {
            for (int j = 0; j < attributes.getLength(); ++j) {
                String string4;
                String string5 = attributes.getQName(j);
                if (!string5.equals("name") || "".equals(string4 = attributes.getValue(j))) continue;
                adminObj = new TibjmsQueue(string4);
            }
        } else if (string3.equals("topic")) {
            for (int j = 0; j < attributes.getLength(); ++j) {
                String string6;
                String string7 = attributes.getQName(j);
                if (!string7.equals("name") || "".equals(string6 = attributes.getValue(j))) continue;
                adminObj = new TibjmsTopic(string6);
            }
        } else if (string3.equals("connection-factory")) {
            if (this.properties == null) {
                this.properties = new HashMap(5);
            }
            this.parseConnectionFactory(attributes);
        } else if (string3.equals("parameter")) {
            this.parseParameter(attributes);
        } else if (string3.equals("SSL-parameters")) {
            this.parseSSLParameters(attributes);
        } else if (string3.equals("client-identity")) {
            this.inClientID = true;
            for (int j = 0; j < attributes.getLength(); ++j) {
                String string8 = attributes.getQName(j);
                if (!string8.equals("password")) continue;
                this.properties.put("com.tibco.tibjms.ssl.password", attributes.getValue(j));
                break;
            }
        } else if (string3.equals("trusted")) {
            this.inTrusted = true;
        } else if (string3.equals("issuer")) {
            this.inIssuer = true;
        } else if (string3.equals("certificate")) {
            this.parseCertificates(attributes);
        } else if (string3.equals("private-key")) {
            this.parsePrivateKey(attributes);
        }
    }

    private void parsePrivateKey(Attributes attributes) {
        for (int j = 0; j < attributes.getLength(); ++j) {
            String string = attributes.getQName(j);
            if (string.equals("encoding")) {
                this.properties.put("com.tibco.tibjms.ssl.private_key_encoding", attributes.getValue(j));
                continue;
            }
            if (!string.equals("base64-data")) continue;
            String string2 = attributes.getValue(j);
            if (string2.startsWith("file://")) {
                this.properties.put("com.tibco.tibjms.ssl.private_key", string2.substring(7));
                continue;
            }
            this.properties.put("com.tibco.tibjms.ssl.private_key", Tibjmsx.base64Decode(string2, true));
        }
    }

    private void parseCertificates(Attributes attributes) {
        Object object;
        String string = null;
        String string2 = null;
        for (int j = 0; j < attributes.getLength(); ++j) {
            object = attributes.getQName(j);
            if (((String)object).equals("encoding")) {
                string = attributes.getValue(j);
                continue;
            }
            if (!((String)object).equals("base64-data")) continue;
            string2 = attributes.getValue(j);
        }
        if (string2 != null) {
            if (this.inClientID) {
                this.properties.put("com.tibco.tibjms.ssl.identity_encoding", string);
                if (string2.startsWith("file://")) {
                    this.properties.put("com.tibco.tibjms.ssl.identity", string2.substring(7));
                } else {
                    this.properties.put("com.tibco.tibjms.ssl.identity", Tibjmsx.base64Decode(string2, true));
                }
            } else if (this.inTrusted) {
                Vector<Integer> vector = (Vector<Integer>)this.properties.get("com.tibco.tibjms.ssl.trusted_certs");
                if (vector == null) {
                    vector = new Vector<Integer>();
                    this.properties.put("com.tibco.tibjms.ssl.trusted_certs", vector);
                }
                if (string != null) {
                    object = new Integer(string);
                    vector.add((Integer)object);
                } else {
                    vector.add(new Integer(0));
                }
                if (string2.startsWith("file://")) {
                    vector.add((Integer)((Object)string2.substring(7)));
                } else {
                    vector.add((Integer)Tibjmsx.base64Decode(string2, true));
                }
            } else if (this.inIssuer) {
                Vector<Integer> vector = (Vector<Integer>)this.properties.get("com.tibco.tibjms.ssl.issuer_certs");
                if (vector == null) {
                    vector = new Vector<Integer>();
                    this.properties.put("com.tibco.tibjms.ssl.issuer_certs", vector);
                }
                if (string != null) {
                    object = new Integer(string);
                    vector.add((Integer)object);
                } else {
                    vector.add(new Integer(0));
                }
                if (string2.startsWith("file://")) {
                    vector.add((Integer)((Object)string2.substring(7)));
                } else {
                    vector.add((Integer)Tibjmsx.base64Decode(string2, true));
                }
            }
        }
    }

    private void parseSSLParameters(Attributes attributes) {
        for (int j = 0; j < attributes.getLength(); ++j) {
            String string = attributes.getQName(j);
            if (string.equals("vendor")) {
                this.properties.put("com.tibco.tibjms.ssl.vendor", attributes.getValue(j));
                continue;
            }
            if (string.equals("trace")) {
                if (attributes.getValue(j).equals("enabled")) {
                    this.properties.put("com.tibco.tibjms.ssl.trace", Boolean.TRUE);
                    continue;
                }
                this.properties.put("com.tibco.tibjms.ssl.trace", Boolean.FALSE);
                continue;
            }
            if (string.equals("debug-trace")) {
                if (attributes.getValue(j).equals("enabled")) {
                    this.properties.put("com.tibco.tibjms.ssl.debug_trace", Boolean.TRUE);
                    continue;
                }
                this.properties.put("com.tibco.tibjms.ssl.debug_trace", Boolean.FALSE);
                continue;
            }
            if (string.equals("verify-host")) {
                if (attributes.getValue(j).equals("enabled")) {
                    this.properties.put("com.tibco.tibjms.ssl.enable_verify_host", Boolean.TRUE);
                    continue;
                }
                this.properties.put("com.tibco.tibjms.ssl.enable_verify_host", Boolean.FALSE);
                continue;
            }
            if (string.equals("verify-hostname")) {
                if (attributes.getValue(j).equals("enabled")) {
                    this.properties.put("com.tibco.tibjms.ssl.enable_verify_hostname", Boolean.TRUE);
                    continue;
                }
                this.properties.put("com.tibco.tibjms.ssl.enable_verify_hostname", Boolean.FALSE);
                continue;
            }
            if (string.equals("expected-hostname")) {
                this.properties.put("com.tibco.tibjms.ssl.expected_hostname", attributes.getValue(j));
                continue;
            }
            if (!string.equals("ciphers")) continue;
            this.properties.put("com.tibco.tibjms.ssl.cipher_suites", attributes.getValue(j));
        }
    }

    private void parseParameter(Attributes attributes) {
        String string = null;
        String string2 = null;
        for (int j = 0; j < attributes.getLength(); ++j) {
            String string3 = attributes.getQName(j);
            if (string3.equals("name")) {
                string = attributes.getValue(j);
                continue;
            }
            if (!string3.equals("value")) continue;
            string2 = attributes.getValue(j);
        }
        if (string.equals("load-balance-metric")) {
            try {
                this.properties.put("com.tibco.tibjms.factory.metric", new Integer(string2));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        } else if (string.equals("connect-attempt-count")) {
            try {
                this.properties.put("com.tibco.tibjms.connect.attemptcount", new Integer(string2));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        } else if (string.equals("connect-attempt-delay")) {
            try {
                this.properties.put("com.tibco.tibjms.connect.attemptdelay", new Integer(string2));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        } else if (string.equals("connect-attempt-timeout")) {
            try {
                this.properties.put("com.tibco.tibjms.connect.attempttimeout", new Integer(string2));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        } else if (string.equals("reconnect-attempt-count")) {
            try {
                this.properties.put("com.tibco.tibjms.reconnect.attemptcount", new Integer(string2));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        } else if (string.equals("reconnect-attempt-delay")) {
            try {
                this.properties.put("com.tibco.tibjms.reconnect.attemptdelay", new Integer(string2));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        } else if (string.equals("reconnect-attempt-timeout")) {
            try {
                this.properties.put("com.tibco.tibjms.reconnect.attempttimeout", new Integer(string2));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        } else if (string.equals("multicast")) {
            if (string2.equals("enabled")) {
                this.properties.put("com.tibco.tibjms.multicast.enabled", Boolean.TRUE);
            } else {
                this.properties.put("com.tibco.tibjms.multicast.enabled", Boolean.FALSE);
            }
        } else if (string.equals("multicast-daemon")) {
            this.properties.put("com.tibco.tibjms.multicast.daemon", string2);
        } else if (string.equals("auth-only") && string2.equals("enabled")) {
            this.properties.put("com.tibco.tibjms.ssl.auth_only", Boolean.TRUE);
        }
    }

    private void parseConnectionFactory(Attributes attributes) {
        for (int j = 0; j < attributes.getLength(); ++j) {
            String string = attributes.getQName(j);
            if (string.equals("URL")) {
                this.url = attributes.getValue(j);
                continue;
            }
            if (string.equals("client-ID")) {
                this.clientID = attributes.getValue(j);
                continue;
            }
            if (string.equals("destination-type")) {
                this.destType = attributes.getValue(j);
                continue;
            }
            if (!string.equals("XA")) continue;
            this.xa = attributes.getValue(j);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.inClientID) {
            this.inClientID = false;
        }
        if (string3.equals("trusted")) {
            this.inTrusted = false;
        }
        if (string3.equals("issuer")) {
            this.inIssuer = false;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (string2.equals("http://www.tibco.com/dtd/administered-object.dtd")) {
            try {
                InputStream inputStream2 = TibjmsSAXHandler.locateDTDFile("administered-object.dtd");
                if (inputStream2 == null) {
                    throw new Exception("This software package is corrupted, files are missing or invalid");
                }
                return new InputSource(inputStream2);
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static InputStream locateDTDFile(String string) {
        File file = new File(string);
        InputStream inputStream2 = null;
        if (file.exists()) {
            try {
                inputStream2 = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException);
                fileNotFoundException.printStackTrace();
            }
        } else {
            inputStream2 = TibjmsSAXHandler.class.getResourceAsStream(string);
            if (inputStream2 == null) {
                inputStream2 = ClassLoader.getSystemResourceAsStream(string);
            }
        }
        return inputStream2;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.print("** Warning: ");
        System.out.println(sAXParseException.getMessage());
    }
}

