/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsMessage;
import com.tibco.tibjms.TibjmsSession;
import com.tibco.tibjms.TibjmsxConst;
import com.tibco.tibjms.TibjmsxStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;

public class TibjmsObjectMessage
extends TibjmsMessage
implements ObjectMessage,
Serializable,
Cloneable,
TibjmsxConst {
    static boolean useExtendedObjInputStream = false;
    private static final long serialVersionUID = -4631903241458732988L;
    byte[] _bytes = null;

    @Override
    final boolean _hasBody() throws JMSException {
        if (!this._bodyLifted) {
            this._liftBody();
        }
        if (this._bytes == null) {
            return false;
        }
        return this._bytes.length > 0;
    }

    @Override
    final boolean writeBody(TibjmsxStream tibjmsxStream, boolean bl) throws JMSException {
        if (!this._bodyLifted) {
            this._liftBody();
        }
        if (bl && this._bytes != null && this._bytes.length > 0 && tibjmsxStream.writeCompressed(this._session, this._bytes, 0, this._bytes.length)) {
            return true;
        }
        tibjmsxStream.writeBytes(this._bytes);
        return false;
    }

    @Override
    final void readBody(TibjmsxStream tibjmsxStream, boolean bl) throws EOFException, JMSException {
        int n = tibjmsxStream.readInt();
        int n2 = tibjmsxStream.curpos;
        this._bytes = null;
        this._bytes = !bl ? tibjmsxStream.readBytes() : tibjmsxStream.readCompressed();
        this._readState = true;
        if (tibjmsxStream.curpos != n2 + n) {
            throw new JMSException("Corrupted ObjectMessage body");
        }
    }

    public TibjmsObjectMessage() {
        super(4);
        this._readState = false;
    }

    TibjmsObjectMessage(TibjmsSession tibjmsSession) {
        super(tibjmsSession, 4);
        this._readState = false;
    }

    TibjmsObjectMessage(TibjmsSession tibjmsSession, Serializable serializable) throws JMSException {
        super(tibjmsSession, 4);
        this.setObject(serializable);
        this._readState = false;
    }

    public TibjmsObjectMessage(byte[] byArray, int n) throws JMSException {
        super(4);
        this._read(byArray, n);
        this._readState = true;
    }

    @Override
    public Object clone() {
        TibjmsObjectMessage tibjmsObjectMessage = (TibjmsObjectMessage)super.clone();
        if (tibjmsObjectMessage == null) {
            return tibjmsObjectMessage;
        }
        if (this._bytes != null) {
            tibjmsObjectMessage._bytes = new byte[this._bytes.length];
            if (this._bytes.length > 0) {
                System.arraycopy(tibjmsObjectMessage._bytes, 0, this._bytes, 0, this._bytes.length);
            }
        }
        return tibjmsObjectMessage;
    }

    private ObjectInputStream getExtendedObjectInputStream(ByteArrayInputStream byteArrayInputStream) throws IOException {
        ClassLoader classLoader = null;
        ObjectInputStream objectInputStream = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            classLoader = null;
        }
        objectInputStream = classLoader == null ? new ObjectInputStream(byteArrayInputStream) : new CLOIS(byteArrayInputStream, classLoader);
        return objectInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable getObject() throws JMSException {
        Serializable serializable;
        Exception exception = null;
        if (!this._bodyLifted) {
            this._liftBody();
        }
        if (this._bytes == null) {
            return null;
        }
        ObjectInputStream objectInputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        Serializable serializable2 = null;
        boolean bl = false;
        byteArrayInputStream = new ByteArrayInputStream(this._bytes);
        do {
            try {
                objectInputStream = useExtendedObjInputStream || bl ? this.getExtendedObjectInputStream(byteArrayInputStream) : new ObjectInputStream(byteArrayInputStream);
                serializable = serializable2 = (Serializable)objectInputStream.readObject();
                return serializable;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!useExtendedObjInputStream && !bl) {
                    byteArrayInputStream.reset();
                    bl = true;
                    continue;
                }
                exception = classNotFoundException;
            }
            catch (OptionalDataException optionalDataException) {
                exception = optionalDataException;
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            finally {
                try {
                    objectInputStream.close();
                }
                catch (Exception exception2) {}
            }
        } while (exception == null);
        serializable = new MessageFormatException("Deserialization failed: " + exception.getMessage());
        ((JMSException)serializable).setLinkedException(exception);
        throw serializable;
    }

    @Override
    public void setObject(Serializable serializable) throws JMSException {
        Exception exception = null;
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.close();
            this._bytes = byteArrayOutputStream.toByteArray();
            return;
        }
        catch (InvalidClassException invalidClassException) {
            exception = invalidClassException;
        }
        catch (NotSerializableException notSerializableException) {
            exception = notSerializableException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        MessageFormatException messageFormatException = new MessageFormatException("Serialization failed: " + exception.getMessage());
        messageFormatException.setLinkedException(exception);
        throw messageFormatException;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this._readState = false;
        this._bytes = null;
    }

    @Override
    public String toString() {
        try {
            if (!this._bodyLifted) {
                this._liftBody();
            }
        }
        catch (JMSException jMSException) {
            return "JMSException occurred while converting message into string: " + jMSException.getMessage();
        }
        String string = "ObjectMessage={" + super.toString();
        String string2 = "?";
        try {
            Serializable serializable = this.getObject();
            string2 = "" + serializable;
        }
        catch (Throwable throwable) {
            string2 = "?";
        }
        string = string + " Object={" + string2 + "} }";
        return string;
    }

    @Override
    public <T> T getBody(Class<T> clazz) throws JMSException {
        Serializable serializable = null;
        if (clazz == null) {
            throw new IllegalArgumentException("null class");
        }
        if (!this.isBodyAssignableTo(clazz)) {
            throw new MessageFormatException("Cannot convert body into " + clazz.getSimpleName() + ".");
        }
        if (!this._hasBody()) {
            return null;
        }
        try {
            serializable = this.getObject();
        }
        catch (Exception exception) {
            MessageFormatException messageFormatException = new MessageFormatException("Could not deserialize");
            messageFormatException.setLinkedException(exception);
            throw messageFormatException;
        }
        return (T)serializable;
    }

    @Override
    public boolean isBodyAssignableTo(Class clazz) throws JMSException {
        if (clazz == null) {
            throw new IllegalArgumentException("null class");
        }
        if (!this._hasBody()) {
            return true;
        }
        if (clazz == Serializable.class) {
            return true;
        }
        return clazz.isInstance(this.getObject());
    }

    static {
        try {
            if (System.getProperty("com.tibco.tibjms.use_extended_objinpstrm") != null) {
                useExtendedObjInputStream = true;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class CLOIS
    extends ObjectInputStream {
        ClassLoader _classLoader;

        CLOIS(ByteArrayInputStream byteArrayInputStream, ClassLoader classLoader) throws IOException {
            super(byteArrayInputStream);
            this._classLoader = null;
            this._classLoader = classLoader;
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(objectStreamClass.getName(), false, this._classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.resolveClass(objectStreamClass);
            }
        }
    }
}

