/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsConnection;
import com.tibco.tibjms.TibjmsDestination;
import com.tibco.tibjms.TibjmsJMSContext;
import com.tibco.tibjms.TibjmsMessage;
import com.tibco.tibjms.TibjmsObjectMessage;
import com.tibco.tibjms.TibjmsStreamMessage;
import com.tibco.tibjms.TibjmsxConst;
import com.tibco.tibjms.TibjmsxDPQMember;
import com.tibco.tibjms.TibjmsxPQueue;
import com.tibco.tibjms.TibjmsxSessionImp;
import com.tibco.tibjms.TibjmsxTrace;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageFormatException;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

class TibjmsMessageConsumer
extends TibjmsxDPQMember
implements MessageConsumer,
TibjmsxConst {
    private TibjmsxSessionImp _session = null;
    TibjmsDestination _destination = null;
    String _selector = null;
    MessageListener _listener = null;
    String _subName = null;
    String _durableName = null;
    boolean _isShared = false;
    boolean _noLocal = false;
    boolean _routed = false;
    boolean _isQueue = false;
    boolean _activated = false;
    boolean _receiving = false;
    boolean _newNoPrefetch = false;
    int _receiveId = 0;
    boolean _noPrefetch = false;
    long _consid = 0L;
    private boolean _closed = false;
    Object _lock = new Object();
    private TibjmsxPQueue _msgQueue = new TibjmsxPQueue();
    FlowCounter[] _fc = new FlowCounter[]{new FlowCounter(), new FlowCounter()};
    boolean _hadMessage = true;
    boolean _needQuery = false;
    boolean _forUndelivered = false;
    boolean _isMulticast = false;
    boolean _createdAsMulticast = false;
    boolean _isWildcard = false;
    boolean _isFake = false;

    TibjmsxSessionImp _getSession() {
        return this._session;
    }

    @Override
    int getDPQPriority() {
        return this._msgQueue.getPriority();
    }

    boolean _isClosed() {
        return this._closed || this._session._closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int _getMsgCount() {
        Object object = this._lock;
        synchronized (object) {
            return this._msgQueue.size();
        }
    }

    void _changeReceiveId(int n) {
        this._receiveId = n > Integer.MIN_VALUE ? n - 1 : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _addMessage(TibjmsMessage tibjmsMessage) {
        Object object = this._lock;
        synchronized (object) {
            if (this._closed || this._session._closed) {
                return false;
            }
            TibjmsConnection tibjmsConnection = null;
            TibjmsxSessionImp tibjmsxSessionImp = this._session;
            if (tibjmsxSessionImp != null) {
                tibjmsConnection = tibjmsxSessionImp._connection;
            }
            if (this._isClosed() || tibjmsxSessionImp == null || tibjmsConnection == null) {
                return false;
            }
            tibjmsMessage._session = this._session;
            tibjmsMessage._consumer = this;
            this._msgQueue.addMessage(tibjmsMessage);
            if (tibjmsMessage._responseID > 0) {
                if (tibjmsMessage._linkType != -1) {
                    int n = this._fc[tibjmsMessage._linkType].consumed + this._msgQueue.size();
                    this._fc[tibjmsMessage._linkType].request = tibjmsMessage._responseID > n ? n : tibjmsMessage._responseID;
                }
                tibjmsMessage._responseID = 0;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TibjmsMessage _getNextMessage(Class<?> clazz) {
        Object object = this._lock;
        synchronized (object) {
            TibjmsMessage tibjmsMessage = null;
            if (clazz != null && (this._session._ackMode == 1 || this._session._ackMode == 3) && (tibjmsMessage = (TibjmsMessage)this._msgQueue.peek()) != null) {
                try {
                    if (tibjmsMessage instanceof TibjmsStreamMessage) {
                        throw new MessageFormatRuntimeException("StreamMessages are not supported.");
                    }
                    if (!tibjmsMessage._hasBody()) {
                        throw new MessageFormatRuntimeException("The message has no body.");
                    }
                    if (!tibjmsMessage.isBodyAssignableTo(clazz)) {
                        throw new MessageFormatRuntimeException("Cannot convert body into " + clazz.getSimpleName() + ".");
                    }
                    if (tibjmsMessage instanceof TibjmsObjectMessage) {
                        tibjmsMessage.getBody(clazz);
                    }
                }
                catch (MessageFormatException messageFormatException) {
                    throw TibjmsJMSContext._buildMessageFormatRuntimeException(messageFormatException);
                }
                catch (JMSException jMSException) {
                    throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
                }
            }
            if ((tibjmsMessage = (TibjmsMessage)this._msgQueue.get()) != null) {
                if (tibjmsMessage._linkType != -1) {
                    ++this._fc[tibjmsMessage._linkType].consumed;
                }
                this._needQuery = false;
                this._hadMessage = true;
            } else {
                this._needQuery = this._hadMessage;
                this._hadMessage = false;
            }
            return tibjmsMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message _receive(long l, Class<?> clazz) throws JMSException {
        Object object = this._lock;
        synchronized (object) {
            if (this._isClosed()) {
                throw new IllegalStateException("Consumer is closed");
            }
        }
        return this._session._receive(this, l, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _clearMessages() {
        Object object = this._lock;
        synchronized (object) {
            this._msgQueue.clear();
            for (int j = 0; j < this._fc.length; ++j) {
                this._fc[j].consumed = 0;
                this._fc[j].request = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _close() throws JMSException {
        boolean bl = false;
        Object object = this._lock;
        synchronized (object) {
            if (this._closed || this._session._closed) {
                return;
            }
            this._closed = true;
            bl = true;
        }
        if (bl) {
            this._session._closeConsumer(this);
            this._clearMessages();
            this._listener = null;
        }
    }

    TibjmsMessageConsumer(TibjmsxSessionImp tibjmsxSessionImp, TibjmsDestination tibjmsDestination, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        this._session = tibjmsxSessionImp;
        this._destination = tibjmsDestination;
        this._selector = string;
        this._noLocal = bl3;
        this._isQueue = tibjmsDestination instanceof Queue;
        this._isShared = bl2;
        this._subName = string2;
        this._durableName = bl ? string2 : null;
    }

    protected String _getTypeStr() {
        String string = "";
        if (this._isShared) {
            string = "Shared";
        }
        string = this instanceof TopicSubscriber ? string + "TopicSubscriber" : (this instanceof QueueReceiver ? string + "QueueReceiver" : string + "Consumer");
        return string;
    }

    @Override
    public String getMessageSelector() throws JMSException {
        if (this._closed || this._session._closed) {
            throw new IllegalStateException("Consumer is closed");
        }
        return this._selector;
    }

    @Override
    public MessageListener getMessageListener() throws JMSException {
        if (this._closed || this._session._closed) {
            throw new IllegalStateException("Consumer is closed");
        }
        return this._listener;
    }

    @Override
    public void setMessageListener(MessageListener messageListener) throws JMSException {
        if (this._closed || this._session._closed) {
            throw new IllegalStateException("Consumer is closed");
        }
        TibjmsxSessionImp tibjmsxSessionImp = this._session;
        if (tibjmsxSessionImp != null) {
            tibjmsxSessionImp._setListener(this, messageListener);
            if (messageListener == null) {
                this._hadMessage = true;
                this._needQuery = false;
            }
        }
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "MsgConsumer SetMessageListener conn={0,number,###0.##} sess={1,number,###0.##} cons={2,number,###0.##} lsnr={3}", new Object[]{new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._consid), messageListener != null ? "{set}" : "{not set}"});
        }
    }

    @Override
    public Message receive() throws JMSException {
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "before Receive{0} conn={1,number,###0.##} sess={2,number,###0.##} cons={3,number,###0.##}", new Object[]{"", new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._consid)});
        }
        Message message = this._receive(0L, null);
        if (this._session._connection._traceTarget != 0) {
            if (message != null) {
                TibjmsxTrace.write(this._session._connection._traceTarget, "after Receive{0} conn={1,number,###0.##} sess={2,number,###0.##} cons={3,number,###0.##} seqid={4,number,###0.##} msgid={5}", new Object[]{"", new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._consid), new Long(((TibjmsMessage)message)._sequenceID), ((TibjmsMessage)message)._JMSMessageID != null ? ((TibjmsMessage)message)._JMSMessageID : "{not set}"});
            } else {
                TibjmsxTrace.write(this._session._connection._traceTarget, "after Receive{0} conn={1,number,###0.##} sess={2,number,###0.##} cons={3,number,###0.##} no msg received", new Object[]{"", new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._consid)});
            }
        }
        return message;
    }

    @Override
    public Message receive(long l) throws JMSException {
        if (l < 0L) {
            throw new IllegalArgumentException("negative timeout");
        }
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "before ReceiveTimeout conn={0,number,###0.##} sess={1,number,###0.##} cons={2,number,###0.##} timeout={3,number,###0.##}", new Object[]{new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._consid), new Long(l)});
        }
        Message message = this._receive(l, null);
        if (this._session._connection._traceTarget != 0) {
            if (message != null) {
                TibjmsxTrace.write(this._session._connection._traceTarget, "after ReceiveTimeout conn={0,number,###0.##} sess={1,number,###0.##} cons={2,number,###0.##} timeout={3,number,###0.##} seqid={4,number,###0.##} msgid={5}", new Object[]{new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._consid), new Long(l), new Long(((TibjmsMessage)message)._sequenceID), ((TibjmsMessage)message)._JMSMessageID != null ? ((TibjmsMessage)message)._JMSMessageID : "{not set}"});
            } else {
                TibjmsxTrace.write(this._session._connection._traceTarget, "after ReceiveTimeout conn={0,number,###0.##} sess={1,number,###0.##} cons={2,number,###0.##} timeout={3,number,###0.##} no msg received", new Object[]{new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._consid), new Long(l)});
            }
        }
        return message;
    }

    @Override
    public Message receiveNoWait() throws JMSException {
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "before Receive{0} conn={1,number,###0.##} sess={2,number,###0.##} cons={3,number,###0.##}", new Object[]{"NoWait", new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._consid)});
        }
        Message message = this._receive(-1L, null);
        if (this._session._connection._traceTarget != 0) {
            if (message != null) {
                TibjmsxTrace.write(this._session._connection._traceTarget, "after Receive{0} conn={1,number,###0.##} sess={2,number,###0.##} cons={3,number,###0.##} seqid={4,number,###0.##} msgid={5}", new Object[]{"NoWait", new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._consid), new Long(((TibjmsMessage)message)._sequenceID), ((TibjmsMessage)message)._JMSMessageID != null ? ((TibjmsMessage)message)._JMSMessageID : "{not set}"});
            } else {
                TibjmsxTrace.write(this._session._connection._traceTarget, "after Receive{0} conn={1,number,###0.##} sess={2,number,###0.##} cons={3,number,###0.##} no msg received", new Object[]{"NoWait", new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._consid)});
            }
        }
        return message;
    }

    @Override
    public void close() throws JMSException {
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "Consumer Close conn={0,number,###0.##} sess={1,number,###0.##} cons={2,number,###0.##}", new Object[]{new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._consid)});
        }
        this._close();
    }

    public Destination _getDest() throws JMSException {
        if (this._closed || this._session._closed) {
            throw new IllegalStateException("Consumer is closed");
        }
        return this._destination;
    }

    public String toString() {
        String string = "";
        try {
            if (this instanceof TopicSubscriber) {
                string = this._getTypeStr() + "[topic=" + ((Topic)((Object)this._destination)).getTopicName();
                if (this._durableName != null) {
                    string = string + ", durable=" + this._durableName;
                } else if (this._isShared) {
                    string = string + ", name=" + this._subName;
                }
                string = string + ", noLocal=" + this._noLocal + "]";
            } else {
                string = this._getTypeStr() + "[queue=" + ((Queue)((Object)this._destination)).getQueueName() + "]";
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return string;
    }

    class FlowCounter {
        int consumed;
        int request;

        FlowCounter() {
        }
    }
}

