/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsMessage;
import com.tibco.tibjms.TibjmsSession;
import com.tibco.tibjms.TibjmsxConst;
import com.tibco.tibjms.TibjmsxStream;
import java.io.EOFException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;

public class TibjmsMapMessage
extends TibjmsMessage
implements MapMessage,
Serializable,
Cloneable,
TibjmsxConst {
    private static final long serialVersionUID = 5718548447690166261L;
    HashMap _fields = null;
    private boolean _extmode = false;

    @Override
    final boolean _hasBody() throws JMSException {
        if (!this._bodyLifted) {
            this._liftBody();
        }
        if (this._fields == null) {
            return false;
        }
        return this._fields.size() > 0;
    }

    @Override
    final boolean writeBody(TibjmsxStream tibjmsxStream, boolean bl) throws JMSException {
        if (!this._bodyLifted) {
            this._liftBody();
        }
        if (this._fields == null) {
            return false;
        }
        if (this._fields.size() == 0) {
            return false;
        }
        Set set = this._fields.entrySet();
        Iterator iterator2 = set.iterator();
        TibjmsxStream tibjmsxStream2 = tibjmsxStream;
        if (bl) {
            tibjmsxStream2 = new TibjmsxStream(256);
            tibjmsxStream2.encoding = tibjmsxStream.encoding;
        }
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            tibjmsxStream2.writeString((String)entry.getKey(), false);
            tibjmsxStream2.writeObject(entry.getValue(), 255, true);
        }
        if (bl) {
            if (tibjmsxStream.writeCompressed(this._session, tibjmsxStream2.buffer, 0, tibjmsxStream2.curpos)) {
                return true;
            }
            tibjmsxStream.write(tibjmsxStream2.buffer, 0, tibjmsxStream2.curpos);
        }
        return false;
    }

    @Override
    final void readBody(TibjmsxStream tibjmsxStream, boolean bl) throws EOFException, JMSException {
        int n = tibjmsxStream.readInt();
        int n2 = tibjmsxStream.curpos;
        if (this._fields == null) {
            this._fields = new HashMap();
        } else {
            this._fields.clear();
        }
        if (n > 0) {
            if (!bl) {
                while (tibjmsxStream.curpos < n2 + n) {
                    String string = tibjmsxStream.readString(false);
                    Object object = tibjmsxStream.readObject();
                    this._fields.put(string, object);
                }
                if (tibjmsxStream.curpos != n2 + n) {
                    throw new JMSException("Corrupted MapMessage body");
                }
            } else {
                byte[] byArray = tibjmsxStream.readCompressed();
                if (byArray != null) {
                    TibjmsxStream tibjmsxStream2 = new TibjmsxStream(byArray, 0, byArray.length);
                    tibjmsxStream2.encoding = tibjmsxStream.encoding;
                    while (tibjmsxStream2.curpos < tibjmsxStream2.buflen) {
                        String string = tibjmsxStream2.readString(false);
                        Object object = tibjmsxStream2.readObject();
                        this._fields.put(string, object);
                    }
                    if (tibjmsxStream2.curpos != tibjmsxStream2.buflen) {
                        throw new JMSException("Corrupted MapMessage body");
                    }
                }
            }
        }
        this._readState = true;
    }

    public TibjmsMapMessage() {
        super(5);
        this._readState = false;
    }

    TibjmsMapMessage(TibjmsSession tibjmsSession) {
        super(tibjmsSession, 5);
        this._readState = false;
    }

    TibjmsMapMessage(byte[] byArray, int n) throws JMSException {
        super(5);
        this._read(byArray, n);
    }

    @Override
    public Object clone() {
        TibjmsMapMessage tibjmsMapMessage = (TibjmsMapMessage)super.clone();
        if (tibjmsMapMessage == null) {
            return tibjmsMapMessage;
        }
        tibjmsMapMessage._type = 5;
        if (this._fields != null) {
            Set set = this._fields.keySet();
            for (Object k : set) {
                Object v;
                Object object = v = this._fields.get(k);
                if (v != null && v instanceof byte[]) {
                    byte[] byArray = (byte[])v;
                    byte[] byArray2 = new byte[byArray.length];
                    if (byArray.length > 0) {
                        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    }
                    object = byArray2;
                }
                tibjmsMapMessage._fields.put(k, object);
            }
        }
        return tibjmsMapMessage;
    }

    private final void _check() throws JMSException {
        if (!this._bodyLifted) {
            this._liftBody();
        }
        if (this._fields == null) {
            this._fields = new HashMap();
        }
    }

    @Override
    public boolean getBoolean(String string) throws JMSException {
        this._check();
        return TibjmsMapMessage.asBoolean(this._fields.get(string), string);
    }

    @Override
    public byte getByte(String string) throws JMSException {
        this._check();
        return TibjmsMapMessage.asByte(this._fields.get(string), string);
    }

    @Override
    public short getShort(String string) throws JMSException {
        this._check();
        return TibjmsMapMessage.asShort(this._fields.get(string), string);
    }

    @Override
    public char getChar(String string) throws JMSException {
        this._check();
        return this.asChar(this._fields.get(string), string);
    }

    @Override
    public int getInt(String string) throws JMSException {
        this._check();
        return TibjmsMapMessage.asInteger(this._fields.get(string), string);
    }

    @Override
    public long getLong(String string) throws JMSException {
        this._check();
        return TibjmsMapMessage.asLong(this._fields.get(string), string);
    }

    @Override
    public float getFloat(String string) throws JMSException {
        this._check();
        return TibjmsMapMessage.asFloat(this._fields.get(string), string);
    }

    @Override
    public double getDouble(String string) throws JMSException {
        this._check();
        return TibjmsMapMessage.asDouble(this._fields.get(string), string);
    }

    @Override
    public String getString(String string) throws JMSException {
        this._check();
        return TibjmsMapMessage.asString(this._fields.get(string), string);
    }

    @Override
    public byte[] getBytes(String string) throws JMSException {
        this._check();
        return this.asBytes(this._fields.get(string), string, true);
    }

    @Override
    public Object getObject(String string) throws JMSException {
        this._check();
        if (this._fields == null) {
            return null;
        }
        Object v = this._fields.get(string);
        if (v != null && v instanceof byte[]) {
            return this.asBytes(v, null, true);
        }
        return v;
    }

    public int getFieldCount() throws JMSException {
        this._check();
        return this._fields.size();
    }

    @Override
    public Enumeration getMapNames() throws JMSException {
        this._check();
        return Collections.enumeration(this._fields.keySet());
    }

    @Override
    public void setBoolean(String string, boolean bl) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message body not writeable");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty name");
        }
        this._check();
        this._fields.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setByte(String string, byte by) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message body not writeable");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty name");
        }
        this._check();
        this._fields.put(string, new Byte(by));
    }

    @Override
    public void setShort(String string, short s) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message body not writeable");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty name");
        }
        this._check();
        this._fields.put(string, new Short(s));
    }

    @Override
    public void setChar(String string, char c) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message body not writeable");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty name");
        }
        this._check();
        this._fields.put(string, new Character(c));
    }

    @Override
    public void setInt(String string, int n) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message body not writeable");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty name");
        }
        this._check();
        this._fields.put(string, new Integer(n));
    }

    @Override
    public void setLong(String string, long l) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message body not writeable");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty name");
        }
        this._check();
        this._fields.put(string, new Long(l));
    }

    @Override
    public void setFloat(String string, float f) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message body not writeable");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty name");
        }
        this._check();
        this._fields.put(string, new Float(f));
    }

    @Override
    public void setDouble(String string, double d) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message body not writeable");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty name");
        }
        this._check();
        this._fields.put(string, new Double(d));
    }

    @Override
    public void setString(String string, String string2) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message body not writeable");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty name");
        }
        this._check();
        this._fields.put(string, string2);
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message body not writeable");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty name");
        }
        this._check();
        this._fields.put(string, this._copyBytes(byArray));
    }

    @Override
    public void setBytes(String string, byte[] byArray, int n, int n2) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message body not writeable");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty name");
        }
        this._check();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            this._fields.put(string, new byte[0]);
        } else {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this._fields.put(string, byArray2);
        }
    }

    @Override
    public void setObject(String string, Object object) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message body not writeable");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty name");
        }
        this._check();
        if (object != null && TibjmsMapMessage.getFieldType(object) == 255) {
            int n;
            if (!this._extmode) {
                this._extmode = this.propertyExists("JMS_TIBCO_MSG_EXT");
                if (!this._extmode) {
                    throw new MessageFormatException("Invalid value of class " + object.getClass().getName());
                }
            }
            if ((n = TibjmsMapMessage.getExtendedType(object)) == 255) {
                throw new MessageFormatException("Invalid value of class " + object.getClass().getName());
            }
        }
        if (object instanceof byte[]) {
            this._fields.put(string, this._copyBytes((byte[])object));
        } else {
            this._fields.put(string, object);
        }
    }

    @Override
    public boolean itemExists(String string) throws JMSException {
        this._check();
        return this._fields.containsKey(string);
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this._check();
        this._fields.clear();
        this._readState = false;
    }

    String _fieldsToString() {
        if (this._fields == null) {
            return "";
        }
        String string = "";
        try {
            Enumeration enumeration = this.getMapNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                string = string + " " + string2 + "={" + this._toTypedString(this._fields.get(string2)) + "}";
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return string;
    }

    @Override
    public String toString() {
        try {
            if (!this._bodyLifted) {
                this._liftBody();
            }
        }
        catch (JMSException jMSException) {
            jMSException.printStackTrace();
            return "JMSException occurred while converting message into string: " + jMSException.getMessage();
        }
        String string = "MapMessage={" + super.toString();
        string = string + " Fields={" + this._fieldsToString() + " } }";
        return string;
    }

    @Override
    public <T> T getBody(Class<T> clazz) throws JMSException {
        if (clazz == null) {
            throw new IllegalArgumentException("null class");
        }
        if (!this.isBodyAssignableTo(clazz)) {
            throw new MessageFormatException("Cannot convert body into " + clazz.getSimpleName() + ".");
        }
        if (!this._hasBody()) {
            return null;
        }
        return (T)this._fields.clone();
    }

    @Override
    public boolean isBodyAssignableTo(Class clazz) throws JMSException {
        if (clazz == null) {
            throw new IllegalArgumentException("null class");
        }
        if (!this._hasBody()) {
            return true;
        }
        return clazz == Map.class || clazz == Object.class;
    }
}

