/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsJMSContext;
import com.tibco.tibjms.TibjmsMessage;
import com.tibco.tibjms.TibjmsMessageProducer;
import com.tibco.tibjms.TibjmsxConst;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;

public class TibjmsJMSProducer
implements JMSProducer,
TibjmsxConst {
    private TibjmsJMSContext _context = null;
    protected TibjmsMessageProducer _producer = null;
    private String _JMSCorrelationID = null;
    private Destination _JMSReplyTo = null;
    private String _JMSType = null;
    private CompletionListener _completionListener = null;
    HashMap<String, Object> _props = null;
    Object _lock = new Object();

    TibjmsJMSProducer(TibjmsJMSContext tibjmsJMSContext) {
        this._context = tibjmsJMSContext;
        try {
            this._producer = (TibjmsMessageProducer)this._context._session.createProducer(null);
        }
        catch (IllegalStateException illegalStateException) {
            throw TibjmsJMSContext._buildIllegalStateRuntimeException(illegalStateException);
        }
        catch (JMSException jMSException) {
            throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer clearProperties() {
        Object object = this._lock;
        synchronized (object) {
            if (this._props != null) {
                this._props.clear();
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionListener getAsync() {
        Object object = this._lock;
        synchronized (object) {
            return this._completionListener;
        }
    }

    @Override
    public boolean getBooleanProperty(String string) {
        Object object = this._lock;
        synchronized (object) {
            try {
                return TibjmsMessage.asBoolean(this._props == null ? null : this._props.get(string), string);
            }
            catch (MessageFormatException messageFormatException) {
                throw TibjmsJMSContext._buildMessageFormatRuntimeException(messageFormatException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public byte getByteProperty(String string) {
        Object object = this._lock;
        synchronized (object) {
            try {
                return TibjmsMessage.asByte(this._props == null ? null : this._props.get(string), string);
            }
            catch (MessageFormatException messageFormatException) {
                throw TibjmsJMSContext._buildMessageFormatRuntimeException(messageFormatException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public long getDeliveryDelay() {
        Object object = this._lock;
        synchronized (object) {
            try {
                return this._producer.getDeliveryDelay();
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public int getDeliveryMode() {
        Object object = this._lock;
        synchronized (object) {
            try {
                return this._producer.getDeliveryMode();
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public boolean getDisableMessageID() {
        Object object = this._lock;
        synchronized (object) {
            try {
                return this._producer.getDisableMessageID();
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public boolean getDisableMessageTimestamp() {
        Object object = this._lock;
        synchronized (object) {
            try {
                return this._producer.getDisableMessageTimestamp();
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public double getDoubleProperty(String string) {
        Object object = this._lock;
        synchronized (object) {
            try {
                return TibjmsMessage.asDouble(this._props == null ? null : this._props.get(string), string);
            }
            catch (MessageFormatException messageFormatException) {
                throw TibjmsJMSContext._buildMessageFormatRuntimeException(messageFormatException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public float getFloatProperty(String string) {
        Object object = this._lock;
        synchronized (object) {
            try {
                return TibjmsMessage.asFloat(this._props == null ? null : this._props.get(string), string);
            }
            catch (MessageFormatException messageFormatException) {
                throw TibjmsJMSContext._buildMessageFormatRuntimeException(messageFormatException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public int getIntProperty(String string) {
        Object object = this._lock;
        synchronized (object) {
            try {
                return TibjmsMessage.asInteger(this._props == null ? null : this._props.get(string), string);
            }
            catch (MessageFormatException messageFormatException) {
                throw TibjmsJMSContext._buildMessageFormatRuntimeException(messageFormatException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJMSCorrelationID() {
        Object object = this._lock;
        synchronized (object) {
            return this._JMSCorrelationID;
        }
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() {
        throw new UnsupportedOperationException("CorrelationID as byte array is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination getJMSReplyTo() {
        Object object = this._lock;
        synchronized (object) {
            return this._JMSReplyTo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJMSType() {
        Object object = this._lock;
        synchronized (object) {
            return this._JMSType;
        }
    }

    @Override
    public long getLongProperty(String string) {
        Object object = this._lock;
        synchronized (object) {
            try {
                return TibjmsMessage.asLong(this._props == null ? null : this._props.get(string), string);
            }
            catch (MessageFormatException messageFormatException) {
                throw TibjmsJMSContext._buildMessageFormatRuntimeException(messageFormatException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectProperty(String string) {
        Object object = this._lock;
        synchronized (object) {
            return this._props == null ? null : this._props.get(string);
        }
    }

    @Override
    public int getPriority() {
        Object object = this._lock;
        synchronized (object) {
            try {
                return this._producer.getPriority();
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getPropertyNames() {
        Object object = this._lock;
        synchronized (object) {
            if (this._props != null) {
                return this._props.keySet();
            }
            return new HashSet<String>();
        }
    }

    @Override
    public short getShortProperty(String string) {
        Object object = this._lock;
        synchronized (object) {
            try {
                return TibjmsMessage.asShort(this._props == null ? null : this._props.get(string), string);
            }
            catch (MessageFormatException messageFormatException) {
                throw TibjmsJMSContext._buildMessageFormatRuntimeException(messageFormatException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public String getStringProperty(String string) {
        Object object = this._lock;
        synchronized (object) {
            try {
                return TibjmsMessage.asString(this._props == null ? null : this._props.get(string), string);
            }
            catch (MessageFormatException messageFormatException) {
                throw TibjmsJMSContext._buildMessageFormatRuntimeException(messageFormatException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public long getTimeToLive() {
        Object object = this._lock;
        synchronized (object) {
            try {
                return this._producer.getTimeToLive();
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean propertyExists(String string) {
        Object object = this._lock;
        synchronized (object) {
            return this._props != null ? this._props.containsKey(string) : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer send(Destination destination, Message message) {
        Object object = this._lock;
        synchronized (object) {
            this._send(destination, message);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer send(Destination destination, String string) {
        TextMessage textMessage = this._context.createTextMessage(string);
        Object object = this._lock;
        synchronized (object) {
            this._send(destination, textMessage);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer send(Destination destination, Map<String, Object> map) {
        MapMessage mapMessage = this._context.createMapMessage();
        if (map != null) {
            try {
                for (String object2 : map.keySet()) {
                    mapMessage.setObject(object2, map.get(object2));
                }
            }
            catch (MessageFormatException messageFormatException) {
                throw TibjmsJMSContext._buildMessageFormatRuntimeException(messageFormatException);
            }
            catch (MessageNotWriteableException messageNotWriteableException) {
                throw TibjmsJMSContext._buildMessageNotWriteableRuntimeException(messageNotWriteableException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
        Object object = this._lock;
        synchronized (object) {
            this._send(destination, mapMessage);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer send(Destination destination, byte[] byArray) {
        BytesMessage bytesMessage = this._context.createBytesMessage();
        if (byArray != null) {
            try {
                bytesMessage.writeBytes(byArray);
            }
            catch (MessageNotWriteableException messageNotWriteableException) {
                throw TibjmsJMSContext._buildMessageNotWriteableRuntimeException(messageNotWriteableException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
        Object object = this._lock;
        synchronized (object) {
            this._send(destination, bytesMessage);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer send(Destination destination, Serializable serializable) {
        ObjectMessage objectMessage = this._context.createObjectMessage(serializable);
        Object object = this._lock;
        synchronized (object) {
            this._send(destination, objectMessage);
            return this;
        }
    }

    private void _send(Destination destination, Message message) {
        if (message == null) {
            throw new MessageFormatRuntimeException("Message is null");
        }
        if (this._props != null) {
            for (String string : this.getPropertyNames()) {
                try {
                    message.setObjectProperty(string, this._props.get(string));
                }
                catch (MessageNotWriteableException messageNotWriteableException) {
                    throw TibjmsJMSContext._buildMessageNotWriteableRuntimeException(messageNotWriteableException);
                }
                catch (MessageFormatException messageFormatException) {
                    throw TibjmsJMSContext._buildMessageFormatRuntimeException(messageFormatException);
                }
                catch (JMSException jMSException) {
                    throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
                }
                catch (Exception exception) {
                    throw TibjmsJMSContext._buildJMSRuntimeException(exception);
                }
            }
        }
        try {
            if (this._JMSCorrelationID != null) {
                message.setJMSCorrelationID(this._JMSCorrelationID);
            }
            if (this._JMSReplyTo != null) {
                message.setJMSReplyTo(this._JMSReplyTo);
            }
            if (this._JMSType != null) {
                message.setJMSType(this._JMSType);
            }
        }
        catch (JMSException jMSException) {
            throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
        }
        try {
            if (this._completionListener == null) {
                this._producer.send(destination, message);
            } else {
                this._producer.send(destination, message, this._completionListener);
            }
        }
        catch (MessageFormatException messageFormatException) {
            throw TibjmsJMSContext._buildMessageFormatRuntimeException(messageFormatException);
        }
        catch (InvalidDestinationException invalidDestinationException) {
            throw TibjmsJMSContext._buildInvalidDestinationRuntimeException(invalidDestinationException);
        }
        catch (JMSException jMSException) {
            throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
        }
        catch (Exception exception) {
            throw TibjmsJMSContext._buildJMSRuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setAsync(CompletionListener completionListener) {
        Object object = this._lock;
        synchronized (object) {
            this._completionListener = completionListener;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setDeliveryDelay(long l) {
        Object object = this._lock;
        synchronized (object) {
            try {
                this._producer.setDeliveryDelay(l);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setDeliveryMode(int n) {
        Object object = this._lock;
        synchronized (object) {
            if (n != 1 && n != 2) {
                throw new JMSRuntimeException("Invalid delivery mode " + n);
            }
            try {
                this._producer.setDeliveryMode(n);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setDisableMessageID(boolean bl) {
        Object object = this._lock;
        synchronized (object) {
            try {
                this._producer.setDisableMessageID(bl);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setDisableMessageTimestamp(boolean bl) {
        Object object = this._lock;
        synchronized (object) {
            try {
                this._producer.setDisableMessageTimestamp(bl);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setJMSCorrelationID(String string) {
        Object object = this._lock;
        synchronized (object) {
            this._JMSCorrelationID = string;
            return this;
        }
    }

    @Override
    public JMSProducer setJMSCorrelationIDAsBytes(byte[] byArray) {
        throw new UnsupportedOperationException("CorrelationID as byte array is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setJMSReplyTo(Destination destination) {
        Object object = this._lock;
        synchronized (object) {
            this._JMSReplyTo = destination;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setJMSType(String string) {
        Object object = this._lock;
        synchronized (object) {
            this._JMSType = string;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setPriority(int n) {
        Object object = this._lock;
        synchronized (object) {
            if (n < 0 || n > 9) {
                throw new JMSRuntimeException("Invalid priority " + n);
            }
            try {
                this._producer.setPriority(n);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setProperty(String string, boolean bl) {
        Object object = this._lock;
        synchronized (object) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("null or empty name");
            }
            if (this._props == null) {
                this._props = new HashMap();
            }
            this._props.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setProperty(String string, byte by) {
        Object object = this._lock;
        synchronized (object) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("null or empty name");
            }
            if (this._props == null) {
                this._props = new HashMap();
            }
            this._props.put(string, new Byte(by));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setProperty(String string, short s) {
        Object object = this._lock;
        synchronized (object) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("null or empty name");
            }
            if (this._props == null) {
                this._props = new HashMap();
            }
            this._props.put(string, new Short(s));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setProperty(String string, int n) {
        Object object = this._lock;
        synchronized (object) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("null or empty name");
            }
            if (this._props == null) {
                this._props = new HashMap();
            }
            this._props.put(string, new Integer(n));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setProperty(String string, long l) {
        Object object = this._lock;
        synchronized (object) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("null or empty name");
            }
            if (this._props == null) {
                this._props = new HashMap();
            }
            this._props.put(string, new Long(l));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setProperty(String string, float f) {
        Object object = this._lock;
        synchronized (object) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("null or empty name");
            }
            if (this._props == null) {
                this._props = new HashMap();
            }
            this._props.put(string, new Float(f));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setProperty(String string, double d) {
        Object object = this._lock;
        synchronized (object) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("null or empty name");
            }
            if (this._props == null) {
                this._props = new HashMap();
            }
            this._props.put(string, new Double(d));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setProperty(String string, String string2) {
        Object object = this._lock;
        synchronized (object) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("null or empty name");
            }
            if (this._props == null) {
                this._props = new HashMap();
            }
            this._props.put(string, string2);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setProperty(String string, Object object) {
        Object object2 = this._lock;
        synchronized (object2) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("null or empty name");
            }
            if (object != null && TibjmsMessage.getPropType(object) == 255) {
                throw new MessageFormatRuntimeException("Invalid property value of class " + object.getClass().getName());
            }
            if (this._props == null) {
                this._props = new HashMap();
            }
            this._props.put(string, object);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer setTimeToLive(long l) {
        Object object = this._lock;
        synchronized (object) {
            try {
                this._producer.setTimeToLive(l);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
            return this;
        }
    }

    public String toString() {
        return "JMSProducer";
    }
}

