/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsConnection;
import com.tibco.tibjms.TibjmsConnectionFactory;
import com.tibco.tibjms.TibjmsJMSConsumer;
import com.tibco.tibjms.TibjmsJMSProducer;
import com.tibco.tibjms.TibjmsMessageConsumer;
import com.tibco.tibjms.TibjmsxCFImpl;
import com.tibco.tibjms.TibjmsxConst;
import com.tibco.tibjms.TibjmsxSessionImp;
import com.tibco.tibjms.TibjmsxTrace;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidClientIDRuntimeException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidDestinationRuntimeException;
import javax.jms.InvalidSelectorException;
import javax.jms.InvalidSelectorRuntimeException;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.jms.JMSSecurityRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageNotWriteableException;
import javax.jms.MessageNotWriteableRuntimeException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TransactionInProgressException;
import javax.jms.TransactionInProgressRuntimeException;
import javax.jms.TransactionRolledBackException;
import javax.jms.TransactionRolledBackRuntimeException;

public class TibjmsJMSContext
implements JMSContext,
TibjmsxConst {
    protected TibjmsConnection _connection = null;
    protected TibjmsxSessionImp _session = null;
    protected Vector<JMSContext> _contexts = null;
    private LinkedList<TibjmsJMSProducer> _producers = null;
    private LinkedList<TibjmsJMSConsumer> _consumers = null;
    protected boolean _closed = false;
    protected boolean _clear = true;
    private boolean _autoStart = true;
    Object _lock = new Object();

    TibjmsJMSContext(TibjmsxCFImpl tibjmsxCFImpl, String string, String string2, int n) {
        if (n != 1 && n != 2 && n != 3 && n != 0) {
            throw new JMSRuntimeException("Illegal session mode for JMSContext");
        }
        try {
            this._connection = (TibjmsConnection)((TibjmsConnectionFactory)tibjmsxCFImpl).createConnection(string, string2);
        }
        catch (JMSSecurityException jMSSecurityException) {
            throw TibjmsJMSContext._buildJMSSecurityRuntimeException(jMSSecurityException);
        }
        catch (JMSException jMSException) {
            throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
        }
        try {
            this._session = this._connection._createSession(0, n == 0, n, false);
        }
        catch (JMSException jMSException) {
            try {
                this._connection.close();
            }
            catch (JMSException jMSException2) {
                // empty catch block
            }
            throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
        }
        this._contexts = new Vector();
        this._contexts.add(this);
    }

    TibjmsJMSContext(TibjmsConnection tibjmsConnection, int n, Vector<JMSContext> vector) {
        this._connection = tibjmsConnection;
        try {
            this._session = this._connection._createSession(0, n == 0, n, false);
        }
        catch (JMSException jMSException) {
            throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
        }
        this._contexts = vector;
        this._contexts.add(this);
    }

    TibjmsJMSContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledge() {
        TibjmsMessageConsumer tibjmsMessageConsumer = null;
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                if (this._session.getAcknowledgeMode() != 2 || this._consumers == null || this._consumers.size() == 0) {
                    return;
                }
                if (this._connection._traceTarget != 0) {
                    TibjmsxTrace.write(this._connection._traceTarget, "Acknowledge JMSContext conn={0,number,###0.##} sess={1,number,###0.##}", new Object[]{new Long(this._connection._connid), new Long(this._session._getSessid())});
                }
                this._clear = false;
                tibjmsMessageConsumer = this._consumers.getFirst()._consumer;
                this._session._confirmJMSContext(tibjmsMessageConsumer);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this._session._checkLegalAPIUse(6);
        }
        catch (IllegalStateException illegalStateException) {
            throw TibjmsJMSContext._buildIllegalStateRuntimeException(illegalStateException);
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._closed) {
                return;
            }
            this._clear = false;
            this._closed = true;
            try {
                if (this._producers != null) {
                    for (TibjmsJMSProducer tibjmsJMSProducer : this._producers) {
                        tibjmsJMSProducer._producer.close();
                    }
                    this._producers.clear();
                }
                this._session.close();
                this._contexts.remove(this);
                if (this._contexts.isEmpty()) {
                    this._connection.close();
                    this._connection = null;
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw TibjmsJMSContext._buildIllegalStateRuntimeException(illegalStateException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        try {
            this._session._checkLegalAPIUse(3);
        }
        catch (IllegalStateException illegalStateException) {
            throw TibjmsJMSContext._buildIllegalStateRuntimeException(illegalStateException);
        }
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                this._session.commit();
            }
            catch (TransactionInProgressException transactionInProgressException) {
                throw TibjmsJMSContext._buildTransactionInProgressRuntimeException(transactionInProgressException);
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                throw TibjmsJMSContext._buildTransactionRolledBackRuntimeException(transactionRolledBackException);
            }
            catch (IllegalStateException illegalStateException) {
                throw TibjmsJMSContext._buildIllegalStateRuntimeException(illegalStateException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String string) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                return this._session.createBrowser(queue, string);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw TibjmsJMSContext._buildInvalidDestinationRuntimeException(invalidDestinationException);
            }
            catch (InvalidSelectorException invalidSelectorException) {
                throw TibjmsJMSContext._buildInvalidSelectorRuntimeException(invalidSelectorException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                return this._session.createBrowser(queue);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw TibjmsJMSContext._buildInvalidDestinationRuntimeException(invalidDestinationException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public BytesMessage createBytesMessage() {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                return this._session.createBytesMessage();
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSConsumer createConsumer(Destination destination, String string, boolean bl) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            this._clear = false;
            return new TibjmsJMSConsumer(this, destination, string, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSConsumer createConsumer(Destination destination, String string) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            this._clear = false;
            return new TibjmsJMSConsumer(this, destination, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSConsumer createConsumer(Destination destination) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            this._clear = false;
            return new TibjmsJMSConsumer(this, destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSContext createContext(int n) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            this._clear = false;
            return new TibjmsJMSContext(this._connection, n, this._contexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSConsumer createDurableConsumer(Topic topic, String string, String string2, boolean bl) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            this._clear = false;
            return new TibjmsJMSConsumer(this, topic, string, string2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSConsumer createDurableConsumer(Topic topic, String string) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            this._clear = false;
            return new TibjmsJMSConsumer(this, false, true, topic, string);
        }
    }

    @Override
    public MapMessage createMapMessage() {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                return this._session.createMapMessage();
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public Message createMessage() {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                return this._session.createMessage();
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public ObjectMessage createObjectMessage() {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                return this._session.createObjectMessage();
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public ObjectMessage createObjectMessage(Serializable serializable) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                return this._session.createObjectMessage(serializable);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer createProducer() {
        TibjmsJMSProducer tibjmsJMSProducer = null;
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            this._clear = false;
            tibjmsJMSProducer = new TibjmsJMSProducer(this);
            if (this._producers == null) {
                this._producers = new LinkedList();
            }
            this._producers.add(tibjmsJMSProducer);
            return tibjmsJMSProducer;
        }
    }

    @Override
    public Queue createQueue(String string) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                return this._session.createQueue(string);
            }
            catch (IllegalStateException illegalStateException) {
                throw TibjmsJMSContext._buildIllegalStateRuntimeException(illegalStateException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(illegalArgumentException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSConsumer createSharedConsumer(Topic topic, String string, String string2) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            this._clear = false;
            return new TibjmsJMSConsumer(this, false, topic, string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSConsumer createSharedConsumer(Topic topic, String string) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            this._clear = false;
            return new TibjmsJMSConsumer(this, true, false, topic, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSConsumer createSharedDurableConsumer(Topic topic, String string, String string2) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            this._clear = false;
            return new TibjmsJMSConsumer(this, true, topic, string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSConsumer createSharedDurableConsumer(Topic topic, String string) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            this._clear = false;
            return new TibjmsJMSConsumer(this, true, true, topic, string);
        }
    }

    @Override
    public StreamMessage createStreamMessage() {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                return this._session.createStreamMessage();
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public TemporaryQueue createTemporaryQueue() {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                return this._session.createTemporaryQueue();
            }
            catch (IllegalStateException illegalStateException) {
                throw TibjmsJMSContext._buildIllegalStateRuntimeException(illegalStateException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public TemporaryTopic createTemporaryTopic() {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                return this._session.createTemporaryTopic();
            }
            catch (IllegalStateException illegalStateException) {
                throw TibjmsJMSContext._buildIllegalStateRuntimeException(illegalStateException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public TextMessage createTextMessage() {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                return this._session.createTextMessage();
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public TextMessage createTextMessage(String string) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                return this._session.createTextMessage(string);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public Topic createTopic(String string) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                return this._session.createTopic(string);
            }
            catch (IllegalStateException illegalStateException) {
                throw TibjmsJMSContext._buildIllegalStateRuntimeException(illegalStateException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(illegalArgumentException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoStart() {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            return this._autoStart;
        }
    }

    @Override
    public String getClientID() {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                return this._connection.getClientID();
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public ExceptionListener getExceptionListener() {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                return this._connection.getExceptionListener();
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public ConnectionMetaData getMetaData() {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                return this._connection.getMetaData();
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public int getSessionMode() {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                return this._session.getAcknowledgeMode();
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    @Override
    public boolean getTransacted() {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                return this._session.getTransacted();
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover() {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                this._session.recover();
            }
            catch (IllegalStateException illegalStateException) {
                throw TibjmsJMSContext._buildIllegalStateRuntimeException(illegalStateException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        try {
            this._session._checkLegalAPIUse(4);
        }
        catch (IllegalStateException illegalStateException) {
            throw TibjmsJMSContext._buildIllegalStateRuntimeException(illegalStateException);
        }
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                this._session.rollback();
            }
            catch (IllegalStateException illegalStateException) {
                throw TibjmsJMSContext._buildIllegalStateRuntimeException(illegalStateException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoStart(boolean bl) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            this._clear = false;
            this._autoStart = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientID(String string) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._connection.setClientIDFromContext(string, this._clear);
                this._clear = false;
            }
            catch (InvalidClientIDException invalidClientIDException) {
                throw TibjmsJMSContext._buildInvalidClientIDRuntimeException(invalidClientIDException);
            }
            catch (IllegalStateException illegalStateException) {
                throw TibjmsJMSContext._buildIllegalStateRuntimeException(illegalStateException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExceptionListener(ExceptionListener exceptionListener) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                this._connection.setExceptionListener(exceptionListener);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                this._connection.start();
            }
            catch (IllegalStateException illegalStateException) {
                throw TibjmsJMSContext._buildIllegalStateRuntimeException(illegalStateException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            this._connection._checkLegalAPIUse(7);
        }
        catch (IllegalStateException illegalStateException) {
            throw TibjmsJMSContext._buildIllegalStateRuntimeException(illegalStateException);
        }
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                this._connection.stop();
            }
            catch (IllegalStateException illegalStateException) {
                throw TibjmsJMSContext._buildIllegalStateRuntimeException(illegalStateException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(String string) {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            try {
                this._clear = false;
                this._session.unsubscribe(string);
            }
            catch (InvalidDestinationException invalidDestinationException) {
                throw TibjmsJMSContext._buildInvalidDestinationRuntimeException(invalidDestinationException);
            }
            catch (JMSException jMSException) {
                throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this._lock;
        synchronized (object) {
            this._checkClosed();
            return "JMSContext[" + (this._closed ? "Closed, " : "") + "AutoStart=" + this._autoStart + (this._contexts.size() > 1 && !this._closed ? ", Sharing Connection with " + (this._contexts.size() - 1) + " JMSContext" + (this._contexts.size() > 2 ? "s" : "") : "") + "]\n" + this._connection + "\n" + this._session;
        }
    }

    protected TibjmsMessageConsumer _createConsumer(Destination destination, String string, boolean bl, boolean bl2, String string2, boolean bl3) {
        try {
            return this._session._createConsumer(destination, string, bl, bl2, string2, bl3, false, bl ? "Durable" : "Consumer");
        }
        catch (InvalidDestinationException invalidDestinationException) {
            throw TibjmsJMSContext._buildInvalidDestinationRuntimeException(invalidDestinationException);
        }
        catch (InvalidSelectorException invalidSelectorException) {
            throw TibjmsJMSContext._buildInvalidSelectorRuntimeException(invalidSelectorException);
        }
        catch (IllegalStateException illegalStateException) {
            throw TibjmsJMSContext._buildIllegalStateRuntimeException(illegalStateException);
        }
        catch (JMSException jMSException) {
            throw TibjmsJMSContext._buildJMSRuntimeException(jMSException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _addConsumerToList(TibjmsJMSConsumer tibjmsJMSConsumer) {
        Object object = this._lock;
        synchronized (object) {
            if (this._consumers == null) {
                this._consumers = new LinkedList();
            }
            this._consumers.add(tibjmsJMSConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _removeConsumerFromList(TibjmsJMSConsumer tibjmsJMSConsumer) {
        Object object = this._lock;
        synchronized (object) {
            this._consumers.remove(tibjmsJMSConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String _getActiveURL() {
        Object object = this._lock;
        synchronized (object) {
            if (this._closed) {
                return null;
            }
            return this._connection.getActiveURL();
        }
    }

    private void _checkClosed() {
        if (this._closed) {
            throw new IllegalStateRuntimeException("Context is closed");
        }
    }

    protected static JMSRuntimeException _buildJMSRuntimeException(JMSException jMSException) {
        return new JMSRuntimeException(jMSException.getMessage(), jMSException.getErrorCode(), jMSException);
    }

    protected static JMSRuntimeException _buildJMSRuntimeException(IllegalArgumentException illegalArgumentException) {
        return new JMSRuntimeException(illegalArgumentException.getMessage(), "", illegalArgumentException);
    }

    protected static JMSRuntimeException _buildJMSRuntimeException(Exception exception) {
        return new JMSRuntimeException(exception.getMessage(), "", exception);
    }

    protected static MessageFormatRuntimeException _buildMessageFormatRuntimeException(MessageFormatException messageFormatException) {
        return new MessageFormatRuntimeException(messageFormatException.getMessage(), messageFormatException.getErrorCode(), messageFormatException);
    }

    protected static InvalidSelectorRuntimeException _buildInvalidSelectorRuntimeException(InvalidSelectorException invalidSelectorException) {
        return new InvalidSelectorRuntimeException(invalidSelectorException.getMessage(), invalidSelectorException.getErrorCode(), invalidSelectorException);
    }

    protected static InvalidDestinationRuntimeException _buildInvalidDestinationRuntimeException(InvalidDestinationException invalidDestinationException) {
        return new InvalidDestinationRuntimeException(invalidDestinationException.getMessage(), invalidDestinationException.getErrorCode(), invalidDestinationException);
    }

    protected static JMSSecurityRuntimeException _buildJMSSecurityRuntimeException(JMSSecurityException jMSSecurityException) {
        return new JMSSecurityRuntimeException(jMSSecurityException.getMessage(), jMSSecurityException.getErrorCode(), jMSSecurityException);
    }

    protected static MessageNotWriteableRuntimeException _buildMessageNotWriteableRuntimeException(MessageNotWriteableException messageNotWriteableException) {
        return new MessageNotWriteableRuntimeException(messageNotWriteableException.getMessage(), messageNotWriteableException.getErrorCode(), messageNotWriteableException);
    }

    protected static IllegalStateRuntimeException _buildIllegalStateRuntimeException(IllegalStateException illegalStateException) {
        return new IllegalStateRuntimeException(illegalStateException.getMessage(), illegalStateException.getErrorCode(), illegalStateException);
    }

    protected static TransactionRolledBackRuntimeException _buildTransactionRolledBackRuntimeException(TransactionRolledBackException transactionRolledBackException) {
        return new TransactionRolledBackRuntimeException(transactionRolledBackException.getMessage(), transactionRolledBackException.getErrorCode(), transactionRolledBackException);
    }

    protected static TransactionInProgressRuntimeException _buildTransactionInProgressRuntimeException(TransactionInProgressException transactionInProgressException) {
        return new TransactionInProgressRuntimeException(transactionInProgressException.getMessage(), transactionInProgressException.getErrorCode(), transactionInProgressException);
    }

    protected static InvalidClientIDRuntimeException _buildInvalidClientIDRuntimeException(InvalidClientIDException invalidClientIDException) {
        return new InvalidClientIDRuntimeException(invalidClientIDException.getMessage(), invalidClientIDException.getErrorCode(), invalidClientIDException);
    }
}

