/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.Tibjms;
import com.tibco.tibjms.TibjmsConnection;
import com.tibco.tibjms.TibjmsxCFImpl;
import com.tibco.tibjms.TibjmsxTrace;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.naming.Referenceable;

public class TibjmsConnectionFactory
extends TibjmsxCFImpl
implements ConnectionFactory,
Externalizable,
Referenceable,
Cloneable {
    static final long serialVersionUID = -4661688544277536262L;

    @Override
    public Connection createConnection() throws JMSException {
        TibjmsConnection tibjmsConnection = this._createConnection(null, null, false);
        if (tibjmsConnection._traceTarget != 0) {
            TibjmsxTrace.write(tibjmsConnection._traceTarget, "{0} Create{1}Connection conn={2,number,###0.##} {3}{4} UTC offset={5,number,###0.##} URL={6}", new Object[]{this.toString(), "", new Long(tibjmsConnection._connid), "", "", new Long(tibjmsConnection._getUTCoffset()), Tibjms.getConnectionActiveURL(tibjmsConnection)});
        }
        return tibjmsConnection;
    }

    @Override
    public Connection createConnection(String string, String string2) throws JMSException {
        TibjmsConnection tibjmsConnection = this._createConnection(string, string2, false);
        if (tibjmsConnection._traceTarget != 0) {
            TibjmsxTrace.write(tibjmsConnection._traceTarget, "{0} Create{1}Connection conn={2,number,###0.##} {3}{4} UTC offset={5,number,###0.##} URL={6}", new Object[]{this.toString(), "", new Long(tibjmsConnection._connid), "user=", string != null ? string : "{not set}", new Long(tibjmsConnection._getUTCoffset()), Tibjms.getConnectionActiveURL(tibjmsConnection)});
        }
        return tibjmsConnection;
    }

    @Override
    public JMSContext createContext() {
        return this._createJMSContext(null, null, 1);
    }

    @Override
    public JMSContext createContext(int n) {
        return this._createJMSContext(null, null, n);
    }

    @Override
    public JMSContext createContext(String string, String string2) {
        return this._createJMSContext(string, string2, 1);
    }

    @Override
    public JMSContext createContext(String string, String string2, int n) {
        return this._createJMSContext(string, string2, n);
    }

    public TibjmsConnectionFactory() {
    }

    public TibjmsConnectionFactory(String string) {
        super(string, null, null);
    }

    public TibjmsConnectionFactory(String string, String string2) {
        super(string, string2, null);
    }

    public TibjmsConnectionFactory(String string, String string2, Map map) {
        super(string, string2, map);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TibjmsConnectionFactory tibjmsConnectionFactory = (TibjmsConnectionFactory)super.clone();
        return tibjmsConnectionFactory;
    }

    public void setServerUrl(String string) throws JMSException {
        if (this._url != null && !this._url.equals("tcp://localhost:7222")) {
            throw new JMSException("Server URL already set");
        }
        if (this._url != null && this._url.equals("tcp://localhost:7222")) {
            this._urlStrings = null;
        }
        this._url = string;
    }

    public void setClientID(String string) throws JMSException {
        if (this._clientID != null) {
            throw new JMSException("client ID already set");
        }
        this._clientID = string;
    }

    public void setMetric(int n) throws JMSException {
        if (n != 0 && n != 1 && n != 2) {
            throw new JMSException("invalid metric");
        }
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.factory.metric", new Integer(n));
    }

    public void setConnAttemptCount(int n) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.connect.attemptcount", new Integer(n));
    }

    public void setConnAttemptDelay(int n) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.connect.attemptdelay", new Integer(n));
    }

    public void setReconnAttemptCount(int n) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.reconnect.attemptcount", new Integer(n));
    }

    public void setReconnAttemptDelay(int n) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.reconnect.attemptdelay", new Integer(n));
    }

    public void setUserName(String string) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.factory.username", string);
    }

    public void setUserPassword(String string) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.factory.password", string);
    }

    public void setSSLVendor(String string) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.ssl.vendor", string);
    }

    public void setSSLTrace(Boolean bl) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.ssl.trace", bl);
    }

    public void setSSLDebugTrace(Boolean bl) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.ssl.debug_trace", bl);
    }

    public void setSSLEnableVerifyHost(Boolean bl) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.ssl.enable_verify_host", bl);
    }

    public void setSSLEnableVerifyHostName(Boolean bl) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.ssl.enable_verify_hostname", bl);
    }

    public void setSSLExpectedHostName(String string) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.ssl.expected_hostname", string);
    }

    public void setSSLAuthOnly(Boolean bl) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.ssl.auth_only", bl);
    }

    public void setSSLTrustedCertificate(String string) {
        Vector<Integer> vector;
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        if ((vector = (Vector<Integer>)this._properties.get("com.tibco.tibjms.ssl.trusted_certs")) == null) {
            vector = new Vector<Integer>();
        }
        vector.add(new Integer(0));
        vector.add((Integer)((Object)string));
        this._properties.put("com.tibco.tibjms.ssl.trusted_certs", vector);
    }

    public void setSSLTrustedCertificate(String string, String string2) {
        Vector<Object> vector;
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        if ((vector = (Vector<Object>)this._properties.get("com.tibco.tibjms.ssl.trusted_certs")) == null) {
            vector = new Vector<Object>();
        }
        if (string2 != null) {
            vector.add(string2);
        } else {
            vector.add(new Integer(0));
        }
        vector.add(string);
        this._properties.put("com.tibco.tibjms.ssl.trusted_certs", vector);
    }

    public void setSSLTrustedCertificate(byte[] byArray, String string) {
        Vector<Object> vector;
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        if ((vector = (Vector<Object>)this._properties.get("com.tibco.tibjms.ssl.trusted_certs")) == null) {
            vector = new Vector<Object>();
        }
        if (string != null) {
            vector.add(string);
        } else {
            vector.add(new Integer(0));
        }
        vector.add(byArray);
        this._properties.put("com.tibco.tibjms.ssl.trusted_certs", vector);
    }

    public void setSSLIssuerCertificate(String string) {
        Vector<Integer> vector;
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        if ((vector = (Vector<Integer>)this._properties.get("com.tibco.tibjms.ssl.issuer_certs")) == null) {
            vector = new Vector<Integer>();
        }
        vector.add(new Integer(0));
        vector.add((Integer)((Object)string));
        this._properties.put("com.tibco.tibjms.ssl.issuer_certs", vector);
    }

    public void setSSLIssuerCertificate(String string, String string2) {
        Vector<Object> vector;
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        if ((vector = (Vector<Object>)this._properties.get("com.tibco.tibjms.ssl.issuer_certs")) == null) {
            vector = new Vector<Object>();
        }
        if (string2 != null) {
            vector.add(string2);
        } else {
            vector.add(new Integer(0));
        }
        vector.add(string);
        this._properties.put("com.tibco.tibjms.ssl.issuer_certs", vector);
    }

    public void setSSLIssuerCertificate(byte[] byArray, String string) {
        Vector<Object> vector;
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        if ((vector = (Vector<Object>)this._properties.get("com.tibco.tibjms.ssl.issuer_certs")) == null) {
            vector = new Vector<Object>();
        }
        if (string != null) {
            vector.add(string);
        } else {
            vector.add(new Integer(0));
        }
        vector.add(byArray);
        this._properties.put("com.tibco.tibjms.ssl.issuer_certs", vector);
    }

    public void setSSLIdentity(String string) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.ssl.identity", string);
    }

    public void setSSLIdentity(byte[] byArray) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.ssl.identity", byArray);
    }

    public void setSSLIdentityEncoding(String string) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.ssl.identity_encoding", string);
    }

    public void setSSLPrivateKey(String string) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.ssl.private_key", string);
    }

    public void setSSLPrivateKey(byte[] byArray) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.ssl.private_key", byArray);
    }

    public void setSSLPrivateKeyEncoding(String string) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.ssl.private_key_encoding", string);
    }

    public void setSSLPassword(String string) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.ssl.password", string);
    }

    public void setSSLCipherSuites(String string) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.ssl.cipher_suites", string);
    }

    public void setSSLProxy(String string, int n) throws JMSException {
        if (string == null || string.length() == 0) {
            throw new JMSException("Invalid host name for proxy");
        }
        if (n == 0) {
            throw new JMSException("Invalid port for proxy");
        }
        if (this._getProtocol() != 2) {
            throw new JMSException("Proxy connection not supported for this protocol");
        }
        this._proxyHost = string;
        this._proxyPort = n;
    }

    public void setSSLProxyAuth(String string, String string2) throws JMSException {
        if (this._getProtocol() != 2) {
            throw new JMSException("Proxy connection not supported for this protocol");
        }
        this._proxyUsername = string;
        this._proxyPassword = string2;
    }

    public String getSSLProxyHost() throws JMSException {
        if (this._getProtocol() != 2) {
            throw new JMSException("Proxy connection not supported for this protocol");
        }
        return this._proxyHost;
    }

    public int getSSLProxyPort() throws JMSException {
        if (this._getProtocol() != 2) {
            throw new JMSException("Proxy connection not supported for this protocol");
        }
        return this._proxyPort;
    }

    public String getSSLProxyUser() throws JMSException {
        if (this._getProtocol() != 2) {
            throw new JMSException("Proxy connection not supported for this protocol");
        }
        return this._proxyUsername;
    }

    public String getSSLProxyPassword() throws JMSException {
        if (this._getProtocol() != 2) {
            throw new JMSException("Proxy connection not supported for this protocol");
        }
        return this._proxyPassword;
    }

    public void setConnAttemptTimeout(int n) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.connect.attempttimeout", new Integer(n));
    }

    public void setReconnAttemptTimeout(int n) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.reconnect.attempttimeout", new Integer(n));
    }

    @Deprecated
    public void setMulticastEnabled(boolean bl) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.multicast.enabled", new Boolean(bl));
    }

    @Deprecated
    public void setMulticastDaemon(String string) throws JMSException {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put("com.tibco.tibjms.multicast.daemon", string);
    }
}

