/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsConnectionConsumer;
import com.tibco.tibjms.TibjmsConnectionMetaData;
import com.tibco.tibjms.TibjmsDestination;
import com.tibco.tibjms.TibjmsMapMessage;
import com.tibco.tibjms.TibjmsMessage;
import com.tibco.tibjms.TibjmsMessageConsumer;
import com.tibco.tibjms.TibjmsMulticastExceptionListener;
import com.tibco.tibjms.TibjmsQueue;
import com.tibco.tibjms.TibjmsQueueConnection;
import com.tibco.tibjms.TibjmsQueueSession;
import com.tibco.tibjms.TibjmsSSL;
import com.tibco.tibjms.TibjmsTemporaryDestination;
import com.tibco.tibjms.TibjmsTemporaryQueue;
import com.tibco.tibjms.TibjmsTemporaryTopic;
import com.tibco.tibjms.TibjmsTopicConnection;
import com.tibco.tibjms.TibjmsTopicSession;
import com.tibco.tibjms.TibjmsXAQueueConnection;
import com.tibco.tibjms.TibjmsXAQueueSession;
import com.tibco.tibjms.TibjmsXASession;
import com.tibco.tibjms.TibjmsXATopicConnection;
import com.tibco.tibjms.TibjmsXATopicSession;
import com.tibco.tibjms.Tibjmsx;
import com.tibco.tibjms.TibjmsxCFImpl;
import com.tibco.tibjms.TibjmsxCallbackThreadInfo;
import com.tibco.tibjms.TibjmsxConst;
import com.tibco.tibjms.TibjmsxLink;
import com.tibco.tibjms.TibjmsxLinkSSL;
import com.tibco.tibjms.TibjmsxLongKey;
import com.tibco.tibjms.TibjmsxMsgId;
import com.tibco.tibjms.TibjmsxResponseCallback;
import com.tibco.tibjms.TibjmsxSessionImp;
import com.tibco.tibjms.TibjmsxStream;
import com.tibco.tibjms.TibjmsxTrace;
import com.tibco.tibjms.TibjmsxURL;
import java.io.EOFException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.QueueConnection;
import javax.jms.ResourceAllocationException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;

public class TibjmsConnection
implements Connection,
TibjmsxConst {
    String _server_version = null;
    short _server_version_major = 0;
    short _server_version_minor = 0;
    short _server_version_update = 0;
    short _server_version_build = 0;
    int _server_version_numeric = 0;
    String _userName = null;
    byte[] _password = null;
    Map _properties = null;
    long _connid = 0L;
    Vector _urls = null;
    int _urlIndex = 0;
    String _clientID = null;
    private boolean _canChangeID = false;
    TibjmsConnectionMetaData _metaData = null;
    ExceptionListener _exceptionListener = null;
    boolean _started = false;
    boolean _closed = false;
    boolean _closing = false;
    boolean _clear = true;
    boolean _secure = true;
    boolean _flowControl = false;
    boolean _compliantConsumers = false;
    private boolean _ssl_auth_only = false;
    int _npsend_mode = 0;
    int _maxMsgSize = 0;
    int _xa_default_timeout = 0;
    boolean _xaNewProtocol = false;
    boolean _jms20CompliantDeliveryCount = false;
    boolean _compliantTempDests = false;
    boolean _newTempDests = true;
    HashMap _tempDests = new HashMap();
    TibjmsxLink _link = null;
    Object _lock = new Object();
    boolean _inProcessing = false;
    boolean _stopping = false;
    HashMap _sessions = new HashMap();
    Vector _dups_ok_sessions = null;
    HashMap _subscriptions = new HashMap();
    HashMap _consumers = new HashMap();
    Vector _connectionConsumers = null;
    long _requestTimeout = 60000L;
    int _requestPriority = 5;
    boolean _multicastEnabled = true;
    String _multicastDaemon = null;
    private boolean _isAdmin = false;
    int _connect_attempt_count = 2;
    int _connect_attempt_delay = 500;
    int _reconnect_attempt_count = 4;
    int _reconnect_attempt_delay = 500;
    int _connectAttemptTimeout = 0;
    int _reconnectAttemptTimeout = 0;
    ConnectTimeoutThread _connectTimeoutThread = null;
    int _pingInterval = 0;
    int _serverHeartbeatClient = 0;
    int _clientTimeoutServer = 0;
    boolean _timedout = false;
    short _traceTarget = 0;
    long _metric_connections = 0L;
    long _metric_byte_rate = 0L;
    boolean _noTrace = false;
    private HashMap _connectionRequests = new HashMap();
    static Object _hostLock = new Object();
    static boolean _hostDetermined = false;
    static String _hostName = null;
    static byte[] _hostIPAddr = null;
    private static ArrayList _connections = new ArrayList();
    int _DUPS_OK_INTERVAL = Tibjmsx.dupsInterval;
    static Object _dupsNotifier = new Object();
    static boolean _haveDups = false;
    static DOT _dot = null;
    String _proxyHost = null;
    int _proxyPort = 0;
    String _proxyUsername = null;
    String _proxyPassword = null;
    private Object _UTCoffsetLock = new Object();
    private long _UTCoffset = 0L;
    private static final int _UTC_OFFSET_MIN = 100;
    int _closedReason = 0;
    String _closedReasonString = null;
    boolean _serverMcastEnabled = false;
    private HashMap _durables = new HashMap();
    private Object _durablesLock = new Object();
    Object _md_lock = new Object();
    long _md_connid = 0L;
    Vector _md_urls = null;
    int _md_urlIndex = 0;
    TibjmsxLink _md_link = null;
    int _md_refs = 0;
    ConnectTimeoutThread _md_connectTimeoutThread = null;
    String _md_version = null;
    short _md_version_major = 0;
    short _md_version_minor = 0;
    short _md_version_update = 0;
    short _md_version_build = 0;
    int _md_version_numeric = 0;
    boolean _md_closed = false;
    boolean _md_closing = false;
    private boolean _md_started = false;
    private boolean _md_stopping = false;
    static final int _CLOSED_USER = 1;
    static final int _CLOSED_SERVER = 2;
    static final int _CLOSED_TIMEOUT = 3;
    private static Object _checkerLock = new Object();
    private static Checker _checker = null;
    private TibjmsxLongKey _sessionKey = new TibjmsxLongKey();
    private TibjmsxLongKey _consKey = new TibjmsxLongKey();

    String _getTerminatedText() {
        if (this._closedReasonString != null) {
            return this._closedReasonString;
        }
        switch (this._closedReason) {
            case 1: {
                return "Connection closed by user";
            }
            case 3: {
                return "Connection has been terminated due to missing server heartbeats";
            }
        }
        return "Connection has been terminated";
    }

    void _checkLegalAPIUse(int n) throws IllegalStateException {
        TibjmsxCallbackThreadInfo tibjmsxCallbackThreadInfo = Tibjmsx.ListenerCallbackArgs.get();
        if (tibjmsxCallbackThreadInfo == null) {
            return;
        }
        if (tibjmsxCallbackThreadInfo.getConnection() == this) {
            switch (tibjmsxCallbackThreadInfo.getCallbackType()) {
                case 1: {
                    if (n == 7 || n == 1) break;
                    throw new IllegalStateException("Illegal to " + TibjmsxCallbackThreadInfo.actions[n] + " in a completion listener.");
                }
                case 2: {
                    if (Tibjmsx.allowCallbackClose) break;
                    throw new IllegalStateException("Illegal to " + TibjmsxCallbackThreadInfo.actions[n] + " from a consumer's callback");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _createChecker() {
        Object object = _checkerLock;
        synchronized (object) {
            if (_checker != null) {
                return;
            }
            if (this._serverHeartbeatClient <= 0 || this._clientTimeoutServer <= 0) {
                return;
            }
            _checker = new Checker();
        }
    }

    void _resetServerHeartbeats() {
        this._serverHeartbeatClient = 0;
        this._clientTimeoutServer = 0;
    }

    public short getTraceTarget() {
        return this._traceTarget;
    }

    public String getUrls() {
        Vector vector = this._urls;
        int n = this._urlIndex;
        String string = "";
        if (vector == null || vector.size() == 0) {
            return null;
        }
        int n2 = this._urlIndex;
        boolean bl = true;
        do {
            TibjmsxURL tibjmsxURL = (TibjmsxURL)this._urls.elementAt(n2);
            if (!bl) {
                string = string + ",";
            }
            bl = false;
            string = string + tibjmsxURL.getURL();
            if (++n2 != vector.size()) continue;
            n2 = 0;
        } while (n2 != n);
        return string;
    }

    public int getUrlCount() {
        Vector vector = this._urls;
        if (vector == null) {
            return 0;
        }
        return vector.size();
    }

    private boolean _processConnectionAcks(TibjmsConnection tibjmsConnection) {
        if (tibjmsConnection._closed) {
            return false;
        }
        boolean bl = false;
        Vector vector = tibjmsConnection._dups_ok_sessions;
        if (vector == null) {
            return false;
        }
        vector = (Vector)vector.clone();
        for (int j = 0; j < vector.size(); ++j) {
            TibjmsxSessionImp tibjmsxSessionImp = (TibjmsxSessionImp)vector.elementAt(j);
            bl |= tibjmsxSessionImp._processSessionDupsOkAcks();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _processAcks() {
        boolean bl = false;
        Object[] objectArray = null;
        ArrayList arrayList = _connections;
        synchronized (arrayList) {
            objectArray = _connections.toArray();
        }
        for (int j = 0; j < objectArray.length; ++j) {
            TibjmsConnection tibjmsConnection = (TibjmsConnection)objectArray[j];
            bl = this._processConnectionAcks(tibjmsConnection);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _determineHost() {
        Object object = _hostLock;
        synchronized (object) {
            try {
                if (!_hostDetermined) {
                    _hostDetermined = true;
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    if (inetAddress != null) {
                        _hostName = inetAddress.getHostName();
                        _hostIPAddr = inetAddress.getAddress();
                    }
                }
                return;
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            _hostName = null;
            _hostIPAddr = null;
        }
    }

    private void _setConnectAttemptParms(Map map, TibjmsxCFImpl tibjmsxCFImpl) {
        int n = 0;
        int n2 = 0;
        Object var7_5 = null;
        boolean bl = false;
        if (map != null) {
            n2 = 0;
            n = 0;
            var7_5 = map.get("com.tibco.tibjms.connect.attemptcount");
            if (var7_5 != null && var7_5 instanceof Integer) {
                n = var7_5;
            }
            if (n > 0) {
                this._connect_attempt_count = n;
            }
            if ((var7_5 = map.get("com.tibco.tibjms.connect.attemptdelay")) != null && var7_5 instanceof Integer) {
                n2 = var7_5;
            }
            if (n2 > 0) {
                this._connect_attempt_delay = n2;
            }
            n = 0;
            var7_5 = map.get("com.tibco.tibjms.connect.attempttimeout");
            if (var7_5 != null && var7_5 instanceof Integer) {
                n = var7_5;
            }
            if (n > 0) {
                this._connectAttemptTimeout = n;
                bl = true;
            }
            n = 0;
            if (!bl) {
                var7_5 = map.get("com.tibco.tibjms.connect.attempt.timeout");
                if (var7_5 != null && var7_5 instanceof Integer) {
                    n = var7_5;
                }
                if (n > 0) {
                    this._connectAttemptTimeout = n;
                }
            }
            n2 = 0;
            n = 0;
            var7_5 = map.get("com.tibco.tibjms.reconnect.attemptcount");
            if (var7_5 != null && var7_5 instanceof Integer) {
                n = var7_5;
            }
            if (n > 0) {
                this._reconnect_attempt_count = n;
            }
            if ((var7_5 = map.get("com.tibco.tibjms.reconnect.attemptdelay")) != null && var7_5 instanceof Integer) {
                n2 = var7_5;
            }
            if (n2 > 0) {
                this._reconnect_attempt_delay = n2;
            }
            n = 0;
            var7_5 = map.get("com.tibco.tibjms.reconnect.attempttimeout");
            if (var7_5 != null && var7_5 instanceof Integer) {
                n = var7_5;
            }
            if (n > 0) {
                this._reconnectAttemptTimeout = n;
            }
        }
        if (!tibjmsxCFImpl._wasCreatedByUfo || Tibjmsx.restore830ConnectBehavior) {
            String string;
            StringTokenizer stringTokenizer;
            String string2 = Tibjmsx.connectAttempts;
            if (string2 != null) {
                n2 = 0;
                n = 0;
                stringTokenizer = new StringTokenizer(string2, ",");
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 0;
                    }
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    try {
                        n2 = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n2 = 0;
                    }
                }
                if (n > 0) {
                    this._connect_attempt_count = n;
                    tibjmsxCFImpl._addProperty("com.tibco.tibjms.connect.attemptcount", new Integer(this._connect_attempt_count));
                }
                if (n2 > 0) {
                    this._connect_attempt_delay = n2;
                    tibjmsxCFImpl._addProperty("com.tibco.tibjms.connect.attemptdelay", new Integer(this._connect_attempt_delay));
                }
            }
            if (Tibjmsx.connectAttemptTimeout > 0) {
                this._connectAttemptTimeout = Tibjmsx.connectAttemptTimeout;
                tibjmsxCFImpl._addProperty("com.tibco.tibjms.connect.attempttimeout", new Integer(this._connectAttemptTimeout));
            }
            if ((string2 = Tibjmsx.reconnectAttempts) != null) {
                n2 = 0;
                n = 0;
                stringTokenizer = new StringTokenizer(string2, ",");
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 0;
                    }
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    try {
                        n2 = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n2 = 0;
                    }
                }
                if (n > 0) {
                    this._reconnect_attempt_count = n;
                    tibjmsxCFImpl._addProperty("com.tibco.tibjms.reconnect.attemptcount", new Integer(this._reconnect_attempt_count));
                }
                if (n2 > 0) {
                    this._reconnect_attempt_delay = n2;
                    tibjmsxCFImpl._addProperty("com.tibco.tibjms.reconnect.attemptdelay", new Integer(this._reconnect_attempt_delay));
                }
            }
            if (Tibjmsx.reconnectAttemptTimeout > 0) {
                this._reconnectAttemptTimeout = Tibjmsx.reconnectAttemptTimeout;
                tibjmsxCFImpl._addProperty("com.tibco.tibjms.reconnect.attempttimeout", new Integer(this._reconnectAttemptTimeout));
            }
        }
        if (this._connect_attempt_delay > 0 && this._connect_attempt_delay < 250) {
            this._connect_attempt_delay = 250;
            tibjmsxCFImpl._addProperty("com.tibco.tibjms.connect.attemptdelay", new Integer(250));
        }
        if (this._connectAttemptTimeout > 0 && this._connectAttemptTimeout < 100) {
            this._connectAttemptTimeout = 100;
            tibjmsxCFImpl._addProperty("com.tibco.tibjms.connect.attempttimeout", new Integer(100));
        }
        if (this._reconnect_attempt_delay > 0 && this._reconnect_attempt_delay < 250) {
            this._reconnect_attempt_delay = 250;
            tibjmsxCFImpl._addProperty("com.tibco.tibjms.reconnect.attemptdelay", new Integer(250));
        }
        if (this._reconnectAttemptTimeout > 0 && this._reconnectAttemptTimeout < 100) {
            this._reconnectAttemptTimeout = 100;
            tibjmsxCFImpl._addProperty("com.tibco.tibjms.reconnect.attempttimeout", new Integer(100));
        }
    }

    private void _setMulticastParms(Map map) {
        this._multicastEnabled = Tibjmsx.multicastEnabled;
        this._multicastDaemon = Tibjmsx.multicastDaemon;
        if (map != null) {
            Object v;
            Object v2 = map.get("com.tibco.tibjms.multicast.enabled");
            if (v2 != null && v2 instanceof Boolean) {
                this._multicastEnabled = (Boolean)v2;
            }
            if ((v = map.get("com.tibco.tibjms.multicast.daemon")) != null && v instanceof String) {
                this._multicastDaemon = (String)v;
            }
        }
        if (!Tibjmsx.multicastEnabled) {
            this._multicastEnabled = false;
        }
        if (Tibjmsx.multicastDaemon != null) {
            this._multicastDaemon = Tibjmsx.multicastDaemon;
        }
    }

    private void _startConnectTimeoutThread(int n) {
        if (this._connectTimeoutThread == null) {
            this._connectTimeoutThread = new ConnectTimeoutThread(n, this._link);
        }
        try {
            this._connectTimeoutThread.start();
        }
        catch (Exception exception) {
            return;
        }
    }

    private void _notifyConnectTimeoutThread(boolean bl, boolean bl2) {
        if (this._connectTimeoutThread != null) {
            this._connectTimeoutThread._notify(bl, bl2);
            this._connectTimeoutThread = null;
        }
    }

    boolean _shouldReconnectServer() {
        if (this._urls == null) {
            return false;
        }
        return this._urls.size() > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _create(TibjmsxCFImpl tibjmsxCFImpl, String string, String string2, String string3, String string4, Map map) throws JMSException {
        Object object;
        Object object2;
        Object object3;
        this._isAdmin = tibjmsxCFImpl._isAdmin;
        this._setConnectAttemptParms(map, tibjmsxCFImpl);
        this._setMulticastParms(map);
        this._properties = map;
        boolean bl = false;
        if (string3 == null && map != null) {
            object3 = map.get("com.tibco.tibjms.factory.username");
            if (object3 != null && !(object3 instanceof String)) {
                throw new JMSException("Invalid value of com.tibco.tibjms.factory.username");
            }
            Object v = map.get("com.tibco.tibjms.factory.password");
            if (v != null && !(v instanceof String)) {
                throw new JMSException("Invalid value of com.tibco.tibjms.factory.password");
            }
            if (object3 != null || v != null) {
                string3 = (String)object3;
                string4 = (String)v;
            }
        }
        this._clientID = tibjmsxCFImpl._clientID;
        if (this._clientID == null) {
            this._clientID = string2;
        }
        if (string.startsWith("$lic:")) {
            string = string.substring(5);
            bl = true;
        }
        this._urls = TibjmsxURL.parseMultiple(string);
        if (this._urls == null) {
            if (string != null && string.length() > 0) {
                throw new JMSException("Invalid server URL specification: " + string);
            }
            this._urls = new Vector();
            this._urls.addElement(TibjmsxURL.parse(null));
        }
        if (this._urls.size() > 1) {
            int n = 0;
            for (int j = 0; j < this._urls.size(); ++j) {
                object2 = (TibjmsxURL)this._urls.elementAt(j);
                if (j == 0) {
                    n = ((TibjmsxURL)object2).protocol;
                    continue;
                }
                if (n == ((TibjmsxURL)object2).protocol) continue;
                throw new JMSException("Illegal to use different protocols when multiple URLs are specified");
            }
        }
        if (this._urls.size() == 0) {
            throw new JMSException("Invalid URL");
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        this._userName = string3;
        if (string4 != null && string4.length() == 0) {
            string4 = null;
        }
        if (string4 != null) {
            this._password = Tibjmsx.manglePassword(string4);
        }
        TibjmsConnection._determineHost();
        this._metaData = new TibjmsConnectionMetaData(this);
        this._clear = true;
        this._proxyHost = tibjmsxCFImpl._proxyHost;
        this._proxyPort = tibjmsxCFImpl._proxyPort;
        this._proxyUsername = tibjmsxCFImpl._proxyUsername;
        this._proxyPassword = tibjmsxCFImpl._proxyPassword;
        object3 = null;
        boolean bl2 = this._urls.size() > 1;
        object2 = null;
        boolean bl3 = false;
        Throwable throwable = null;
        for (int j = 0; j < this._connect_attempt_count; ++j) {
            if (j > 0) {
                try {
                    object = new Random(System.currentTimeMillis());
                    Thread.sleep((long)this._connect_attempt_delay + (long)(((Random)object).nextDouble() * 100.0));
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new JMSException("Thread interrupted during connect attempts: Failed to connect to any server at: " + string);
                }
            }
            this._urlIndex = 0;
            while (this._urlIndex < this._urls.size()) {
                block41: {
                    object3 = (TibjmsxURL)this._urls.elementAt(this._urlIndex);
                    this._link = TibjmsxLink.create(new ServerLinkEventHandler(this), object3);
                    this._link.setUserNamePassword(string3, string4);
                    this._link.setProxyInfo(tibjmsxCFImpl._proxyHost, tibjmsxCFImpl._proxyPort, tibjmsxCFImpl._proxyUsername, tibjmsxCFImpl._proxyPassword);
                    this._link.setReconnect(this._shouldReconnectServer());
                    this._link.setProperties(this._properties);
                    if (this._connectAttemptTimeout > 0) {
                        this._startConnectTimeoutThread(this._connectAttemptTimeout);
                        throwable = null;
                    }
                    try {
                        this._link.connect((TibjmsxURL)object3);
                        object = this._doInitMsg(true, null, bl);
                        this._link.setPing(this._pingInterval);
                        if (object != null && ((TibjmsMessage)object)._type == 10) {
                            ArrayList arrayList = _connections;
                            synchronized (arrayList) {
                                _connections.add(this);
                            }
                            this._notifyConnectTimeoutThread(false, true);
                            this._link.start();
                            this._createChecker();
                            if (this._link instanceof TibjmsxLinkSSL) {
                                TibjmsSSL._erasePass();
                            }
                            return;
                        }
                        this._notifyConnectTimeoutThread(true, false);
                        this._link.disconnect();
                        object2 = Tibjmsx.buildException((TibjmsMessage)object);
                    }
                    catch (JMSException jMSException) {
                        this._link.disconnect();
                        object2 = jMSException;
                        if (this._connectTimeoutThread == null) break block41;
                        throwable = this._connectTimeoutThread._getExceptionByTimeoutThread();
                        this._notifyConnectTimeoutThread(true, false);
                    }
                }
                ++this._urlIndex;
                if (!this._serverRejectedClient((JMSException)object2)) continue;
                bl3 = true;
                break;
            }
            if (bl3) break;
        }
        if (this._link instanceof TibjmsxLinkSSL) {
            TibjmsSSL._erasePass();
        }
        if (object2 != null) {
            if (bl2) {
                Object object4;
                JMSException jMSException = null;
                object = "";
                if (object2 instanceof JMSSecurityException) {
                    object = "'" + ((Throwable)object2).getMessage();
                    object4 = null;
                    Object object5 = object2;
                    while ((object4 = ((Throwable)object5).getCause()) != null) {
                        object = (String)object + "' + '" + ((Throwable)object4).getMessage();
                        object5 = object4;
                    }
                    object = (String)object + "'";
                } else {
                    object = ((Throwable)object2).getMessage();
                }
                object4 = "Failed to connect to any server at: " + string + " [Error: " + (String)object + ": url that returned this exception = " + ((TibjmsxURL)this._urls.elementAt(this._urlIndex - 1)).getFullURL() + " ]";
                if (object2 instanceof JMSSecurityException) {
                    jMSException = new JMSSecurityException((String)object4);
                    jMSException.setLinkedException((Exception)object2);
                } else if (object2 instanceof ResourceAllocationException) {
                    jMSException = new ResourceAllocationException((String)object4);
                } else if (object2 instanceof InvalidClientIDException) {
                    jMSException = new InvalidClientIDException((String)object4);
                } else {
                    jMSException = new JMSException("Failed to connect to any server at: " + string);
                    jMSException.setLinkedException((Exception)(((JMSException)object2).getLinkedException() != null ? ((JMSException)object2).getLinkedException() : object2));
                }
                object2 = jMSException;
            }
            if (!bl3 && throwable != null) {
                object2 = bl2 ? new JMSException("Failed to connect to any server at: " + string + "[Error: " + throwable.getMessage()) : throwable;
            }
            throw object2;
        }
        this._notifyConnectTimeoutThread(true, false);
        throw new JMSException("Failed to connect to any server at: " + string);
    }

    private boolean _serverRejectedClient(JMSException jMSException) {
        return jMSException != null && (jMSException instanceof InvalidClientIDException || jMSException instanceof ResourceAllocationException || jMSException instanceof JMSSecurityException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long _getUTCoffset() {
        long l;
        Object object = this._UTCoffsetLock;
        synchronized (object) {
            l = this._UTCoffset;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setUTCoffset(TibjmsMessage tibjmsMessage) throws JMSException {
        long l = tibjmsMessage.getLongProperty("svrutc");
        Object object = this._UTCoffsetLock;
        synchronized (object) {
            this._UTCoffset = l - System.currentTimeMillis();
            if (Math.abs(this._UTCoffset) <= 100L) {
                this._UTCoffset = 0L;
            }
        }
    }

    TibjmsMessage _doInitMsg(boolean bl, TibjmsxStream[] tibjmsxStreamArray) throws JMSException {
        return this._doInitMsg(bl, tibjmsxStreamArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TibjmsMessage _doInitMsg(boolean bl, TibjmsxStream[] tibjmsxStreamArray, boolean bl2) throws JMSException {
        Cloneable cloneable;
        boolean bl3 = false;
        TibjmsxLinkSSL tibjmsxLinkSSL = null;
        TibjmsMessage tibjmsMessage = new TibjmsMessage(12);
        tibjmsMessage._responseID = Tibjmsx.getResponseID();
        if (this._link instanceof TibjmsxLinkSSL) {
            tibjmsxLinkSSL = (TibjmsxLinkSSL)this._link;
            bl3 = tibjmsxLinkSSL._auth_only;
            tibjmsMessage.setBooleanProperty("cssl", true);
            if (bl3) {
                tibjmsMessage.setBooleanProperty("cau", true);
            }
        }
        tibjmsMessage.setShortProperty("major", (short)10);
        tibjmsMessage.setShortProperty("minor", (short)2);
        tibjmsMessage.setShortProperty("update", (short)1);
        tibjmsMessage.setShortProperty("vbuild", (short)1);
        tibjmsMessage.setStringProperty("cltype", "J");
        tibjmsMessage.setStringProperty("user", this._userName != null ? this._userName : "anonymous");
        tibjmsMessage.setBooleanProperty("conft", this._urls.size() > 1);
        tibjmsMessage.setBooleanProperty("newtmp", this._newTempDests);
        if (this._isAdmin || bl2) {
            tibjmsMessage.setBooleanProperty("admin", true);
        }
        if (bl2) {
            tibjmsMessage.setBooleanProperty("lic", true);
        }
        if (this instanceof XAConnection || this instanceof XATopicConnection || this instanceof XAQueueConnection) {
            tibjmsMessage.setBooleanProperty("cxa", true);
            tibjmsMessage.setBooleanProperty("cxanp", true);
        }
        if (this._multicastEnabled) {
            tibjmsMessage.setBooleanProperty("mc_enabled", true);
        }
        if (!bl) {
            if (!bl3) {
                tibjmsMessage.setBooleanProperty("cstarted", this._started);
            } else {
                tibjmsMessage.setBooleanProperty("cstarted", false);
            }
            if (tibjmsxStreamArray != null && tibjmsxStreamArray.length > 0 && tibjmsxStreamArray[0] != null) {
                tibjmsMessage._setBytesProperty("txok", tibjmsxStreamArray[0].buffer, 0, tibjmsxStreamArray[0].curpos);
            }
            if (tibjmsxStreamArray != null && tibjmsxStreamArray.length > 1 && tibjmsxStreamArray[1] != null) {
                tibjmsMessage._setBytesProperty("qcstate", tibjmsxStreamArray[1].buffer, 0, tibjmsxStreamArray[1].curpos);
            }
            if (this._newTempDests) {
                this._addTempDests(tibjmsMessage);
            }
        }
        if (this._password != null) {
            tibjmsMessage.setBytesProperty("pass", this._password);
        }
        if (this._clientID != null && this._clientID.length() > 0) {
            tibjmsMessage.setStringProperty("clid", this._clientID);
        }
        if (this instanceof TibjmsTopicConnection || this instanceof TibjmsXATopicConnection) {
            tibjmsMessage.setIntProperty("ctype", 2);
        } else if (this instanceof TibjmsQueueConnection || this instanceof TibjmsXAQueueConnection) {
            tibjmsMessage.setIntProperty("ctype", 1);
        } else {
            tibjmsMessage.setIntProperty("ctype", 0);
        }
        if (_hostName != null) {
            tibjmsMessage.setStringProperty("host", _hostName);
        }
        if (this._connid != 0L) {
            tibjmsMessage.setLongProperty("conid", this._connid);
        }
        tibjmsMessage.setLongProperty("cltutc", System.currentTimeMillis());
        TibjmsMessage tibjmsMessage2 = this._link.syncSendRequest(tibjmsMessage, this._requestTimeout);
        if (tibjmsMessage2 == null || tibjmsMessage2._type != 10) {
            return tibjmsMessage2;
        }
        if (!this._noTrace && tibjmsMessage2.propertyExists("ctrc")) {
            this._traceTarget = tibjmsMessage2.getShortProperty("ctrc");
        }
        if (!this._noTrace && tibjmsMessage2.propertyExists("ctrmillis")) {
            TibjmsxTrace.setDoMills(tibjmsMessage2.getBooleanProperty("ctrmillis"));
        }
        if (tibjmsMessage2.propertyExists("svrutc")) {
            this._setUTCoffset(tibjmsMessage2);
        }
        this._serverMcastEnabled = false;
        if (tibjmsMessage2.propertyExists("mc_enabled")) {
            this._serverMcastEnabled = tibjmsMessage2.getBooleanProperty("mc_enabled");
        }
        this._setMulticastConsumerFlags(this._serverMcastEnabled);
        try {
            this._server_version = tibjmsMessage2.getStringProperty("version");
            this._server_version_major = tibjmsMessage2.getShortProperty("major");
            this._server_version_minor = tibjmsMessage2.getShortProperty("minor");
            this._server_version_update = tibjmsMessage2.getShortProperty("update");
            try {
                this._server_version_build = tibjmsMessage2.getShortProperty("vbuild");
            }
            catch (Exception exception) {
                this._server_version_build = 0;
            }
        }
        catch (Exception exception) {
            this._server_version = "<unknown>";
            this._server_version_major = 0;
            this._server_version_minor = 0;
            this._server_version_update = 0;
        }
        this._server_version_numeric = Tibjmsx.versionAsNumber(this._server_version_major, this._server_version_minor, this._server_version_update);
        try {
            this._compliantConsumers = tibjmsMessage2.getBooleanProperty("compc");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this._ssl_auth_only = tibjmsMessage2.getBooleanProperty("sau");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tibjmsMessage2.propertyExists("conid")) {
            this._connid = tibjmsMessage2.getLongProperty("conid");
            this._link.setLinkId("Server-" + this._connid);
            this._link.setType(0);
        }
        if (this._connid == 0L) {
            throw new JMSException("Invalid server response, no connection id");
        }
        if (tibjmsMessage2.propertyExists("pit")) {
            this._pingInterval = tibjmsMessage2.getIntProperty("pit");
        }
        if (tibjmsMessage2.propertyExists("shbc") && tibjmsMessage2.propertyExists("ctms")) {
            this._serverHeartbeatClient = tibjmsMessage2.getIntProperty("shbc");
            this._clientTimeoutServer = tibjmsMessage2.getIntProperty("ctms");
        }
        if (tibjmsMessage2.propertyExists("conns")) {
            this._metric_connections = tibjmsMessage2.getLongProperty("conns");
        }
        if (tibjmsMessage2.propertyExists("bytes")) {
            this._metric_byte_rate = tibjmsMessage2.getLongProperty("bytes");
        }
        if (this._clientID == null) {
            this._canChangeID = true;
        }
        this._requestTimeout = 60000L;
        if (tibjmsMessage2.propertyExists("secure")) {
            this._secure = tibjmsMessage2.getBooleanProperty("secure");
        }
        if (tibjmsMessage2.propertyExists("pfc")) {
            this._flowControl = tibjmsMessage2.getBooleanProperty("pfc");
        }
        if (tibjmsMessage2.propertyExists("ctd")) {
            this._compliantTempDests = tibjmsMessage2.getBooleanProperty("ctd");
        }
        if (tibjmsMessage2.propertyExists("npsmd")) {
            this._npsend_mode = tibjmsMessage2.getIntProperty("npsmd");
        }
        if (tibjmsMessage2.propertyExists("maxcmsg")) {
            this._maxMsgSize = tibjmsMessage2.getIntProperty("maxcmsg");
        }
        if (tibjmsMessage2.propertyExists("xadtmout")) {
            this._xa_default_timeout = tibjmsMessage2.getIntProperty("xadtmout");
        }
        if (tibjmsMessage2.propertyExists("xanp")) {
            this._xaNewProtocol = tibjmsMessage2.getBooleanProperty("xanp");
        }
        if (tibjmsMessage2.propertyExists("j20dc")) {
            this._jms20CompliantDeliveryCount = tibjmsMessage2.getBooleanProperty("j20dc");
        }
        boolean bl4 = false;
        if (tibjmsMessage2.propertyExists("newtmp")) {
            bl4 = tibjmsMessage2.getBooleanProperty("newtmp");
        }
        if (!bl4 && this._newTempDests) {
            this._newTempDests = false;
            cloneable = this._tempDests;
            synchronized (cloneable) {
                this._tempDests.clear();
            }
        }
        if (tibjmsxLinkSSL != null && bl3 && this._ssl_auth_only) {
            tibjmsxLinkSSL._request_cancel_ssl = true;
            cloneable = new TibjmsMessage(58);
            ((TibjmsMessage)cloneable)._responseID = Tibjmsx.getResponseID();
            this._link.syncSendRequest(cloneable, this._requestTimeout);
        }
        if (!bl && bl3 && this._started) {
            cloneable = new TibjmsMessage(14, Tibjmsx.getResponseID(), this._requestPriority);
            this._link.syncSendRequest(cloneable, this._requestTimeout);
        }
        return tibjmsMessage2;
    }

    public void _setNoTrace(boolean bl) {
        this._noTrace = bl;
        if (this._noTrace) {
            this._traceTarget = 0;
        }
    }

    TibjmsxStream[] _handleReconnectSessions() {
        Object object;
        int n;
        Vector vector = null;
        TibjmsxStream tibjmsxStream = null;
        int n2 = 0;
        TibjmsxStream[] tibjmsxStreamArray = new TibjmsxStream[2];
        TibjmsxStream tibjmsxStream2 = new TibjmsxStream();
        Vector vector2 = null;
        Vector vector3 = this._connectionConsumers;
        if (vector3 != null) {
            vector2 = (Vector)vector3.clone();
            for (n = 0; n < vector2.size(); ++n) {
                object = (TibjmsConnectionConsumer)vector2.elementAt(n);
                ((TibjmsConnectionConsumer)object)._onFTSwitch(tibjmsxStream2);
            }
        }
        vector = this._getAllSessions();
        for (n = 0; n < vector.size(); ++n) {
            object = (TibjmsxSessionImp)vector.elementAt(n);
            if (((TibjmsxSessionImp)object)._transacted && !((TibjmsxSessionImp)object)._tx_started) {
                if (tibjmsxStream == null) {
                    tibjmsxStream = new TibjmsxStream();
                }
                tibjmsxStream.writeVarLong(((TibjmsxSessionImp)object)._sessid);
                ++n2;
            }
            if (!((TibjmsxSessionImp)object)._alreadyProcessedForFT) {
                ((TibjmsxSessionImp)object)._onFTSwitch(tibjmsxStream2);
            }
            ((TibjmsxSessionImp)object)._alreadyProcessedForFT = false;
        }
        tibjmsxStreamArray[0] = tibjmsxStream;
        tibjmsxStreamArray[1] = tibjmsxStream2;
        return tibjmsxStreamArray;
    }

    boolean _reconnect() {
        this._resetServerHeartbeats();
        if (this._urls.size() <= 1) {
            return false;
        }
        if (Tibjmsx.ftEventsException) {
            this._invokeOnExceptionCallback(23, null, 0);
        }
        if (Tibjmsx.ftDelay > 0) {
            System.err.println("[Tibjms]: waiting " + Tibjmsx.ftDelay + " milliseconds before reconnecting via FT.");
            try {
                Thread.sleep(Tibjmsx.ftDelay);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return false;
            }
            System.err.println("[Tibjms]: proceeding with FT reconnect.");
        }
        TibjmsMessage tibjmsMessage = null;
        TibjmsxURL tibjmsxURL = null;
        TibjmsxStream[] tibjmsxStreamArray = this._handleReconnectSessions();
        int n = this._urlIndex;
        block6: for (int j = 0; j < this._reconnect_attempt_count; ++j) {
            Object object;
            try {
                object = new Random(System.currentTimeMillis() + this._connid);
                Thread.sleep((long)this._reconnect_attempt_delay + (long)(((Random)object).nextDouble() * 100.0));
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return false;
            }
            this._urlIndex = n + 1;
            while (true) {
                if (this._urlIndex >= this._urls.size()) {
                    this._urlIndex = 0;
                }
                tibjmsxURL = (TibjmsxURL)this._urls.elementAt(this._urlIndex);
                if (this._link instanceof TibjmsxLinkSSL) {
                    object = (TibjmsxLinkSSL)this._link;
                    String string = ((TibjmsxLinkSSL)object)._expected_hostname;
                    if (string == null) {
                        string = tibjmsxURL.host;
                    }
                    ((TibjmsxLinkSSL)object).setHostNameVerifier(string);
                }
                if (Tibjmsx.ftEventsException) {
                    this._invokeOnExceptionCallback(24, null, j + 1);
                }
                if (this._reconnectAttemptTimeout > 0) {
                    this._startConnectTimeoutThread(this._reconnectAttemptTimeout);
                }
                if (!this._link.reconnect(tibjmsxURL)) {
                    this._notifyConnectTimeoutThread(true, false);
                } else {
                    try {
                        tibjmsMessage = this._doInitMsg(false, tibjmsxStreamArray);
                        if (tibjmsMessage != null) {
                            if (tibjmsMessage._type == 10) {
                                this._notifyConnectTimeoutThread(false, true);
                                this._link.setPing(this._pingInterval);
                                if (Tibjmsx.ftEventsException || Tibjmsx.ftSwitchException) {
                                    this._invokeOnExceptionCallback(28, null, 0);
                                }
                                this._link.pushRequests((byte)4);
                                this._createChecker();
                                object = this._getAllSessions();
                                for (int k = 0; k < ((Vector)object).size(); ++k) {
                                    TibjmsxSessionImp tibjmsxSessionImp = (TibjmsxSessionImp)((Vector)object).elementAt(k);
                                    tibjmsxSessionImp.resendPendingCloseConsumerRequests();
                                }
                                return true;
                            }
                            if (tibjmsMessage.propertyExists("cause")) {
                                this._closedReasonString = tibjmsMessage.getStringProperty("cause");
                                j = this._reconnect_attempt_count;
                                continue block6;
                            }
                        }
                        this._notifyConnectTimeoutThread(true, false);
                        this._link.disconnect();
                    }
                    catch (JMSException jMSException) {
                        this._notifyConnectTimeoutThread(true, false);
                    }
                }
                if (this._urlIndex == n) continue block6;
                ++this._urlIndex;
            }
        }
        this._notifyConnectTimeoutThread(true, false);
        return false;
    }

    private void _invokeOnExceptionCallback(int n, Exception exception, int n2) {
        if (this._exceptionListener == null) {
            return;
        }
        JMSException jMSException = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = ((TibjmsxURL)this._urls.elementAt(this._urlIndex)).getURL();
        switch (n) {
            case 23: {
                string2 = string = "Disconnected from " + string4 + ", will attempt to reconnect";
                string3 = "Disconnected";
                break;
            }
            case 24: {
                string2 = string = "Reconnecting to " + string4 + ", attempt " + n2 + " out of " + this._reconnect_attempt_count;
                string3 = "Reconnecting";
                break;
            }
            case 28: {
                if (Tibjmsx.ftSwitchException && !Tibjmsx.ftEventsException) {
                    string = "Connection has performed fault-tolerant switch to " + string4;
                    string2 = string4;
                } else {
                    string2 = string = "Reconnected to " + string4;
                }
                string3 = "Reconnected";
                break;
            }
            case 11: {
                String string5 = this._getTerminatedText();
                jMSException = this._timedout ? Tibjmsx.buildException(string5, null, null) : (exception != null && exception instanceof JMSException ? (JMSException)exception : Tibjmsx.buildException(string5, null, exception));
                string3 = "Disconnected";
                break;
            }
            default: {
                string2 = string = "Unknown";
                string3 = string;
            }
        }
        if (jMSException == null) {
            jMSException = new JMSException(string, "FT-SWITCH: " + string2);
        }
        try {
            if (this._traceTarget != 0) {
                TibjmsxTrace.write(this._traceTarget, "before exception callback conn={0,number,###0.##} status={1}", new Object[]{new Long(this._connid), string3});
            }
            this._exceptionListener.onException(jMSException);
            if (this._traceTarget != 0) {
                TibjmsxTrace.write(this._traceTarget, "after exception callback conn={0,number,###0.##} status={1}", new Object[]{new Long(this._connid), string3});
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _pushConnectionRequests() {
        HashMap hashMap = this._connectionRequests;
        synchronized (hashMap) {
            this._closing = true;
            this._link.pushConnectionRequests((byte)8, this._connectionRequests);
            this._connectionRequests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _removeConnectionRequests(int n) {
        HashMap hashMap = this._connectionRequests;
        synchronized (hashMap) {
            this._connectionRequests.remove(new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _start() throws JMSException {
        int n = -1;
        if (this._started && !this._closed && !this._closing) {
            return;
        }
        Object object = this._connectionRequests;
        synchronized (object) {
            if (this._closing) {
                throw new IllegalStateException("Connection is being closed");
            }
            n = Tibjmsx.getResponseID();
            this._connectionRequests.put(new Integer(n), null);
        }
        object = this._lock;
        synchronized (object) {
            if (this._started || this._stopping) {
                this._removeConnectionRequests(n);
                return;
            }
            if (this._closed) {
                this._removeConnectionRequests(n);
                throw new IllegalStateException("Connection is closed");
            }
            this._clear = false;
            if (this._started) {
                this._removeConnectionRequests(n);
                return;
            }
            TibjmsMessage tibjmsMessage = new TibjmsMessage(14, n, this._requestPriority);
            TibjmsMessage tibjmsMessage2 = this._link.sendRequestMsg(tibjmsMessage, this._requestTimeout, new StartCB());
            this._removeConnectionRequests(n);
            if (tibjmsMessage2 == null || tibjmsMessage2._type != 10) {
                throw Tibjmsx.buildException(tibjmsMessage2);
            }
            Vector vector = this._getAllSessions();
            for (int j = 0; j < vector.size(); ++j) {
                TibjmsxSessionImp tibjmsxSessionImp = (TibjmsxSessionImp)vector.elementAt(j);
                tibjmsxSessionImp._start();
            }
            this._startMd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _stop() throws JMSException {
        TibjmsxConst tibjmsxConst;
        Vector vector = null;
        int n = -1;
        if (!(this._started || this._closed || this._closing)) {
            return;
        }
        Object object = this._connectionRequests;
        synchronized (object) {
            if (this._closing) {
                throw new IllegalStateException("Connection is being closed");
            }
            n = Tibjmsx.getResponseID();
            this._connectionRequests.put(new Integer(n), null);
        }
        object = this._lock;
        synchronized (object) {
            if (this._closed) {
                this._removeConnectionRequests(n);
                throw new IllegalStateException("Connection is closed");
            }
            this._clear = false;
            if (!this._started) {
                this._removeConnectionRequests(n);
                return;
            }
            tibjmsxConst = new TibjmsMessage(15, n, this._requestPriority);
            TibjmsMessage tibjmsMessage = this._link.sendRequestMsg((TibjmsMessage)tibjmsxConst, this._requestTimeout);
            this._removeConnectionRequests(n);
            if (tibjmsMessage == null || tibjmsMessage._type != 10) {
                throw Tibjmsx.buildException(tibjmsMessage);
            }
            vector = this._getAllSessions();
            this._started = false;
            this._stopping = true;
        }
        for (int j = 0; j < vector.size(); ++j) {
            tibjmsxConst = (TibjmsxSessionImp)vector.elementAt(j);
            ((TibjmsxSessionImp)tibjmsxConst)._stop();
        }
        this._stopping = false;
        this._stopMd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _close(boolean bl) throws JMSException {
        Object object;
        Vector vector = null;
        int n = 0;
        boolean bl2 = false;
        Object object2 = this._lock;
        synchronized (object2) {
            if (this._closed) {
                return;
            }
            this._clear = false;
            this._closed = true;
            if (!bl) {
                this._closedReason = 1;
                bl2 = true;
            } else {
                this._link.pushRequests((byte)2);
            }
            vector = this._getAllSessions();
            this._started = false;
        }
        for (int j = 0; j < vector.size(); ++j) {
            object = (TibjmsxSessionImp)vector.elementAt(j);
            try {
                ((TibjmsxSessionImp)object)._close(bl, true);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl2) {
            HashMap hashMap = this._connectionRequests;
            synchronized (hashMap) {
                if (this._closing) {
                    bl2 = false;
                } else {
                    n = Tibjmsx.getResponseID();
                    this._connectionRequests.put(new Integer(n), null);
                }
            }
        }
        Object object3 = this._lock;
        synchronized (object3) {
            this._sessions.clear();
            if (this._dups_ok_sessions != null) {
                this._dups_ok_sessions.clear();
            }
            this._consumers.clear();
            this._subscriptions.clear();
            if (!bl) {
                if (bl2) {
                    this._link.setClosing();
                    object = new TibjmsMessage(13, n, 9);
                    try {
                        this._link.sendRequestMsg((TibjmsMessage)object, -1L);
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                    this._removeConnectionRequests(n);
                }
                this._link.disconnect();
                this._link.pushRequests((byte)2);
            }
            object = _connections;
            synchronized (object) {
                _connections.remove(this);
                if (_connections.size() == 0) {
                    Object object4 = _dupsNotifier;
                    synchronized (object4) {
                        DOT dOT = _dot;
                        _dot = null;
                        if (dOT != null) {
                            dOT.stop();
                            _dupsNotifier.notify();
                        }
                    }
                }
            }
            this._started = false;
        }
    }

    void _onDisconnected(Exception exception) {
        this._pushConnectionRequests();
        try {
            this._close(true);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this._link.pushRequests((byte)2);
        this._invokeOnExceptionCallback(11, exception, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector _getAllSessions() {
        HashMap hashMap = this._sessions;
        synchronized (hashMap) {
            Vector vector = new Vector();
            Iterator iterator2 = this._sessions.values().iterator();
            while (iterator2.hasNext()) {
                vector.addElement(iterator2.next());
            }
            return vector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _addSession(TibjmsxSessionImp tibjmsxSessionImp) {
        HashMap hashMap = this._sessions;
        synchronized (hashMap) {
            this._sessions.put(new TibjmsxLongKey(tibjmsxSessionImp._sessid), tibjmsxSessionImp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TibjmsxSessionImp _getSession(long l) {
        HashMap hashMap = this._sessions;
        synchronized (hashMap) {
            this._sessionKey.set(l);
            return (TibjmsxSessionImp)this._sessions.get(this._sessionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _closeSession(TibjmsxSessionImp tibjmsxSessionImp) {
        HashMap hashMap = this._sessions;
        synchronized (hashMap) {
            this._sessionKey.set(tibjmsxSessionImp._sessid);
            this._sessions.remove(this._sessionKey);
            if (tibjmsxSessionImp._connectionConsumerSession == null) {
                for (int j = 0; j < tibjmsxSessionImp._consumers.size(); ++j) {
                    TibjmsMessageConsumer tibjmsMessageConsumer = (TibjmsMessageConsumer)tibjmsxSessionImp._consumers.elementAt(j);
                    this._removeConsumer(tibjmsMessageConsumer);
                }
            }
            if (!(tibjmsxSessionImp._transacted || tibjmsxSessionImp._ackMode != 3 && tibjmsxSessionImp._ackMode != 24 || this._dups_ok_sessions == null)) {
                this._dups_ok_sessions.remove(tibjmsxSessionImp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _addTempDest(TibjmsDestination tibjmsDestination) throws JMSException {
        if (tibjmsDestination != null) {
            HashMap hashMap = this._tempDests;
            synchronized (hashMap) {
                this._tempDests.put(tibjmsDestination._address, tibjmsDestination);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _removeTempDest(TibjmsDestination tibjmsDestination) throws JMSException {
        if (tibjmsDestination != null) {
            HashMap hashMap = this._tempDests;
            synchronized (hashMap) {
                this._tempDests.remove(tibjmsDestination._address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _isValidTempDest(TibjmsDestination tibjmsDestination) {
        if (tibjmsDestination == null) {
            return false;
        }
        HashMap hashMap = this._tempDests;
        synchronized (hashMap) {
            return this._tempDests.containsKey(tibjmsDestination._address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addTempDests(TibjmsMessage tibjmsMessage) throws JMSException {
        HashMap hashMap = this._tempDests;
        synchronized (hashMap) {
            if (!this._tempDests.isEmpty()) {
                Iterator iterator2 = this._tempDests.values().iterator();
                int n = 0;
                int n2 = 0;
                while (iterator2.hasNext()) {
                    TibjmsDestination tibjmsDestination = (TibjmsDestination)iterator2.next();
                    if (tibjmsDestination instanceof TibjmsQueue) {
                        tibjmsMessage.setStringProperty("tmpq" + n2, tibjmsDestination._address);
                        ++n2;
                        continue;
                    }
                    tibjmsMessage.setStringProperty("tmpt" + n, tibjmsDestination._address);
                    ++n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _addConsumer(TibjmsMessageConsumer tibjmsMessageConsumer) throws JMSException {
        HashMap hashMap = this._consumers;
        synchronized (hashMap) {
            this._consumers.put(new TibjmsxLongKey(tibjmsMessageConsumer._consid), tibjmsMessageConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _removeConsumer(TibjmsMessageConsumer tibjmsMessageConsumer) {
        HashMap hashMap = this._consumers;
        synchronized (hashMap) {
            this._consKey.set(tibjmsMessageConsumer._consid);
            this._consumers.remove(this._consKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _removeConsumer(long l) {
        HashMap hashMap = this._consumers;
        synchronized (hashMap) {
            this._consKey.set(l);
            this._consumers.remove(this._consKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TibjmsMessageConsumer _getConsumer(long l) {
        HashMap hashMap = this._consumers;
        synchronized (hashMap) {
            this._consKey.set(l);
            return (TibjmsMessageConsumer)this._consumers.get(this._consKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _addConnectionConsumer(ConnectionConsumer connectionConsumer) {
        Object object = this._lock;
        synchronized (object) {
            if (this._connectionConsumers == null) {
                this._connectionConsumers = new Vector();
            }
            this._connectionConsumers.addElement(connectionConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _removeConnectionConsumer(ConnectionConsumer connectionConsumer) {
        Object object = this._lock;
        synchronized (object) {
            if (this._connectionConsumers != null) {
                this._connectionConsumers.removeElement(connectionConsumer);
            }
        }
    }

    TibjmsxSessionImp _createSession(int n, boolean bl, int n2) throws JMSException {
        return this._createSession(n, bl, n2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TibjmsxSessionImp _createSession(int n, boolean bl, int n2, boolean bl2) throws JMSException {
        if (!(bl2 || bl || Tibjmsx.checkAcknowledgeMode(n2, this))) {
            throw new IllegalArgumentException("Invalid acknowledge mode value " + n2);
        }
        TibjmsxSessionImp tibjmsxSessionImp = null;
        TibjmsMessage tibjmsMessage = null;
        TibjmsMessage tibjmsMessage2 = null;
        boolean bl3 = false;
        Object object = this._lock;
        synchronized (object) {
            if (this._closed) {
                throw new IllegalStateException("Connection is closed");
            }
            this._clear = false;
            tibjmsMessage2 = new TibjmsMessage(16, Tibjmsx.getResponseID(), this._requestPriority);
            tibjmsMessage2.setBooleanProperty("tx", bl);
            int n3 = n2;
            if (!bl) {
                if (n2 == 23) {
                    bl3 = true;
                    n3 = 2;
                } else if (n2 == 24) {
                    bl3 = true;
                    n3 = 3;
                }
            }
            tibjmsMessage2.setIntProperty("ac", n3);
            tibjmsMessage2.setByteProperty("stype", (byte)n);
            tibjmsMessage2.setBooleanProperty("xa", bl2);
        }
        tibjmsMessage = this._link.sendRequestMsg(tibjmsMessage2, this._requestTimeout);
        object = this._lock;
        synchronized (object) {
            if (this._closed) {
                throw new IllegalStateException("Connection is closed");
            }
            if (tibjmsMessage == null || tibjmsMessage._type != 10) {
                throw Tibjmsx.buildException(tibjmsMessage);
            }
            long l = 0L;
            String string = null;
            try {
                l = tibjmsMessage.getLongProperty("sessid");
                string = tibjmsMessage.getStringProperty("msgid");
            }
            catch (Exception exception) {
                l = 0L;
                string = null;
            }
            if (l == 0L || string == null) {
                throw new JMSException("Malformed server response");
            }
            tibjmsxSessionImp = n == 0 ? (!bl2 ? new TibjmsxSessionImp(this, l, n2, bl3, bl, false) : new TibjmsXASession(this, l)) : (n == 2 ? (!bl2 ? new TibjmsTopicSession(this, l, n2, bl3, bl, false) : new TibjmsXATopicSession(this, l)) : (!bl2 ? new TibjmsQueueSession(this, l, n2, bl3, bl, false) : new TibjmsXAQueueSession(this, l)));
            tibjmsxSessionImp._uniqueid = string;
            tibjmsxSessionImp._msgid = "ID:" + string + ":";
            tibjmsxSessionImp._jms20CompliantDeliveryCount = this._jms20CompliantDeliveryCount;
            tibjmsxSessionImp._ftmode = this._urls != null ? this._urls.size() > 1 : false;
            this._addSession(tibjmsxSessionImp);
            if (!(tibjmsxSessionImp._transacted || tibjmsxSessionImp._ackMode != 3 && tibjmsxSessionImp._ackMode != 24)) {
                Object object2 = this._sessions;
                synchronized (object2) {
                    if (this._dups_ok_sessions == null) {
                        this._dups_ok_sessions = new Vector();
                    }
                    this._dups_ok_sessions.add(tibjmsxSessionImp);
                }
                object2 = _dupsNotifier;
                synchronized (object2) {
                    if (_dot == null) {
                        _dot = new DOT();
                    }
                }
            }
            tibjmsxSessionImp._started = this._started;
            if (this._traceTarget != 0) {
                TibjmsxTrace.write(this._traceTarget, "{0}Connection Create {1}Session conn={2,number,###0.##} sess={3,number,###0.##} transacted={4} ackmode={5,number,###0.##}", new Object[]{this._getTypeStr(), tibjmsxSessionImp._getTypeStr(), new Long(this._connid), new Long(tibjmsxSessionImp._sessid), bl ? "true" : "false", new Integer(n2)});
            }
            return tibjmsxSessionImp;
        }
    }

    void _processMessage(TibjmsxLink tibjmsxLink, byte[] byArray) throws EOFException, JMSException {
        TibjmsxStream tibjmsxStream = new TibjmsxStream(byArray);
        tibjmsxStream.skipRvHeader();
        int n = tibjmsxStream.curpos;
        int n2 = tibjmsxStream.readUnsignedByte();
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this._processDataMessage(tibjmsxLink, tibjmsxStream, n2);
                break;
            }
            case 10: 
            case 11: {
                long l = tibjmsxStream.readInt();
                if (n2 == 10 && tibjmsxStream.available() == 0) {
                    if (l <= 0L) break;
                    tibjmsxLink.processResponse(Tibjmsx.response_ok, l);
                    break;
                }
                TibjmsMessage tibjmsMessage = new TibjmsMessage(byArray, 1);
                if (l <= 0L) break;
                tibjmsxLink.processResponse(tibjmsMessage, tibjmsMessage._responseID);
                break;
            }
            case 30: {
                tibjmsxStream.buffer[n] = 31;
                tibjmsxLink.send(tibjmsxStream.buffer, 1);
                break;
            }
            case 55: {
                break;
            }
            case 70: {
                this._processFTInfoMsg(new TibjmsMessage(byArray, 1));
                break;
            }
            case 88: {
                this._handleAsyncCmd(new TibjmsMessage(byArray, 1));
                break;
            }
            case 124: {
                this._processMulticastStatus(new TibjmsMessage(byArray, 1));
                break;
            }
            case 118: {
                this._processMDaemonStats(new TibjmsMessage(byArray, 1));
                break;
            }
            default: {
                if (!Tibjmsx._debug) break;
                Tibjmsx.print("[Tibjms Error]: unrecognized protocol message sent by the server. type=" + n2);
                try {
                    Tibjmsx.print("Message Content: " + new TibjmsMessage(byArray, 1));
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    void _processFTInfoMsg(TibjmsMessage tibjmsMessage) throws EOFException, JMSException {
    }

    void _processDataMessage(TibjmsxLink tibjmsxLink, TibjmsxStream tibjmsxStream, int n) throws JMSException {
        long l = -1L;
        int n2 = 0;
        int n3 = 0;
        try {
            tibjmsxStream.readInt();
            block11: while (tibjmsxStream.available() > 0) {
                int n4 = tibjmsxStream.readUnsignedByte();
                switch (n4) {
                    case 22: {
                        tibjmsxStream.skipLength(2);
                        continue block11;
                    }
                    case 23: {
                        tibjmsxStream.skipLength(4);
                        continue block11;
                    }
                    case 24: {
                        tibjmsxStream.skipLength(4);
                        continue block11;
                    }
                    case 26: {
                        l = tibjmsxStream.readVarLong();
                        continue block11;
                    }
                    case 25: {
                        n2 = tibjmsxStream.curpos;
                        n3 = tibjmsxStream.readUnsignedShort();
                        tibjmsxStream.skip(n3);
                        continue block11;
                    }
                }
                long l2 = tibjmsxStream.readVarLong();
                if (l2 == -1L) continue;
                tibjmsxStream.skip((int)l2);
            }
        }
        catch (EOFException eOFException) {
            throw new JMSException("Corrupted message");
        }
        if (l == -1L || n2 == 0) {
            throw new JMSException("Corrupted incoming data message: seq=" + l + " destids=" + n2);
        }
        TibjmsMessage tibjmsMessage = TibjmsMessage.createFromBytes(tibjmsxStream.buffer, 0);
        if (this._traceTarget != 0) {
            TibjmsxTrace.write(this._traceTarget, "received msg from daemon conn={0,number,###0.##} seqid={1,number,###0.##} msgid={2}", new Object[]{new Long(this._connid), new Long(tibjmsMessage._sequenceID), tibjmsMessage._JMSMessageID != null ? tibjmsMessage._JMSMessageID : "{not set}"});
        }
        tibjmsMessage._session = this._getSession(tibjmsMessage._sessid);
        if (tibjmsxLink != null) {
            tibjmsMessage._linkType = tibjmsxLink._type;
        }
        try {
            tibjmsxStream.curpos = n2;
            n3 = tibjmsxStream.readUnsignedShort();
            long l3 = tibjmsxStream.readVarLong();
            int n5 = 0;
            while ((long)n5 < l3) {
                TibjmsxSessionImp tibjmsxSessionImp;
                long l4 = tibjmsxStream.readVarLong();
                TibjmsMessageConsumer tibjmsMessageConsumer = this._getConsumer(l4);
                if (tibjmsMessageConsumer != null && (tibjmsxSessionImp = tibjmsMessageConsumer._getSession()) != null && !tibjmsMessageConsumer._isClosed()) {
                    TibjmsMessage tibjmsMessage2 = (long)n5 != l3 - 1L ? (TibjmsMessage)tibjmsMessage.clone() : tibjmsMessage;
                    tibjmsxSessionImp._postMessage(tibjmsMessageConsumer, tibjmsMessage2, true);
                }
                ++n5;
            }
        }
        catch (EOFException eOFException) {
            throw new JMSException("Corrupted message");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _handleAsyncCmd(TibjmsMessage tibjmsMessage) throws JMSException {
        TibjmsxLink tibjmsxLink = null;
        if (!this._noTrace && tibjmsMessage.propertyExists("ctrc")) {
            this._traceTarget = tibjmsMessage.getShortProperty("ctrc");
            Object object = this._md_lock;
            synchronized (object) {
                if (this._md_link != null && this._md_link.isConnected()) {
                    tibjmsMessage._type = 119;
                    tibjmsxLink = this._md_link;
                }
            }
            if (tibjmsxLink != null) {
                tibjmsxLink.send(tibjmsMessage, 2);
            }
        }
        if (tibjmsMessage.propertyExists("svrutc")) {
            this._setUTCoffset(tibjmsMessage);
        }
    }

    ConnectionConsumer _createConnectionConsumer(Destination destination, String string, boolean bl, boolean bl2, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        TibjmsConnectionConsumer tibjmsConnectionConsumer = null;
        if (destination == null || serverSessionPool == null) {
            throw new JMSException("null parameter");
        }
        if (n < 0) {
            throw new JMSException("invalid maxMessages");
        }
        tibjmsConnectionConsumer = new TibjmsConnectionConsumer(this, destination, string, bl, bl2, string2, serverSessionPool, n);
        if (tibjmsConnectionConsumer != null && this._traceTarget != 0) {
            if (bl2) {
                TibjmsxTrace.write(this._traceTarget, "{0}Connection Create Shared{1}ConnectionConsumer conn={2,number,###0.##} dest={3} name={4} msgsel=[{5}] maxmsg={6,number,###0.##}", new Object[]{this._getTypeStr(), bl ? " Durable" : " ", new Long(this._connid), destination.toString(), string, string2 != null ? string2 : "{not set}", new Integer(n)});
            } else if (!bl) {
                TibjmsxTrace.write(this._traceTarget, "{0}Connection Create ConnectionConsumer conn={1,number,###0.##} dest={2} msgsel=[{3}] maxmsg={4,number,###0.##}", new Object[]{this._getTypeStr(), new Long(this._connid), destination.toString(), string2 != null ? string2 : "{not set}", new Integer(n)});
            } else {
                TibjmsxTrace.write(this._traceTarget, "{0}Connection Create DurableConnectionConsumer conn={1,number,###0.##} dest={2} durname={3} msgsel=[{4}] maxmsg={5,number,###0.##}", new Object[]{this._getTypeStr(), new Long(this._connid), destination.toString(), string, string2 != null ? string2 : "{not set}", new Integer(n)});
            }
        }
        return tibjmsConnectionConsumer;
    }

    @Override
    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        ConnectionConsumer connectionConsumer = this._createConnectionConsumer(topic, string, false, true, string2, serverSessionPool, n);
        return connectionConsumer;
    }

    @Override
    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        ConnectionConsumer connectionConsumer = this._createConnectionConsumer(topic, string, true, true, string2, serverSessionPool, n);
        return connectionConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _createMdLink(String string) throws JMSException {
        Object object;
        Object object2;
        int n;
        this._setMulticastDaemon(string);
        if (this._md_urls == null) {
            if (string != null && string.length() > 0) {
                throw new JMSException("Invalid server URL specification: " + string);
            }
            this._md_urls = new Vector();
            this._md_urls.addElement(TibjmsxURL.parse(null));
        }
        if (this._md_urls.size() > 1) {
            int n2 = 0;
            for (n = 0; n < this._md_urls.size(); ++n) {
                object2 = (TibjmsxURL)this._md_urls.elementAt(n);
                if (n == 0) {
                    n2 = ((TibjmsxURL)object2).protocol;
                    continue;
                }
                if (n2 == ((TibjmsxURL)object2).protocol) continue;
                throw new JMSException("Illegal to use different protocols when multiple URLs are specified");
            }
        }
        if (this._md_urls.size() == 0) {
            throw new JMSException("Invalid URL");
        }
        TibjmsxURL tibjmsxURL = null;
        n = this._md_urls.size() > 1 ? 1 : 0;
        object2 = null;
        boolean bl = false;
        Throwable throwable = null;
        for (int j = 0; j < this._connect_attempt_count; ++j) {
            if (j > 0) {
                try {
                    object = new Random(System.currentTimeMillis());
                    Thread.sleep((long)this._connect_attempt_delay + (long)(((Random)object).nextDouble() * 100.0));
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new JMSException("Thread interrupted during connect attempts: Failed to connect to server at: " + string);
                }
            }
            this._md_urlIndex = 0;
            while (this._md_urlIndex < this._md_urls.size()) {
                block27: {
                    tibjmsxURL = (TibjmsxURL)this._md_urls.elementAt(this._md_urlIndex);
                    this._md_link = TibjmsxLink.create(new MDaemonLinkEventHandler(this), tibjmsxURL);
                    this._md_link.setReconnect(true);
                    if (this._connectAttemptTimeout > 0) {
                        this._startConnectTimeoutThread(this._connectAttemptTimeout);
                        throwable = null;
                    }
                    try {
                        this._md_link.connect(tibjmsxURL);
                        object = this._doInitMsgMd(true);
                        this._md_link.setPing(this._pingInterval);
                        if (object != null && ((TibjmsMessage)object)._type == 10) {
                            this._notifyMdConnectTimeoutThread(false, true);
                            this._md_link.start();
                            this._md_closed = false;
                            HashMap hashMap = this._connectionRequests;
                            synchronized (hashMap) {
                                this._md_closing = false;
                            }
                            return;
                        }
                        this._notifyMdConnectTimeoutThread(true, false);
                        this._md_link.disconnect();
                        object2 = Tibjmsx.buildException((TibjmsMessage)object);
                    }
                    catch (JMSException jMSException) {
                        this._md_link.disconnect();
                        object2 = jMSException;
                        if (this._md_connectTimeoutThread == null) break block27;
                        throwable = this._md_connectTimeoutThread._getExceptionByTimeoutThread();
                        this._notifyMdConnectTimeoutThread(true, false);
                    }
                }
                ++this._md_urlIndex;
                if (!this._serverRejectedClient((JMSException)object2)) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (object2 != null) {
            if (n != 0) {
                JMSException jMSException = null;
                object = "Failed to connect to any multicast daemon at: " + string + " [Error: " + ((Throwable)object2).getMessage() + ": url that returned this exception = " + ((TibjmsxURL)this._md_urls.elementAt(this._md_urlIndex - 1)).getFullURL() + " ]";
                if (object2 instanceof JMSSecurityException) {
                    jMSException = new JMSSecurityException((String)object);
                } else if (object2 instanceof ResourceAllocationException) {
                    jMSException = new ResourceAllocationException((String)object);
                } else if (object2 instanceof InvalidClientIDException) {
                    jMSException = new InvalidClientIDException((String)object);
                } else {
                    jMSException = new JMSException("Failed to connect to any server at: " + string);
                    jMSException.setLinkedException((Exception)(((JMSException)object2).getLinkedException() != null ? ((JMSException)object2).getLinkedException() : object2));
                }
                object2 = jMSException;
            }
            if (!bl && throwable != null) {
                object2 = n != 0 ? new JMSException("Failed to connect to any multicast daemon at: " + string + "[Error: " + throwable.getMessage()) : throwable;
            }
            throw object2;
        }
        this._notifyMdConnectTimeoutThread(true, false);
        throw new JMSException("Failed to connect to any multicast daemon at: " + string);
    }

    private TibjmsMessage _doInitMsgMd(boolean bl) throws JMSException {
        TibjmsMessage tibjmsMessage;
        TibjmsMessage tibjmsMessage2 = new TibjmsMessage(110);
        tibjmsMessage2._responseID = Tibjmsx.getResponseID();
        tibjmsMessage2.setShortProperty("major", (short)10);
        tibjmsMessage2.setShortProperty("minor", (short)2);
        tibjmsMessage2.setShortProperty("update", (short)1);
        tibjmsMessage2.setShortProperty("vbuild", (short)1);
        tibjmsMessage2.setBooleanProperty("conft", this._md_urls.size() > 1);
        if (this._clientID != null && this._clientID.length() > 0) {
            tibjmsMessage2.setStringProperty("clid", this._clientID);
        }
        if (_hostName != null) {
            tibjmsMessage2.setStringProperty("host", _hostName);
        }
        if (this._md_connid != 0L) {
            tibjmsMessage2.setLongProperty("mdconid", this._md_connid);
        }
        tibjmsMessage2.setLongProperty("cltutc", System.currentTimeMillis());
        tibjmsMessage2.setBooleanProperty("cstarted", this._started);
        tibjmsMessage2.setShortProperty("ctrc", this._traceTarget);
        if (this._serverHeartbeatClient > 0) {
            tibjmsMessage2.setIntProperty("shbc", this._serverHeartbeatClient);
        }
        if ((tibjmsMessage = this._md_link.syncSendRequest(tibjmsMessage2, this._requestTimeout)) == null || tibjmsMessage._type != 10) {
            return tibjmsMessage;
        }
        this._md_version = tibjmsMessage.getStringProperty("version");
        this._md_version_major = tibjmsMessage.getShortProperty("major");
        this._md_version_minor = tibjmsMessage.getShortProperty("minor");
        this._md_version_update = tibjmsMessage.getShortProperty("update");
        try {
            this._md_version_build = tibjmsMessage.getShortProperty("vbuild");
        }
        catch (Exception exception) {
            this._md_version_build = 0;
        }
        this._md_version_numeric = Tibjmsx.versionAsNumber(this._md_version_major, this._md_version_minor, this._md_version_update);
        if (tibjmsMessage.propertyExists("mdconid")) {
            this._md_connid = tibjmsMessage.getLongProperty("mdconid");
            this._md_link.setLinkId("MDaemon-" + this._md_connid);
            this._md_link.setType(1);
        }
        if (this._md_connid == 0L) {
            throw new JMSException("Invalid server response, no connection id");
        }
        return tibjmsMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _reconnectMD() {
        this._resetServerHeartbeats();
        if (this._md_urls.size() <= 1) {
            return false;
        }
        if (Tibjmsx.ftDelay > 0) {
            System.err.println("[Tibjms]: waiting " + Tibjmsx.ftDelay + " milliseconds before reconnecting via FT.");
            try {
                Thread.sleep(Tibjmsx.ftDelay);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return false;
            }
            System.err.println("[Tibjms]: proceeding with FT reconnect.");
        }
        TibjmsMessage tibjmsMessage = null;
        TibjmsxURL tibjmsxURL = null;
        int n = this._md_urlIndex;
        block11: for (int j = 0; j < this._reconnect_attempt_count; ++j) {
            Serializable serializable;
            try {
                serializable = new Random(System.currentTimeMillis() + this._connid);
                Thread.sleep((long)this._reconnect_attempt_delay + (long)(serializable.nextDouble() * 100.0));
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return false;
            }
            this._md_urlIndex = n + 1;
            while (true) {
                if (this._md_urlIndex >= this._md_urls.size()) {
                    this._md_urlIndex = 0;
                }
                tibjmsxURL = (TibjmsxURL)this._md_urls.elementAt(this._md_urlIndex);
                if (this._reconnectAttemptTimeout > 0) {
                    this._startMdConnectTimeoutThread(this._reconnectAttemptTimeout);
                }
                if (!this._md_link.reconnect(tibjmsxURL)) {
                    this._notifyMdConnectTimeoutThread(true, false);
                } else {
                    try {
                        tibjmsMessage = this._doInitMsgMd(false);
                        if (tibjmsMessage != null && tibjmsMessage._type == 10) {
                            this._notifyMdConnectTimeoutThread(false, true);
                            this._md_link.setPing(this._pingInterval);
                            try {
                                this._invokeMulticastExceptionListener("Temporarily lost connection with the Multicast Daemon but reconnected.");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this._md_link.pushRequests((byte)4);
                            this._createChecker();
                            this._md_closed = false;
                            serializable = this._connectionRequests;
                            synchronized (serializable) {
                                this._md_closing = false;
                            }
                            return true;
                        }
                        this._notifyMdConnectTimeoutThread(true, false);
                        this._md_link.disconnect();
                    }
                    catch (JMSException jMSException) {
                        this._notifyMdConnectTimeoutThread(true, false);
                    }
                }
                if (this._md_urlIndex == n) continue block11;
                ++this._md_urlIndex;
            }
        }
        this._notifyMdConnectTimeoutThread(true, false);
        return false;
    }

    private void _startMdConnectTimeoutThread(int n) {
        if (this._md_connectTimeoutThread == null) {
            this._md_connectTimeoutThread = new ConnectTimeoutThread(n, this._md_link);
        }
        try {
            this._md_connectTimeoutThread.start();
        }
        catch (Exception exception) {
            return;
        }
    }

    private void _notifyMdConnectTimeoutThread(boolean bl, boolean bl2) {
        if (this._md_connectTimeoutThread != null) {
            this._md_connectTimeoutThread._notify(bl, bl2);
            this._md_connectTimeoutThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _startMd() throws JMSException {
        TibjmsxLink tibjmsxLink;
        int n = -1;
        Object object = this._md_lock;
        synchronized (object) {
            if (this._md_link == null) {
                return;
            }
            if (this._md_started && !this._md_closed && !this._md_closing) {
                return;
            }
        }
        object = this._connectionRequests;
        synchronized (object) {
            if (this._md_closing) {
                throw new IllegalStateException("Multicast Daemon Connection is being closed");
            }
            n = Tibjmsx.getResponseID();
            this._connectionRequests.put(new Integer(n), null);
        }
        object = this._md_lock;
        synchronized (object) {
            if (this._md_started || this._md_stopping) {
                this._removeConnectionRequests(n);
                return;
            }
            if (this._md_closed) {
                this._removeConnectionRequests(n);
                throw new IllegalStateException("Multicast Daemon Connection is closed");
            }
            if (this._md_started) {
                this._removeConnectionRequests(n);
                return;
            }
            tibjmsxLink = this._md_link;
        }
        object = new TibjmsMessage(112, n, this._requestPriority);
        ((TibjmsMessage)object).setLongProperty("conid", this._connid);
        ((TibjmsMessage)object).setLongProperty("mdconid", this._md_connid);
        TibjmsMessage tibjmsMessage = tibjmsxLink.sendRequestMsg((TibjmsMessage)object, this._requestTimeout, new StartCBMd());
        this._removeConnectionRequests(n);
        if (tibjmsMessage == null || tibjmsMessage._type != 10) {
            throw Tibjmsx.buildException(tibjmsMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _stopMd() throws JMSException {
        int n = -1;
        TibjmsxLink tibjmsxLink = null;
        Object object = this._md_lock;
        synchronized (object) {
            if (this._md_link == null) {
                return;
            }
            if (!(this._md_started || this._md_closed || this._md_closing)) {
                return;
            }
        }
        object = this._connectionRequests;
        synchronized (object) {
            if (this._md_closing) {
                throw new IllegalStateException("Multicast Daemon Connection is being closed");
            }
            n = Tibjmsx.getResponseID();
            this._connectionRequests.put(new Integer(n), null);
        }
        object = this._md_lock;
        synchronized (object) {
            if (this._md_closed) {
                this._removeConnectionRequests(n);
                throw new IllegalStateException("Multicast Daemon Connection is closed");
            }
            if (!this._md_started) {
                this._removeConnectionRequests(n);
                return;
            }
            this._md_stopping = true;
            tibjmsxLink = this._md_link;
        }
        object = new TibjmsMessage(113, n, this._requestPriority);
        ((TibjmsMessage)object).setLongProperty("conid", this._connid);
        ((TibjmsMessage)object).setLongProperty("mdconid", this._md_connid);
        TibjmsMessage tibjmsMessage = tibjmsxLink.sendRequestMsg((TibjmsMessage)object, this._requestTimeout);
        this._removeConnectionRequests(n);
        if (tibjmsMessage == null || tibjmsMessage._type != 10) {
            throw Tibjmsx.buildException(tibjmsMessage);
        }
        Object object2 = this._md_lock;
        synchronized (object2) {
            this._md_started = false;
            this._md_stopping = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setMulticastConsumerFlags(boolean bl) {
        HashMap hashMap = this._consumers;
        synchronized (hashMap) {
            for (TibjmsMessageConsumer tibjmsMessageConsumer : this._consumers.values()) {
                if (!tibjmsMessageConsumer._createdAsMulticast) continue;
                tibjmsMessageConsumer._isMulticast = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector _getAllMulticastConsumers() {
        HashMap hashMap = this._consumers;
        synchronized (hashMap) {
            Vector<TibjmsMessageConsumer> vector = new Vector<TibjmsMessageConsumer>();
            for (TibjmsMessageConsumer tibjmsMessageConsumer : this._consumers.values()) {
                if (!tibjmsMessageConsumer._isMulticast) continue;
                vector.addElement(tibjmsMessageConsumer);
            }
            return vector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _hasMulticastConsumers() {
        HashMap hashMap = this._consumers;
        synchronized (hashMap) {
            for (TibjmsMessageConsumer tibjmsMessageConsumer : this._consumers.values()) {
                if (!tibjmsMessageConsumer._isMulticast) continue;
                return true;
            }
            return false;
        }
    }

    private void _reinitializeMulticastConsumers() {
        this._disconnectFromMulticastDaemon(false);
        Vector vector = this._getAllSessions();
        for (int j = 0; j < vector.size(); ++j) {
            TibjmsxSessionImp tibjmsxSessionImp = (TibjmsxSessionImp)vector.elementAt(j);
            tibjmsxSessionImp._reinitializeMulticastConsumers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _closeMd(boolean bl, boolean bl2) throws JMSException {
        Vector vector = null;
        TibjmsxLink tibjmsxLink = null;
        Object object = this._md_lock;
        synchronized (object) {
            if (this._md_link == null || this._md_closed) {
                return;
            }
            this._md_closed = true;
            if (!bl) {
                this._closedReason = 1;
            } else {
                this._md_link.pushRequests((byte)2);
            }
            if (bl2) {
                vector = this._getAllMulticastConsumers();
            }
            this._md_started = false;
        }
        if (vector != null) {
            for (int j = 0; j < vector.size(); ++j) {
                TibjmsMessageConsumer tibjmsMessageConsumer = (TibjmsMessageConsumer)vector.elementAt(j);
                if (bl) {
                    tibjmsMessageConsumer._getSession()._sendServerMulticastStatus(tibjmsMessageConsumer, 11, "Multicast Daemon disconnected.");
                }
                tibjmsMessageConsumer.close();
            }
        }
        Object object2 = this._md_lock;
        synchronized (object2) {
            if (!bl) {
                tibjmsxLink = this._md_link;
                this._md_link = null;
            }
            this._md_started = false;
        }
        if (tibjmsxLink != null) {
            tibjmsxLink.setClosing();
            object2 = new TibjmsMessage(111);
            ((TibjmsMessage)object2).setLongProperty("conid", this._connid);
            ((TibjmsMessage)object2).setLongProperty("mdconid", this._md_connid);
            try {
                tibjmsxLink.send(object2, 2);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            tibjmsxLink.disconnect();
            tibjmsxLink.pushRequests((byte)2);
        }
    }

    void _invokeMulticastExceptionListener(long l, String string) {
        TibjmsMulticastExceptionListener tibjmsMulticastExceptionListener = Tibjmsx.mcExListener;
        if (tibjmsMulticastExceptionListener != null) {
            JMSException jMSException = Tibjmsx.buildException("EMS Multicast Exception: " + string, null, null);
            TibjmsMessageConsumer tibjmsMessageConsumer = this._getConsumer(l);
            if (tibjmsMessageConsumer != null && !tibjmsMessageConsumer._isClosed()) {
                tibjmsMulticastExceptionListener.onMulticastException(this, tibjmsMessageConsumer._getSession(), tibjmsMessageConsumer, jMSException);
            }
        }
    }

    void _invokeMulticastExceptionListener(String string) {
        TibjmsMulticastExceptionListener tibjmsMulticastExceptionListener = Tibjmsx.mcExListener;
        if (tibjmsMulticastExceptionListener != null) {
            JMSException jMSException = Tibjmsx.buildException("EMS Multicast Exception: " + string, null, null);
            Vector vector = this._getAllMulticastConsumers();
            if (vector != null) {
                for (int j = 0; j < vector.size(); ++j) {
                    TibjmsMessageConsumer tibjmsMessageConsumer = (TibjmsMessageConsumer)vector.elementAt(j);
                    if (tibjmsMessageConsumer._isClosed()) continue;
                    tibjmsMulticastExceptionListener.onMulticastException(this, tibjmsMessageConsumer._getSession(), tibjmsMessageConsumer, jMSException);
                }
            }
        }
    }

    void _processMulticastStatus(TibjmsMessage tibjmsMessage) throws JMSException {
        this._traceMulticastStatus(tibjmsMessage);
        try {
            tibjmsMessage._type = 123;
            tibjmsMessage._liftBody();
            tibjmsMessage._liftProperties();
            this._link.send(tibjmsMessage, 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (tibjmsMessage.propertyExists("clex")) {
                this._invokeMulticastExceptionListener(tibjmsMessage.getLongProperty("consid"), tibjmsMessage.getStringProperty("desc"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void _traceMulticastStatus(TibjmsMessage tibjmsMessage) throws JMSException {
        if (this._traceTarget == 0) {
            return;
        }
        try {
            long l = tibjmsMessage.getLongProperty("consid");
            long l2 = tibjmsMessage.getLongProperty("sessid");
            int n = tibjmsMessage.getIntProperty("err");
            String string = tibjmsMessage.getStringProperty("desc");
            int n2 = tibjmsMessage.getIntProperty("nmc");
            TibjmsxTrace.write(this._traceTarget, "Multicast status consid={0,number,###0.##} sessid={1,number,###0.##} error={2,number,###0.##} desc={3}", new Object[]{new Long(l), new Long(l2), new Integer(n), string});
            for (int j = 1; j <= n2; ++j) {
                byte[] byArray = tibjmsMessage._getBytesProperty("mcs" + j);
                TibjmsMapMessage tibjmsMapMessage = (TibjmsMapMessage)TibjmsMessage.createFromBytes(byArray);
                this._traceMulticastChannelStatus(tibjmsMapMessage);
            }
        }
        catch (JMSException jMSException) {
            throw new JMSException("Invalid multicast status message: " + jMSException.getMessage());
        }
    }

    void _traceMulticastChannelStatus(TibjmsMapMessage tibjmsMapMessage) throws JMSException {
        try {
            String string = tibjmsMapMessage.getString("name");
            int n = tibjmsMapMessage.getInt("err");
            String string2 = tibjmsMapMessage.getString("desc");
            if (this._traceTarget != 0) {
                TibjmsxTrace.write(this._traceTarget, "Multicast channel status name={0} error={1,number,###0.##} desc={2}", new Object[]{string, new Integer(n), string2});
            }
        }
        catch (JMSException jMSException) {
            throw new JMSException("Invalid multicast channel status message: " + jMSException.getMessage());
        }
    }

    void _processMDaemonStats(TibjmsMessage tibjmsMessage) throws JMSException {
        tibjmsMessage._liftBody();
        tibjmsMessage._liftProperties();
        try {
            this._link.send(tibjmsMessage, 2);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _isConnectedToMulticastDaemon() {
        Object object = this._md_lock;
        synchronized (object) {
            if (this._md_link != null) {
                return this._md_link.isConnected();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _connectToMulicastDaemon(String string) throws JMSException {
        Object object = this._md_lock;
        synchronized (object) {
            if (!this._isConnectedToMulticastDaemon()) {
                this._createMdLink(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _disconnectFromMulticastDaemon(boolean bl) {
        try {
            if (this._isConnectedToMulticastDaemon()) {
                this._closeMd(false, bl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this._md_lock;
        synchronized (object) {
            this._md_refs = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _retainMulticastDaemonConnection() {
        Object object = this._md_lock;
        synchronized (object) {
            if (this._md_link != null) {
                ++this._md_refs;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _releaseMulticastDaemonConnection() {
        boolean bl = false;
        Object object = this._md_lock;
        synchronized (object) {
            if (this._md_link != null) {
                if (this._md_refs > 0) {
                    --this._md_refs;
                }
                if (this._md_refs == 0) {
                    bl = true;
                }
            }
        }
        if (bl) {
            this._disconnectFromMulticastDaemon(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _shouldReconnectMDaemon() {
        Object object = this._md_lock;
        synchronized (object) {
            if (this._md_urls == null) {
                return false;
            }
            if (this._md_urls.size() <= 1) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _pushConnectionRequestsMd() {
        HashMap hashMap = this._connectionRequests;
        synchronized (hashMap) {
            this._md_closing = true;
            this._md_link.pushConnectionRequests((byte)8, this._connectionRequests);
        }
    }

    void _onDisconnectedMd(Exception exception) {
        this._pushConnectionRequestsMd();
        try {
            if (this._traceTarget != 0) {
                TibjmsxTrace.write(this._traceTarget, "before multicast exception callback conn={0,number,###0.##} status={1}", new Object[]{new Long(this._connid), "Disconnected"});
            }
            this._invokeMulticastExceptionListener(this._getTerminatedText());
            if (this._traceTarget != 0) {
                TibjmsxTrace.write(this._traceTarget, "after multicast exception callback conn={0,number,###0.##} status={1}", new Object[]{new Long(this._connid), "Reconnected"});
            }
            this._closeMd(true, true);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    TibjmsConnection(TibjmsxCFImpl tibjmsxCFImpl, String string, String string2, String string3, String string4, Map map) throws JMSException {
        this._create(tibjmsxCFImpl, string, string2, string3, string4, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _destroyTempDest(TibjmsDestination tibjmsDestination) throws JMSException {
        String string = tibjmsDestination.getAddress();
        long l = 0L;
        this._removeTempDest(tibjmsDestination);
        Object object = this._lock;
        synchronized (object) {
            int n;
            if (this._closed) {
                return true;
            }
            if (tibjmsDestination instanceof TibjmsTemporaryDestination) {
                n = ((TibjmsTemporaryDestination)((Object)tibjmsDestination))._getRefCount();
                if (n != 0) {
                    throw new IllegalStateException("Attempt to delete temporary destination which has receivers");
                }
                if (tibjmsDestination instanceof TibjmsTemporaryTopic) {
                    l = ((TibjmsTemporaryTopic)tibjmsDestination)._sessid;
                } else if (tibjmsDestination instanceof TibjmsTemporaryQueue) {
                    l = ((TibjmsTemporaryQueue)tibjmsDestination)._sessid;
                } else {
                    throw new InvalidDestinationException("not a temporary destination");
                }
            }
            n = tibjmsDestination instanceof Topic ? 2 : 1;
            TibjmsMessage tibjmsMessage = new TibjmsMessage(35, Tibjmsx.getResponseID(), 9);
            tibjmsMessage.setLongProperty("sessid", l);
            tibjmsMessage.setLongProperty("conid", this._connid);
            tibjmsMessage.setStringProperty("dest", string);
            tibjmsMessage.setIntProperty("dtype", n);
            this._link.send(tibjmsMessage, 2);
            if (this._traceTarget != 0) {
                TibjmsxTrace.write(this._traceTarget, "Delete Temporary{0} conn={1,number,###0.##} dest={2}", new Object[]{n == 1 ? "Queue" : "Topic", new Long(this._connid), string});
            }
            return true;
        }
    }

    String getActiveURL() {
        if (this._urls == null || this._urls.size() == 0 || this._closed || this._urlIndex < 0 || this._urlIndex >= this._urls.size()) {
            return null;
        }
        return ((TibjmsxURL)this._urls.elementAt(this._urlIndex)).getURL();
    }

    private String _getTypeStr() {
        String string = "";
        string = this instanceof XATopicConnection ? string + "XATopic" : (this instanceof XAQueueConnection ? string + "XAQueue" : (this instanceof XAConnection ? string + "XA" : (this instanceof TopicConnection ? string + "Topic" : (this instanceof QueueConnection ? string + "Queue" : ""))));
        return string;
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        ConnectionConsumer connectionConsumer = this._createConnectionConsumer(destination, null, false, false, string, serverSessionPool, n);
        return connectionConsumer;
    }

    @Override
    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        ConnectionConsumer connectionConsumer = this._createConnectionConsumer(topic, string, true, false, string2, serverSessionPool, n);
        return connectionConsumer;
    }

    @Override
    public String getClientID() throws JMSException {
        if (this._closed) {
            throw new IllegalStateException("Connection closed");
        }
        return this._clientID;
    }

    @Override
    public void setClientID(String string) throws JMSException {
        this._setClientIDEx(string, false, false);
    }

    protected void setClientIDFromContext(String string, boolean bl) throws JMSException {
        this._setClientIDEx(string, true, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setClientIDEx(String string, boolean bl, boolean bl2) throws JMSException {
        if (string == null) {
            throw new IllegalArgumentException("null clientID not allowed");
        }
        int n = -1;
        Object object = this._connectionRequests;
        synchronized (object) {
            if (this._closing) {
                throw new IllegalStateException("Connection is being closed");
            }
            n = Tibjmsx.getResponseID();
            this._connectionRequests.put(new Integer(n), null);
        }
        object = this._lock;
        synchronized (object) {
            if (this._closed) {
                this._removeConnectionRequests(n);
                throw new IllegalStateException("Connection closed");
            }
            if (!this._canChangeID && this._clientID != null || !bl && !this._clear || bl && !bl2) {
                this._removeConnectionRequests(n);
                throw new IllegalStateException("Can not change client ID");
            }
            TibjmsMessage tibjmsMessage = new TibjmsMessage(37);
            tibjmsMessage._responseID = n;
            tibjmsMessage._JMSPriority = this._requestPriority;
            tibjmsMessage.setStringProperty("clid", string);
            TibjmsMessage tibjmsMessage2 = this._link.sendRequestMsg(tibjmsMessage, this._requestTimeout);
            this._removeConnectionRequests(n);
            if (tibjmsMessage2 == null || tibjmsMessage2._type != 10) {
                throw Tibjmsx.buildException(tibjmsMessage2);
            }
            this._clear = false;
            this._canChangeID = false;
            this._clientID = string;
        }
        if (this._traceTarget != 0) {
            TibjmsxTrace.write(this._traceTarget, "{0}Connection Set clientID={1} conn={2,number,###0.##}", new Object[]{this._getTypeStr(), string, new Long(this._connid)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionMetaData getMetaData() throws JMSException {
        Object object = this._lock;
        synchronized (object) {
            if (this._closed) {
                throw new IllegalStateException("Connection closed");
            }
            return this._metaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExceptionListener getExceptionListener() throws JMSException {
        Object object = this._lock;
        synchronized (object) {
            if (this._closed) {
                throw new IllegalStateException("Connection closed");
            }
            return this._exceptionListener;
        }
    }

    @Override
    public Session createSession(boolean bl, int n) throws JMSException {
        TibjmsxSessionImp tibjmsxSessionImp = this._createSession(0, bl, n);
        if (tibjmsxSessionImp == null) {
            throw new JMSException("Failed to create session");
        }
        return tibjmsxSessionImp;
    }

    @Override
    public Session createSession() throws JMSException {
        TibjmsxSessionImp tibjmsxSessionImp = this._createSession(0, false, 1);
        if (tibjmsxSessionImp == null) {
            throw new JMSException("Failed to create session");
        }
        return tibjmsxSessionImp;
    }

    @Override
    public Session createSession(int n) throws JMSException {
        TibjmsxSessionImp tibjmsxSessionImp = this._createSession(0, n == 0, n);
        if (tibjmsxSessionImp == null) {
            throw new JMSException("Failed to create session");
        }
        return tibjmsxSessionImp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        Object object = this._lock;
        synchronized (object) {
            if (this._closed) {
                throw new IllegalStateException("Connection closed");
            }
            if (this._traceTarget != 0) {
                TibjmsxTrace.write(this._traceTarget, "Connection SetExceptionListener conn={0,number,###0.##} Listener={1}", new Object[]{new Long(this._connid), exceptionListener != null ? "{set}" : "{not set}"});
            }
            this._clear = false;
            this._exceptionListener = exceptionListener;
        }
    }

    @Override
    public void start() throws JMSException {
        if (this._traceTarget != 0) {
            TibjmsxTrace.write(this._traceTarget, "{0}Connection Start conn={1,number,###0.##}", new Object[]{this._getTypeStr(), new Long(this._connid)});
        }
        this._start();
    }

    @Override
    public void stop() throws JMSException {
        this._checkLegalAPIUse(1);
        if (this._traceTarget != 0) {
            TibjmsxTrace.write(this._traceTarget, "{0}Connection Stop conn={1,number,###0.##}", new Object[]{this._getTypeStr(), new Long(this._connid)});
        }
        this._stop();
    }

    @Override
    public void close() throws JMSException {
        this._checkLegalAPIUse(0);
        if (this._traceTarget != 0) {
            TibjmsxTrace.write(this._traceTarget, "{0}Connection Close conn={1,number,###0.##}", new Object[]{this._getTypeStr(), new Long(this._connid)});
        }
        this._disconnectFromMulticastDaemon(true);
        this._close(false);
    }

    public boolean isDisconnected() {
        return this._closed || this._closing || this._link.isClosed();
    }

    public String toString() {
        String string = "";
        try {
            TibjmsxURL tibjmsxURL;
            string = string + this._getTypeStr() + "Connection";
            string = string + "[ClientId=" + this._clientID + ", ";
            if (!this._closed && this._urlIndex >= 0 && this._urlIndex < this._urls.size()) {
                tibjmsxURL = (TibjmsxURL)this._urls.elementAt(this._urlIndex);
                string = string + "Connected=" + tibjmsxURL.url;
            } else {
                string = string + "Closed";
            }
            if (this._urls != null && this._urls.size() > 0) {
                string = string + ", URL=";
                for (int j = 0; j < this._urls.size(); ++j) {
                    if (j > 0) {
                        string = string + ",";
                    }
                    tibjmsxURL = (TibjmsxURL)this._urls.elementAt(j);
                    string = string + tibjmsxURL.url;
                }
            }
            string = string + "]";
        }
        catch (Exception exception) {
            return "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setMulticastDaemon(String string) throws JMSException {
        String string2 = string;
        if (string.indexOf(44) < 0) {
            string2 = string.trim() + "," + string.trim();
        }
        Object object = this._md_lock;
        synchronized (object) {
            this._md_urls = TibjmsxURL.parseMultiple(string2);
            if (this._md_urls == null) {
                if (string != null && string.length() > 0) {
                    throw new JMSException("Invalid Multicast Daemon port specification: " + string);
                }
                this._md_urls = new Vector();
                this._md_urls.addElement(TibjmsxURL.parse("tcp://localhost:7444,tcp://localhost:7444"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _updateDurable(String string, Vector vector) {
        boolean bl = false;
        if (vector == null) {
            return;
        }
        if (vector.isEmpty()) {
            return;
        }
        Object object = this._durablesLock;
        synchronized (object) {
            Vector vector2;
            if (this._durables.containsKey(string)) {
                vector2 = (Vector)this._durables.get(string);
            } else {
                vector2 = new Vector();
                this._durables.put(string, vector2);
                bl = true;
            }
            for (TibjmsxMsgId tibjmsxMsgId : vector) {
                if (!bl && vector2.contains(tibjmsxMsgId)) continue;
                vector2.add(tibjmsxMsgId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List _getDurableMids(String string) {
        Vector<TibjmsxMsgId> vector = null;
        Object object = this._durablesLock;
        synchronized (object) {
            List list = (List)this._durables.get(string);
            if (list != null) {
                vector = new Vector<TibjmsxMsgId>(list.size());
                for (TibjmsxMsgId tibjmsxMsgId : list) {
                    vector.add(new TibjmsxMsgId(tibjmsxMsgId.consumerID, tibjmsxMsgId.sequenceID, tibjmsxMsgId.cmid, tibjmsxMsgId.needAck));
                }
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _loadDurable(TibjmsMessageConsumer tibjmsMessageConsumer, String string, Vector vector) {
        if (string == null) {
            return;
        }
        Object object = this._durablesLock;
        synchronized (object) {
            List list = this._getDurableMids(string);
            if (list == null) {
                return;
            }
            if (list.isEmpty()) {
                return;
            }
            for (TibjmsxMsgId tibjmsxMsgId : list) {
                tibjmsxMsgId.consumerID = tibjmsMessageConsumer._consid;
                if (vector.contains(tibjmsxMsgId)) continue;
                vector.add(tibjmsxMsgId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _removeDurable(String string) {
        if (string == null) {
            return;
        }
        Object object = this._durablesLock;
        synchronized (object) {
            this._durables.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearDurableMids(String string, Iterator iterator2) {
        Object object = this._durablesLock;
        synchronized (object) {
            List list = (List)this._durables.get(string);
            if (list == null) {
                return;
            }
            while (iterator2.hasNext()) {
                TibjmsxMsgId tibjmsxMsgId = (TibjmsxMsgId)iterator2.next();
                list.remove(tibjmsxMsgId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _updateAllSentLists(String string) {
        List list = this._getDurableMids(string);
        if (list == null) {
            return;
        }
        for (TibjmsxMsgId tibjmsxMsgId : list) {
            HashMap hashMap = this._sessions;
            synchronized (hashMap) {
                for (TibjmsxSessionImp tibjmsxSessionImp : this._sessions.values()) {
                    tibjmsxSessionImp.removeMidFromDelivered(tibjmsxMsgId);
                }
            }
        }
        list.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _emptyDurable(String string) {
        Object object = this._durablesLock;
        synchronized (object) {
            List list = (List)this._durables.get(string);
            if (list != null) {
                list.clear();
            }
        }
    }

    void _clearDurable(String string, HashMap hashMap) {
        if (hashMap == null) {
            return;
        }
        Iterator iterator2 = hashMap.values().iterator();
        this._clearDurableMids(string, iterator2);
    }

    void _clearDurable(String string, LinkedList linkedList) {
        if (linkedList == null) {
            return;
        }
        Iterator iterator2 = linkedList.iterator();
        this._clearDurableMids(string, iterator2);
    }

    class StartCBMd
    implements TibjmsxResponseCallback {
        StartCBMd() {
        }

        @Override
        public void onResponse(TibjmsMessage tibjmsMessage) {
            if (tibjmsMessage != null && tibjmsMessage._type == 10) {
                TibjmsConnection.this._md_started = true;
            }
        }
    }

    class StartCB
    implements TibjmsxResponseCallback {
        StartCB() {
        }

        @Override
        public void onResponse(TibjmsMessage tibjmsMessage) {
            if (tibjmsMessage != null && tibjmsMessage._type == 10) {
                TibjmsConnection.this._started = true;
            }
        }
    }

    class ConnectTimeoutThread
    extends Thread {
        Object _connectTimeoutLock = new Object();
        boolean _connectComplete = false;
        boolean _connectFailure = false;
        boolean _ignoreFailure = false;
        boolean _stopped = false;
        JMSException exceptionCausedByTimeoutThread = null;
        int _timeout = 0;
        TibjmsxLink _locallink = null;

        ConnectTimeoutThread(int n, TibjmsxLink tibjmsxLink) {
            this._timeout = n;
            this._locallink = tibjmsxLink;
            this.setName("Connect Timeout Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l = 0L;
            long l2 = 0L;
            Object object = this._connectTimeoutLock;
            synchronized (object) {
                while (!this._stopped) {
                    l = (long)this._timeout + System.currentTimeMillis();
                    try {
                        while (!(this._connectComplete || this._connectFailure || this._stopped || (l2 = l - System.currentTimeMillis()) < 1L)) {
                            this._connectTimeoutLock.wait(l2);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this._locallink.isConnected() && (this._connectComplete || this._ignoreFailure)) continue;
                    if (!this._connectComplete) {
                        this.exceptionCausedByTimeoutThread = new JMSException("Failed to initialize connection before timeout");
                    }
                    try {
                        this._locallink.closeSocket();
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void _notify(boolean bl, boolean bl2) {
            Object object = this._connectTimeoutLock;
            synchronized (object) {
                this._connectComplete = bl2;
                this._ignoreFailure = bl;
                boolean bl3 = this._connectFailure = !bl2;
                if (this._connectFailure) {
                    this.exceptionCausedByTimeoutThread = null;
                }
                this._connectTimeoutLock.notify();
                this._stop();
            }
        }

        void _stop() {
            this._stopped = true;
            try {
                this.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        JMSException _getExceptionByTimeoutThread() {
            return this.exceptionCausedByTimeoutThread;
        }
    }

    class DOT
    implements Runnable {
        Thread _t = new Thread(this);
        boolean _nodups = false;
        boolean _stopped = false;

        public DOT() {
            try {
                this._t.setDaemon(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this._t.setName("TIBCO EMS DUPS_OK Sender");
            this._t.start();
        }

        void stop() {
            this._stopped = true;
            this._t.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            block8: while (true) {
                try {
                    while (true) {
                        Object object = _dupsNotifier;
                        synchronized (object) {
                            _haveDups = false;
                        }
                        bl = TibjmsConnection.this._processAcks();
                        if (this._stopped) break block8;
                        if (bl) {
                            this._nodups = false;
                        }
                        if (!bl && this._nodups) {
                            object = _dupsNotifier;
                            synchronized (object) {
                                if (!_haveDups) {
                                    _dupsNotifier.wait();
                                    if (this._stopped) {
                                        break block8;
                                    }
                                    this._nodups = false;
                                    continue;
                                }
                            }
                        }
                        if (!bl) {
                            this._nodups = true;
                        }
                        Thread.sleep(TibjmsConnection.this._DUPS_OK_INTERVAL);
                        if (this._stopped) break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!this._stopped) continue;
                    Thread.currentThread().interrupt();
                }
                break;
            }
        }
    }

    static class Checker
    implements Runnable {
        Thread _t = new Thread(this);

        Checker() {
            try {
                this._t.setDaemon(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this._t.setName("TIBCO EMS Connections Checker");
            this._t.start();
        }

        @Override
        public void run() {
            try {
                do {
                    Thread.sleep(1000L);
                } while (this._checkConnections());
            }
            catch (InterruptedException interruptedException) {}
        }

        private boolean _linkTimedOut(TibjmsxLink tibjmsxLink, long l) {
            if (tibjmsxLink == null) {
                return false;
            }
            if (tibjmsxLink._state != 1) {
                return false;
            }
            long l2 = System.currentTimeMillis();
            long l3 = l2 - tibjmsxLink._lastActiveTime;
            return l3 >= l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean _checkConnections() {
            Object[] objectArray = null;
            ArrayList arrayList = _connections;
            synchronized (arrayList) {
                if (_connections.size() == 0) {
                    Object object = _checkerLock;
                    synchronized (object) {
                        _checker = null;
                        return false;
                    }
                }
                objectArray = _connections.toArray();
            }
            for (int j = 0; j < objectArray.length; ++j) {
                boolean bl = false;
                TibjmsConnection tibjmsConnection = (TibjmsConnection)objectArray[j];
                if (tibjmsConnection == null || tibjmsConnection._serverHeartbeatClient <= 0 || tibjmsConnection._clientTimeoutServer <= 0) continue;
                TibjmsxLink tibjmsxLink = tibjmsConnection._link;
                TibjmsxLink tibjmsxLink2 = tibjmsConnection._md_link;
                long l = (long)tibjmsConnection._clientTimeoutServer * 1000L;
                if (this._linkTimedOut(tibjmsxLink, l)) {
                    tibjmsConnection._timedout = true;
                    tibjmsConnection._closedReason = 3;
                    if (tibjmsxLink != null) {
                        tibjmsxLink.closeSocket();
                    }
                    bl = true;
                }
                if (!bl && !this._linkTimedOut(tibjmsxLink2, l) || tibjmsxLink2 == null) continue;
                tibjmsxLink2.closeSocket();
            }
            return true;
        }
    }

    private class MDaemonReinitializationThread
    implements Runnable {
        Thread _t = new Thread(this);

        MDaemonReinitializationThread() {
            try {
                this._t.setDaemon(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this._t.setName("TIBCO EMS Multicast Reinitialization Thread");
            this._t.start();
        }

        @Override
        public void run() {
            TibjmsConnection.this._reinitializeMulticastConsumers();
        }
    }

    private class ServerLinkEventHandler
    implements TibjmsxLink.LinkEventHandler {
        TibjmsConnection _connection;

        private ServerLinkEventHandler() {
        }

        protected ServerLinkEventHandler(TibjmsConnection tibjmsConnection2) {
            this._connection = tibjmsConnection2;
        }

        @Override
        public String getTerminatedText() {
            return this._connection._getTerminatedText();
        }

        @Override
        public void onEventDisconnected(Exception exception, boolean bl) {
            if (bl) {
                this._connection._pushConnectionRequests();
            } else {
                try {
                    TibjmsConnection.this._closeMd(false, true);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this._connection._onDisconnected(exception);
            }
        }

        @Override
        public void onEventProcessMessage(byte[] byArray) throws EOFException, JMSException {
            this._connection._processMessage(this._connection._link, byArray);
        }

        @Override
        public boolean onEventReconnect() {
            try {
                TibjmsConnection.this._closeMd(false, false);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            boolean bl = this._connection._reconnect();
            if (bl && TibjmsConnection.this._multicastEnabled && this._connection._serverMcastEnabled && this._connection._hasMulticastConsumers()) {
                MDaemonReinitializationThread mDaemonReinitializationThread = new MDaemonReinitializationThread();
            }
            return bl;
        }
    }

    private class MDaemonLinkEventHandler
    implements TibjmsxLink.LinkEventHandler {
        TibjmsConnection _connection = null;

        private MDaemonLinkEventHandler() {
        }

        protected MDaemonLinkEventHandler(TibjmsConnection tibjmsConnection2) {
            this._connection = tibjmsConnection2;
        }

        @Override
        public void onEventDisconnected(Exception exception, boolean bl) {
            if (bl) {
                return;
            }
            this._connection._onDisconnectedMd(exception);
        }

        @Override
        public void onEventProcessMessage(byte[] byArray) throws EOFException, JMSException {
            this._connection._processMessage(this._connection._md_link, byArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onEventReconnect() {
            boolean bl = false;
            Object object = TibjmsConnection.this._md_lock;
            synchronized (object) {
                if (TibjmsConnection.this._md_link != null) {
                    bl = this._connection._reconnectMD();
                }
                if (bl) {
                    try {
                        MDaemonReinitializationThread mDaemonReinitializationThread = new MDaemonReinitializationThread();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return bl;
        }

        @Override
        public String getTerminatedText() {
            return this._connection._getTerminatedText();
        }
    }
}

