/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsBlockingCompletionEvent;
import com.tibco.tibjms.TibjmsCompletionEvent;
import com.tibco.tibjms.TibjmsMessageProducer;
import com.tibco.tibjms.TibjmsSendCompletionEvent;
import com.tibco.tibjms.TibjmsSendWithResponseCompletionEvent;
import com.tibco.tibjms.Tibjmsx;
import java.util.LinkedList;
import javax.jms.CompletionListener;
import javax.jms.Message;

class TibjmsCompletionEventProcessor {
    private LinkedList<TibjmsCompletionEvent> _q = new LinkedList();
    private Object _lock = new Object();
    private boolean _closed = false;
    CompletionEventThread _dispatcher = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDone() {
        Object object = this._lock;
        synchronized (object) {
            return this._closed && this._q.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(TibjmsCompletionEvent tibjmsCompletionEvent) {
        Object object = this._lock;
        synchronized (object) {
            boolean bl = this._q.size() == 0;
            this._q.addLast(tibjmsCompletionEvent);
            if (bl) {
                this._lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEmpty() {
        Object object = this._lock;
        synchronized (object) {
            return this._q.size() == 0;
        }
    }

    TibjmsCompletionEventProcessor(TibjmsMessageProducer tibjmsMessageProducer) {
        this._dispatcher = new CompletionEventThread(this, tibjmsMessageProducer);
    }

    TibjmsSendWithResponseCompletionEvent registerServerResponse(CompletionListener completionListener, Message message) {
        TibjmsSendWithResponseCompletionEvent tibjmsSendWithResponseCompletionEvent = new TibjmsSendWithResponseCompletionEvent(completionListener, message);
        this.add(tibjmsSendWithResponseCompletionEvent);
        return tibjmsSendWithResponseCompletionEvent;
    }

    void registerImmediate(CompletionListener completionListener, Message message) {
        TibjmsSendCompletionEvent tibjmsSendCompletionEvent = new TibjmsSendCompletionEvent(completionListener, message);
        this.add(tibjmsSendCompletionEvent);
    }

    TibjmsBlockingCompletionEvent addBlockingEvent() {
        if (this.isEmpty()) {
            return null;
        }
        TibjmsBlockingCompletionEvent tibjmsBlockingCompletionEvent = new TibjmsBlockingCompletionEvent();
        this.add(tibjmsBlockingCompletionEvent);
        return tibjmsBlockingCompletionEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatch() {
        TibjmsCompletionEvent tibjmsCompletionEvent = null;
        Object object = this._lock;
        synchronized (object) {
            while (this._q.size() == 0) {
                if (this._closed) {
                    return;
                }
                try {
                    this._lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    this._closed = true;
                }
            }
            tibjmsCompletionEvent = this._q.getFirst();
        }
        tibjmsCompletionEvent.process();
        object = this._lock;
        synchronized (object) {
            this._q.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this._lock;
        synchronized (object) {
            if (this._closed) {
                return;
            }
            this._closed = true;
            this._lock.notify();
        }
        this._dispatcher.waitUntilFinished();
        this._dispatcher = null;
    }

    private class CompletionEventThread
    implements Runnable {
        Thread _t = null;
        TibjmsMessageProducer _producer = null;
        TibjmsCompletionEventProcessor _processor = null;

        CompletionEventThread(TibjmsCompletionEventProcessor tibjmsCompletionEventProcessor2, TibjmsMessageProducer tibjmsMessageProducer) {
            this._processor = tibjmsCompletionEventProcessor2;
            this._producer = tibjmsMessageProducer;
            this._t = new Thread(this);
            this._t.setDaemon(true);
            this._t.setName("TIBCO EMS Completion Listener Dispatcher (" + this._producer._prodid + ")");
            this._t.start();
        }

        void waitUntilFinished() {
            if (this._t == null) {
                return;
            }
            try {
                this._t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._t = null;
        }

        @Override
        public void run() {
            Tibjmsx.ListenerCallbackArgs.set(this._producer, this._producer._session, this._producer._session._connection, 1);
            while (!this._processor.isDone()) {
                this._processor.dispatch();
            }
        }
    }
}

