/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.tibco;

import com.redhat.parodos.tasks.tibco.Tibjms;
import com.redhat.parodos.tasks.tibco.TibjmsImpl;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflow.task.enums.WorkFlowTaskOutput;
import com.redhat.parodos.workflow.task.parameter.WorkFlowTaskParameter;
import com.redhat.parodos.workflow.task.parameter.WorkFlowTaskParameterType;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TibcoWorkFlowTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TibcoWorkFlowTask.class);
    private final Tibjms service;
    private final String url;
    private final String caFile;
    private final String username;
    private final String password;

    public TibcoWorkFlowTask(String url, String caFile, String username, String password) {
        this(new TibjmsImpl(), url, username, password, caFile);
    }

    TibcoWorkFlowTask(Tibjms service, String url, String caFile, String username, String password) {
        this.service = service;
        this.url = url;
        this.caFile = caFile;
        this.username = username;
        this.password = password;
    }

    @NonNull
    public List<WorkFlowTaskParameter> getWorkFlowTaskParameters() {
        LinkedList<WorkFlowTaskParameter> params = new LinkedList<WorkFlowTaskParameter>();
        params.add(WorkFlowTaskParameter.builder().key("topic").type(WorkFlowTaskParameterType.TEXT).optional(false).description("Topic to send to").build());
        params.add(WorkFlowTaskParameter.builder().key("message").type(WorkFlowTaskParameterType.TEXT).optional(false).description("Message to send to topic").build());
        return params;
    }

    @NonNull
    public List<WorkFlowTaskOutput> getWorkFlowTaskOutputs() {
        return List.of(WorkFlowTaskOutput.OTHER);
    }

    public WorkReport execute(WorkContext workContext) {
        try {
            String topic = this.getRequiredParameterValue(workContext, "topic");
            String message = this.getRequiredParameterValue(workContext, "message");
            this.service.sendMessage(this.url, this.caFile, this.username, this.password, topic, message);
        }
        catch (Exception e) {
            log.error("TIBCO task failed", (Throwable)e);
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }
}

