/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.sdk.api;

import com.google.gson.reflect.TypeToken;
import com.redhat.parodos.sdk.api.ApiCallback;
import com.redhat.parodos.sdk.api.ApiClient;
import com.redhat.parodos.sdk.api.ApiException;
import com.redhat.parodos.sdk.api.ApiResponse;
import com.redhat.parodos.sdk.api.Configuration;
import com.redhat.parodos.sdk.api.Pair;
import com.redhat.parodos.sdk.model.WorkFlowCheckerTaskRequestDTO;
import com.redhat.parodos.sdk.model.WorkFlowRequestDTO;
import com.redhat.parodos.sdk.model.WorkFlowResponseDTO;
import com.redhat.parodos.sdk.model.WorkFlowStatusResponseDTO;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class WorkflowApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WorkflowApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call executeCall(WorkFlowRequestDTO workFlowRequestDTO, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WorkFlowRequestDTO localVarPostBody = workFlowRequestDTO;
        String localVarPath = "/api/v1/workflows";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call executeValidateBeforeCall(WorkFlowRequestDTO workFlowRequestDTO, ApiCallback _callback) throws ApiException {
        if (workFlowRequestDTO == null) {
            throw new ApiException("Missing the required parameter 'workFlowRequestDTO' when calling execute(Async)");
        }
        Call localVarCall = this.executeCall(workFlowRequestDTO, _callback);
        return localVarCall;
    }

    public WorkFlowResponseDTO execute(WorkFlowRequestDTO workFlowRequestDTO) throws ApiException {
        ApiResponse<WorkFlowResponseDTO> localVarResp = this.executeWithHttpInfo(workFlowRequestDTO);
        return localVarResp.getData();
    }

    public ApiResponse<WorkFlowResponseDTO> executeWithHttpInfo(WorkFlowRequestDTO workFlowRequestDTO) throws ApiException {
        Call localVarCall = this.executeValidateBeforeCall(workFlowRequestDTO, null);
        Type localVarReturnType = new TypeToken<WorkFlowResponseDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call executeAsync(WorkFlowRequestDTO workFlowRequestDTO, ApiCallback<WorkFlowResponseDTO> _callback) throws ApiException {
        Call localVarCall = this.executeValidateBeforeCall(workFlowRequestDTO, _callback);
        Type localVarReturnType = new TypeToken<WorkFlowResponseDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getStatusCall(String workFlowExecutionId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/workflows/{workFlowExecutionId}/status".replaceAll("\\{workFlowExecutionId\\}", this.localVarApiClient.escapeString(workFlowExecutionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStatusValidateBeforeCall(String workFlowExecutionId, ApiCallback _callback) throws ApiException {
        if (workFlowExecutionId == null) {
            throw new ApiException("Missing the required parameter 'workFlowExecutionId' when calling getStatus(Async)");
        }
        Call localVarCall = this.getStatusCall(workFlowExecutionId, _callback);
        return localVarCall;
    }

    public WorkFlowStatusResponseDTO getStatus(String workFlowExecutionId) throws ApiException {
        ApiResponse<WorkFlowStatusResponseDTO> localVarResp = this.getStatusWithHttpInfo(workFlowExecutionId);
        return localVarResp.getData();
    }

    public ApiResponse<WorkFlowStatusResponseDTO> getStatusWithHttpInfo(String workFlowExecutionId) throws ApiException {
        Call localVarCall = this.getStatusValidateBeforeCall(workFlowExecutionId, null);
        Type localVarReturnType = new TypeToken<WorkFlowStatusResponseDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getStatusAsync(String workFlowExecutionId, ApiCallback<WorkFlowStatusResponseDTO> _callback) throws ApiException {
        Call localVarCall = this.getStatusValidateBeforeCall(workFlowExecutionId, _callback);
        Type localVarReturnType = new TypeToken<WorkFlowStatusResponseDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateWorkFlowCheckerTaskStatusCall(String workFlowExecutionId, String workFlowCheckerTaskName, WorkFlowCheckerTaskRequestDTO workFlowCheckerTaskRequestDTO, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WorkFlowCheckerTaskRequestDTO localVarPostBody = workFlowCheckerTaskRequestDTO;
        String localVarPath = "/api/v1/workflows/{workFlowExecutionId}/checkers/{workFlowCheckerTaskName}".replaceAll("\\{workFlowExecutionId\\}", this.localVarApiClient.escapeString(workFlowExecutionId.toString())).replaceAll("\\{workFlowCheckerTaskName\\}", this.localVarApiClient.escapeString(workFlowCheckerTaskName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateWorkFlowCheckerTaskStatusValidateBeforeCall(String workFlowExecutionId, String workFlowCheckerTaskName, WorkFlowCheckerTaskRequestDTO workFlowCheckerTaskRequestDTO, ApiCallback _callback) throws ApiException {
        if (workFlowExecutionId == null) {
            throw new ApiException("Missing the required parameter 'workFlowExecutionId' when calling updateWorkFlowCheckerTaskStatus(Async)");
        }
        if (workFlowCheckerTaskName == null) {
            throw new ApiException("Missing the required parameter 'workFlowCheckerTaskName' when calling updateWorkFlowCheckerTaskStatus(Async)");
        }
        if (workFlowCheckerTaskRequestDTO == null) {
            throw new ApiException("Missing the required parameter 'workFlowCheckerTaskRequestDTO' when calling updateWorkFlowCheckerTaskStatus(Async)");
        }
        Call localVarCall = this.updateWorkFlowCheckerTaskStatusCall(workFlowExecutionId, workFlowCheckerTaskName, workFlowCheckerTaskRequestDTO, _callback);
        return localVarCall;
    }

    public String updateWorkFlowCheckerTaskStatus(String workFlowExecutionId, String workFlowCheckerTaskName, WorkFlowCheckerTaskRequestDTO workFlowCheckerTaskRequestDTO) throws ApiException {
        ApiResponse<String> localVarResp = this.updateWorkFlowCheckerTaskStatusWithHttpInfo(workFlowExecutionId, workFlowCheckerTaskName, workFlowCheckerTaskRequestDTO);
        return localVarResp.getData();
    }

    public ApiResponse<String> updateWorkFlowCheckerTaskStatusWithHttpInfo(String workFlowExecutionId, String workFlowCheckerTaskName, WorkFlowCheckerTaskRequestDTO workFlowCheckerTaskRequestDTO) throws ApiException {
        Call localVarCall = this.updateWorkFlowCheckerTaskStatusValidateBeforeCall(workFlowExecutionId, workFlowCheckerTaskName, workFlowCheckerTaskRequestDTO, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateWorkFlowCheckerTaskStatusAsync(String workFlowExecutionId, String workFlowCheckerTaskName, WorkFlowCheckerTaskRequestDTO workFlowCheckerTaskRequestDTO, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.updateWorkFlowCheckerTaskStatusValidateBeforeCall(workFlowExecutionId, workFlowCheckerTaskName, workFlowCheckerTaskRequestDTO, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

