/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.simple;

import com.redhat.parodos.examples.simple.task.LoggingWorkFlowTask;
import com.redhat.parodos.examples.simple.task.RestAPIWorkFlowTask;
import com.redhat.parodos.workflow.annotation.Infrastructure;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.workflow.ParallelFlow;
import com.redhat.parodos.workflows.workflow.SequentialFlow;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SimpleWorkFlowConfiguration {
    @Bean
    RestAPIWorkFlowTask restCallTask() {
        return new RestAPIWorkFlowTask();
    }

    @Bean
    LoggingWorkFlowTask loggingTask() {
        return new LoggingWorkFlowTask();
    }

    @Bean(name={"simpleSequentialWorkFlow_INFRASTRUCTURE_WORKFLOW"})
    @Infrastructure
    WorkFlow simpleSequentialWorkFlowTask(@Qualifier(value="restCallTask") RestAPIWorkFlowTask restCallTask, @Qualifier(value="loggingTask") LoggingWorkFlowTask loggingTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("simpleSequentialWorkFlow_INFRASTRUCTURE_WORKFLOW").execute((Work)restCallTask).then((Work)loggingTask).build();
    }

    @Bean
    LoggingWorkFlowTask simpleParallelTask1() {
        return new LoggingWorkFlowTask();
    }

    @Bean
    LoggingWorkFlowTask simpleParallelTask2() {
        return new LoggingWorkFlowTask();
    }

    @Bean
    LoggingWorkFlowTask simpleParallelTask3() {
        return new LoggingWorkFlowTask();
    }

    @Bean(name={"simpleParallelWorkFlow_INFRASTRUCTURE_WORKFLOW"})
    @Infrastructure
    WorkFlow simpleParallelWorkFlowTask(@Qualifier(value="simpleParallelTask1") LoggingWorkFlowTask simpleParallelTask1, @Qualifier(value="simpleParallelTask2") LoggingWorkFlowTask simpleParallelTask2, @Qualifier(value="simpleParallelTask3") LoggingWorkFlowTask simpleParallelTask3) {
        return ParallelFlow.Builder.aNewParallelFlow().named("simple Parallel WorkFlow").execute(new Work[]{simpleParallelTask1, simpleParallelTask2, simpleParallelTask3}).with(Executors.newFixedThreadPool(3)).build();
    }
}

