/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.master;

import com.redhat.parodos.examples.master.checker.NamespaceApprovalWorkFlowCheckerTask;
import com.redhat.parodos.examples.master.checker.SslCertificationApprovalWorkFlowCheckerTask;
import com.redhat.parodos.examples.master.task.AdGroupsWorkFlowTask;
import com.redhat.parodos.examples.master.task.LoadBalancerWorkFlowTask;
import com.redhat.parodos.examples.master.task.NamespaceWorkFlowTask;
import com.redhat.parodos.examples.master.task.OnboardingAssessmentTask;
import com.redhat.parodos.examples.master.task.SingleSignOnWorkFlowTask;
import com.redhat.parodos.examples.master.task.SplunkMonitoringWorkFlowTask;
import com.redhat.parodos.examples.master.task.SslCertificationWorkFlowTask;
import com.redhat.parodos.workflow.annotation.Assessment;
import com.redhat.parodos.workflow.annotation.Checker;
import com.redhat.parodos.workflow.annotation.Infrastructure;
import com.redhat.parodos.workflow.annotation.Parameter;
import com.redhat.parodos.workflow.option.WorkFlowOption;
import com.redhat.parodos.workflow.parameter.WorkFlowParameterType;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.workflow.ParallelFlow;
import com.redhat.parodos.workflows.workflow.SequentialFlow;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MasterWorkFlowConfiguration {
    @Bean
    WorkFlowOption onboardingOption() {
        return new WorkFlowOption.Builder("onboardingOption", "masterWorkFlow").addToDetails("An example workflow option of a complex master WorkFlow with Status checks").displayName("Onboarding").setDescription("An example of a complex WorkFlow").build();
    }

    @Bean
    OnboardingAssessmentTask onboardingAssessmentTask(@Qualifier(value="onboardingOption") WorkFlowOption awesomeToolsOption) {
        return new OnboardingAssessmentTask(awesomeToolsOption);
    }

    @Bean(name={"onboardingAssessment_ASSESSMENT_WORKFLOW"})
    @Assessment
    WorkFlow assessmentWorkFlow(@Qualifier(value="onboardingAssessmentTask") OnboardingAssessmentTask onboardingAssessmentTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("onboardingAssessment_ASSESSMENT_WORKFLOW").execute((Work)onboardingAssessmentTask).build();
    }

    @Bean
    AdGroupsWorkFlowTask adGroupsWorkFlowTask() {
        return new AdGroupsWorkFlowTask();
    }

    @Bean
    SplunkMonitoringWorkFlowTask splunkMonitoringWorkFlowTask() {
        return new SplunkMonitoringWorkFlowTask();
    }

    @Bean(name={"subWorkFlowOne"})
    @Infrastructure(parameters={@Parameter(key="comment", description="The workflow comment", type=WorkFlowParameterType.TEXT, optional=false)})
    WorkFlow subWorkFlowOne(@Qualifier(value="adGroupsWorkFlowTask") AdGroupsWorkFlowTask adGroupsWorkFlowTask, @Qualifier(value="splunkMonitoringWorkFlowTask") SplunkMonitoringWorkFlowTask splunkMonitoringWorkFlowTask) {
        return ParallelFlow.Builder.aNewParallelFlow().named("subWorkFlowOne").execute(new Work[]{adGroupsWorkFlowTask, splunkMonitoringWorkFlowTask}).with(Executors.newFixedThreadPool(2)).build();
    }

    @Bean
    NamespaceApprovalWorkFlowCheckerTask namespaceApprovalWorkFlowCheckerTask() {
        return new NamespaceApprovalWorkFlowCheckerTask();
    }

    @Bean(name={"namespaceApprovalWorkFlowChecker"})
    @Checker(cronExpression="*/5 * * * * ?")
    WorkFlow namespaceApprovalWorkFlowChecker(@Qualifier(value="namespaceApprovalWorkFlowCheckerTask") NamespaceApprovalWorkFlowCheckerTask namespaceApprovalWorkFlowCheckerTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("namespaceApprovalWorkFlowChecker").execute((Work)namespaceApprovalWorkFlowCheckerTask).build();
    }

    @Bean
    NamespaceWorkFlowTask namespaceWorkFlowTask(@Qualifier(value="namespaceApprovalWorkFlowChecker") WorkFlow namespaceApprovalWorkFlowChecker) {
        NamespaceWorkFlowTask namespaceWorkFlowTask = new NamespaceWorkFlowTask();
        namespaceWorkFlowTask.setWorkFlowChecker(namespaceApprovalWorkFlowChecker);
        return namespaceWorkFlowTask;
    }

    @Bean(name={"subWorkFlowTwo"})
    @Infrastructure
    WorkFlow subWorkFlowTwo(@Qualifier(value="subWorkFlowOne") WorkFlow subWorkFlowOne, @Qualifier(value="namespaceWorkFlowTask") NamespaceWorkFlowTask namespaceWorkFlowTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("subWorkFlowTwo").execute((Work)subWorkFlowOne).then((Work)namespaceWorkFlowTask).build();
    }

    @Bean
    SslCertificationApprovalWorkFlowCheckerTask sslCertificationApprovalWorkFlowCheckerTask() {
        return new SslCertificationApprovalWorkFlowCheckerTask();
    }

    @Bean(name={"sslCertificationApprovalWorkFlowChecker"})
    @Checker(cronExpression="*/5 * * * * ?")
    WorkFlow sslCertificationApprovalWorkFlowChecker(@Qualifier(value="sslCertificationApprovalWorkFlowCheckerTask") SslCertificationApprovalWorkFlowCheckerTask sslCertificationApprovalWorkFlowCheckerTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("sslCertificationApprovalWorkFlowChecker").execute((Work)sslCertificationApprovalWorkFlowCheckerTask).build();
    }

    @Bean
    SslCertificationWorkFlowTask sslCertificationWorkFlowTask(@Qualifier(value="sslCertificationApprovalWorkFlowChecker") WorkFlow sslCertificationApprovalWorkFlowChecker) {
        SslCertificationWorkFlowTask sslCertificationWorkFlowTask = new SslCertificationWorkFlowTask();
        sslCertificationWorkFlowTask.setWorkFlowChecker(sslCertificationApprovalWorkFlowChecker);
        return sslCertificationWorkFlowTask;
    }

    @Bean(name={"subWorkFlowThree"})
    @Infrastructure
    WorkFlow subWorkFlowThree(@Qualifier(value="sslCertificationWorkFlowTask") SslCertificationWorkFlowTask sslCertificationWorkFlowTask, @Qualifier(value="subWorkFlowTwo") WorkFlow subWorkFlowTwo) {
        return ParallelFlow.Builder.aNewParallelFlow().named("subWorkFlowThree").execute(new Work[]{sslCertificationWorkFlowTask, subWorkFlowTwo}).with(Executors.newFixedThreadPool(2)).build();
    }

    @Bean
    LoadBalancerWorkFlowTask loadBalancerWorkFlowTask() {
        return new LoadBalancerWorkFlowTask();
    }

    @Bean
    SingleSignOnWorkFlowTask singleSignOnWorkFlowTask() {
        return new SingleSignOnWorkFlowTask();
    }

    @Bean(name={"subWorkFlowFour"})
    @Infrastructure
    WorkFlow subWorkFlowFour(@Qualifier(value="loadBalancerWorkFlowTask") LoadBalancerWorkFlowTask loadBalancerWorkFlowTask, @Qualifier(value="singleSignOnWorkFlowTask") SingleSignOnWorkFlowTask singleSignOnWorkFlowTask) {
        return ParallelFlow.Builder.aNewParallelFlow().named("subWorkFlowFour").execute(new Work[]{loadBalancerWorkFlowTask, singleSignOnWorkFlowTask}).with(Executors.newFixedThreadPool(2)).build();
    }

    @Bean(name={"masterWorkFlow"})
    @Infrastructure(parameters={@Parameter(key="workloadId", description="The workload id", type=WorkFlowParameterType.TEXT, optional=false), @Parameter(key="projectUrl", description="The project url", type=WorkFlowParameterType.URL, optional=true)})
    WorkFlow masterWorkFlow(@Qualifier(value="subWorkFlowThree") WorkFlow subWorkFlowThree, @Qualifier(value="subWorkFlowFour") WorkFlow subWorkFlowFour) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("masterWorkFlow").execute((Work)subWorkFlowThree).then((Work)subWorkFlowFour).build();
    }
}

