/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.web;

import io.swagger.models.Swagger;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.swagger2.web.SwaggerTransformationContext;
import springfox.documentation.swagger2.web.WebFluxSwaggerTransformationFilter;

@Order(value=-2147483648)
public class WebFluxBasePathAndHostnameTransformationFilter
implements WebFluxSwaggerTransformationFilter {
    @Override
    public Swagger transform(SwaggerTransformationContext<ServerHttpRequest> context) {
        Swagger swagger = context.getSpecification();
        context.request().ifPresent(request -> {
            swagger.basePath(StringUtils.isEmpty(request.getPath().contextPath().value()) ? "/" : request.getPath().contextPath().value());
            if (StringUtils.isEmpty(swagger.getHost())) {
                swagger.host(request.getURI().getAuthority());
            }
        });
        return swagger;
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return delimiter == DocumentationType.SWAGGER_2;
    }
}

