/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.Map;
import org.mapstruct.Context;
import org.mapstruct.Mapper;
import springfox.documentation.schema.CollectionSpecification;
import springfox.documentation.schema.CompoundModelSpecification;
import springfox.documentation.schema.MapSpecification;
import springfox.documentation.schema.ModelFacets;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.PropertySpecification;
import springfox.documentation.schema.ReferenceModelSpecification;
import springfox.documentation.schema.ScalarModelSpecification;
import springfox.documentation.schema.Xml;
import springfox.documentation.service.ModelNamesRegistry;
import springfox.documentation.swagger2.mappers.CollectionSpecificationToPropertyConverter;
import springfox.documentation.swagger2.mappers.CompoundSpecificationToPropertyConverter;
import springfox.documentation.swagger2.mappers.EnumMapper;
import springfox.documentation.swagger2.mappers.MapSpecificationToPropertyConverter;
import springfox.documentation.swagger2.mappers.ReferenceModelSpecificationToPropertyConverter;
import springfox.documentation.swagger2.mappers.ScalarModelToPropertyConverter;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

@Mapper
public class PropertyMapper {
    public Property fromModel(ModelSpecification modelSpecification, @Context ModelNamesRegistry modelNamesRegistry) {
        if (modelSpecification == null) {
            return null;
        }
        Property property = modelSpecification.getScalar().map(sm -> new ScalarModelToPropertyConverter().convert((ScalarModelSpecification)sm)).orElse(null);
        if (property == null) {
            property = modelSpecification.getCompound().map(cm -> new CompoundSpecificationToPropertyConverter(modelNamesRegistry).convert((CompoundModelSpecification)cm)).orElse(null);
        }
        if (property == null) {
            property = modelSpecification.getMap().map(mm3 -> new MapSpecificationToPropertyConverter(modelNamesRegistry).convert((MapSpecification)mm3)).orElse(null);
        }
        if (property == null) {
            property = modelSpecification.getCollection().map(cm -> new CollectionSpecificationToPropertyConverter(modelNamesRegistry).convert((CollectionSpecification)cm)).orElse(null);
        }
        if (property == null) {
            property = modelSpecification.getReference().map(cm -> new ReferenceModelSpecificationToPropertyConverter(modelNamesRegistry).convert((ReferenceModelSpecification)cm)).orElse(null);
        }
        if (property != null) {
            property.setName(modelSpecification.getName());
            EnumMapper.maybeAddFacets(property, modelSpecification.getFacets().orElse(null));
        }
        return property;
    }

    public Property fromProperty(PropertySpecification source2, @Context ModelNamesRegistry modelNamesRegistry) {
        Property property = this.fromModel(source2.getType(), modelNamesRegistry);
        ModelFacets facets = source2.getType().getFacets().orElse(null);
        EnumMapper.maybeAddFacets(property, facets);
        EnumMapper.maybeAddFacets(property, source2);
        if (property instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)property;
            EnumMapper.maybeAddFacets(arrayProperty.getItems(), source2.getType().getCollection().flatMap(c -> c.getModel().getFacets()).orElse(null));
        }
        if (property instanceof MapProperty) {
            MapProperty mapProperty = (MapProperty)property;
            EnumMapper.maybeAddFacets(mapProperty.getAdditionalProperties(), source2.getType().getMap().flatMap(c -> c.getValue().getFacets()).orElse(null));
        }
        if (property instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)property;
            stringProperty.setDefault(source2.getDefaultValue() != null ? String.valueOf(source2.getDefaultValue()) : null);
        }
        Map<String, Object> extensions = new VendorExtensionsMapper().mapExtensions(source2.getVendorExtensions());
        if (property != null) {
            property.setDescription(source2.getDescription());
            property.setName(source2.getName());
            property.setRequired(source2.getRequired() == null ? false : source2.getRequired());
            property.setReadOnly(source2.getReadOnly());
            property.setAllowEmptyValue(source2.getAllowEmptyValue());
            property.setExample(source2.getExample());
            property.getVendorExtensions().putAll(extensions);
            property.setXml(this.mapXml(source2.getXml()));
        }
        return property;
    }

    private io.swagger.models.Xml mapXml(Xml xml) {
        if (xml == null) {
            return null;
        }
        return new io.swagger.models.Xml().name(xml.getName()).attribute(xml.getAttribute()).namespace(xml.getNamespace()).prefix(xml.getPrefix()).wrapped(xml.getWrapped());
    }
}

