/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mapstruct.Context;
import org.mapstruct.Mapper;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.CollectionElementFacet;
import springfox.documentation.schema.CompoundModelSpecification;
import springfox.documentation.schema.EnumerationFacet;
import springfox.documentation.schema.ModelFacets;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.NumericElementFacet;
import springfox.documentation.schema.PropertySpecification;
import springfox.documentation.schema.StringElementFacet;
import springfox.documentation.schema.Xml;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.ModelNamesRegistry;
import springfox.documentation.swagger2.mappers.CollectionSpecificationToPropertyConverter;
import springfox.documentation.swagger2.mappers.CompoundSpecificationToPropertyConverter;
import springfox.documentation.swagger2.mappers.ModelSpecificationInheritanceDeterminer;
import springfox.documentation.swagger2.mappers.PropertyMapper;
import springfox.documentation.swagger2.mappers.ReferenceModelSpecificationToPropertyConverter;
import springfox.documentation.swagger2.mappers.ScalarModelToPropertyConverter;

@Mapper
public abstract class ModelSpecificationMapper {
    private final PropertyMapper propertyMapper = new PropertyMapper();

    public Map<String, Model> modelsFromApiListings(Map<String, List<ApiListing>> apiListings) {
        TreeMap<String, Model> modelMap = new TreeMap<String, Model>();
        apiListings.values().forEach(listings -> listings.forEach(each -> modelMap.putAll(this.mapModels(each.getModelSpecifications(), each.getModelNamesRegistry()))));
        return modelMap;
    }

    protected abstract Map<String, Model> mapModels(Map<String, ModelSpecification> var1, @Context ModelNamesRegistry var2);

    public Model mapModels(ModelSpecification source2, @Context ModelNamesRegistry namesRegistry) {
        if (source2 == null) {
            return null;
        }
        ModelSpecificationInheritanceDeterminer determiner = new ModelSpecificationInheritanceDeterminer(namesRegistry);
        return determiner.parent(source2).map(rm -> this.mapComposedModel((RefModel)rm, source2, namesRegistry)).orElse(this.model(source2, namesRegistry));
    }

    private Model model(ModelSpecification source2, @Context ModelNamesRegistry namesRegistry) {
        ModelImpl model = new ModelImpl().description(source2.getFacets().map(ModelFacets::getDescription).orElse(null)).discriminator(source2.getCompound().map(CompoundModelSpecification::getDiscriminator).orElse(null)).example(source2.getFacets().map(ModelFacets::getExamples).orElse(Collections.EMPTY_LIST).stream().findFirst().orElse(null)).name(source2.getName()).xml(this.mapXml(source2.getFacets().map(ModelFacets::getXml).orElse(null)));
        Model toReturn = source2.getCompound().map(c -> {
            TreeMap<String, Property> modelProperties = new TreeMap<String, Property>(Comparator.naturalOrder());
            Map<String, PropertySpecification> properties = c.getProperties().stream().collect(Collectors.toMap(PropertySpecification::getName, Function.identity()));
            modelProperties.putAll(this.mapProperties(properties, namesRegistry));
            model.setProperties(modelProperties);
            List<String> requiredFields = properties.values().stream().filter(PropertySpecification::nullSafeIsRequired).map(PropertySpecification::getName).filter(Objects::nonNull).collect(Collectors.toList());
            model.setRequired(requiredFields);
            model.setSimple(false);
            model.setType("object");
            model.setTitle(source2.getFacets().map(ModelFacets::getTitle).orElse(null));
            return model;
        }).orElse(null);
        if (toReturn != null) {
            return toReturn;
        }
        toReturn = source2.getScalar().map(s2 -> {
            model.setType(s2.getType().getType());
            model.setFormat(s2.getType().getFormat());
            source2.getFacets().flatMap(f -> f.elementFacet(EnumerationFacet.class)).ifPresent(ef -> model._enum(ef.getAllowedValues()));
            source2.getFacets().flatMap(f -> f.elementFacet(StringElementFacet.class)).ifPresent(sf -> {
                model.setPattern(sf.getPattern());
                model.setMinLength(sf.getMinLength());
                model.setMaxLength(sf.getMaxLength());
            });
            source2.getFacets().flatMap(f -> f.elementFacet(NumericElementFacet.class)).ifPresent(nf -> {
                model.maximum(nf.getMaximum());
                model.minimum(nf.getMinimum());
                model.setExclusiveMaximum(nf.getExclusiveMaximum());
                model.setExclusiveMinimum(nf.getExclusiveMinimum());
            });
            return model;
        }).orElse(null);
        if (toReturn != null) {
            return toReturn;
        }
        toReturn = source2.getReference().map(r -> {
            if (BuilderDefaults.emptyToNull(r.getKey().getQualifiedModelName().getName()) != null) {
                RefModel refModel = new RefModel();
                refModel.set$ref(namesRegistry.nameByKey(r.getKey()).orElse("ERROR - " + r.getKey().getQualifiedModelName()));
                return refModel;
            }
            return null;
        }).orElse(null);
        if (toReturn != null) {
            return toReturn;
        }
        toReturn = source2.getCollection().map(c -> {
            ModelSpecification itemSpec = c.getModel();
            ArrayModel arrayModel = new ArrayModel().description(source2.getFacets().map(ModelFacets::getDescription).orElse(null));
            arrayModel.setExample(source2.getFacets().map(ModelFacets::getExamples).orElse(Collections.EMPTY_LIST).stream().findFirst().orElse(null));
            if (itemSpec.getScalar().isPresent()) {
                arrayModel.items(new ScalarModelToPropertyConverter().convert(itemSpec.getScalar().get()));
            } else if (itemSpec.getCompound().isPresent()) {
                arrayModel.items(new CompoundSpecificationToPropertyConverter(namesRegistry).convert(itemSpec.getCompound().get()));
            } else if (itemSpec.getCollection().isPresent()) {
                arrayModel.items(new CollectionSpecificationToPropertyConverter(namesRegistry).convert(itemSpec.getCollection().get()));
            } else if (itemSpec.getReference().isPresent()) {
                arrayModel.items(new ReferenceModelSpecificationToPropertyConverter(namesRegistry).convert(itemSpec.getReference().get()));
            }
            source2.getFacets().flatMap(f -> f.elementFacet(CollectionElementFacet.class)).ifPresent(cf -> {
                arrayModel.setMaxItems(cf.getMaxItems());
                arrayModel.setMinItems(cf.getMinItems());
                arrayModel.setUniqueItems(cf.getUniqueItems());
            });
            return arrayModel;
        }).orElse(null);
        if (toReturn != null) {
            return toReturn;
        }
        return source2.getMap().map(map -> {
            ModelSpecification valueSpec = map.getValue();
            if (valueSpec.getScalar().isPresent()) {
                model.additionalProperties(new ScalarModelToPropertyConverter().convert(valueSpec.getScalar().get()));
            } else if (valueSpec.getCompound().isPresent()) {
                model.additionalProperties(new CompoundSpecificationToPropertyConverter(namesRegistry).convert(valueSpec.getCompound().get()));
            } else if (valueSpec.getCollection().isPresent()) {
                model.additionalProperties(new CollectionSpecificationToPropertyConverter(namesRegistry).convert(valueSpec.getCollection().get()));
            } else if (valueSpec.getReference().isPresent()) {
                model.additionalProperties(new ReferenceModelSpecificationToPropertyConverter(namesRegistry).convert(valueSpec.getReference().get()));
            } else {
                model.additionalProperties(new ObjectProperty());
            }
            return model;
        }).orElse(null);
    }

    private Model mapComposedModel(RefModel parent, ModelSpecification source2, ModelNamesRegistry namesRegistry) {
        ComposedModel model = new ComposedModel().interfaces(Collections.singletonList(parent)).child(this.model(source2, namesRegistry));
        model.setDescription(source2.getFacets().map(ModelFacets::getDescription).orElse(null));
        model.setExample(source2.getFacets().map(ModelFacets::getExamples).orElse(Collections.EMPTY_LIST).stream().findFirst().orElse(null));
        model.setTitle(source2.getName());
        Map properties = source2.getCompound().map(c -> c.getProperties().stream().collect(Collectors.toMap(PropertySpecification::getName, Function.identity()))).orElse(new HashMap());
        TreeMap<String, Property> modelProperties = new TreeMap<String, Property>(Comparator.naturalOrder());
        modelProperties.putAll(this.mapProperties(properties, namesRegistry));
        model.setProperties(modelProperties);
        return model;
    }

    protected Map<String, Property> mapProperties(Map<String, PropertySpecification> properties, ModelNamesRegistry modelNamesRegistry) {
        return properties.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparing(PropertySpecification::getPosition).thenComparing(PropertySpecification::getName))).collect(Collectors.toMap(Map.Entry::getKey, e -> this.propertyMapper.fromProperty((PropertySpecification)e.getValue(), modelNamesRegistry), (p1, p2) -> p1, TreeMap::new));
    }

    private io.swagger.models.Xml mapXml(Xml xml) {
        if (xml == null) {
            return null;
        }
        return new io.swagger.models.Xml().name(xml.getName()).attribute(xml.getAttribute()).namespace(xml.getNamespace()).prefix(xml.getPrefix()).wrapped(xml.getWrapped());
    }
}

