/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.fasterxml.classmate.ResolvedType;
import io.swagger.models.ComposedModel;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mapstruct.Mapper;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.Xml;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.swagger2.mappers.EnumMapper;
import springfox.documentation.swagger2.mappers.InheritanceDeterminer;
import springfox.documentation.swagger2.mappers.Properties;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

@Deprecated
@Mapper
public class ModelMapper {
    public Map<String, io.swagger.models.Model> mapModels(Map<String, Model> from) {
        if (from == null) {
            return null;
        }
        TreeMap<String, io.swagger.models.Model> map = new TreeMap<String, io.swagger.models.Model>(Comparator.naturalOrder());
        InheritanceDeterminer determiner = new InheritanceDeterminer(from);
        for (Map.Entry<String, Model> entry : from.entrySet()) {
            String key = entry.getKey();
            io.swagger.models.Model value = determiner.hasParent(entry.getValue()) ? this.mapComposedModel(determiner.parent(entry.getValue()), entry.getValue()) : this.mapModel(entry.getValue());
            map.put(key, value);
        }
        return map;
    }

    private io.swagger.models.Model mapComposedModel(RefModel parent, Model source2) {
        ComposedModel model = new ComposedModel().interfaces(Collections.singletonList(parent)).child(this.mapModel(source2));
        model.setDescription(source2.getDescription());
        model.setExample(source2.getExample());
        model.setTitle(source2.getName());
        SortedMap<String, ModelProperty> sortedProperties = this.sort(source2.getProperties());
        Map<String, Property> modelProperties = this.mapProperties(sortedProperties);
        model.setProperties(modelProperties);
        return model;
    }

    private io.swagger.models.Model mapModel(Model source2) {
        ModelImpl model = new ModelImpl().description(source2.getDescription()).discriminator(source2.getDiscriminator()).example(source2.getExample()).name(source2.getName()).xml(this.mapXml(source2.getXml()));
        SortedMap<String, ModelProperty> sortedProperties = this.sort(source2.getProperties());
        Map<String, Property> modelProperties = this.mapProperties(sortedProperties);
        model.setProperties(modelProperties);
        Stream<String> requiredFields = source2.getProperties().values().stream().filter(ModelProperty::isRequired).map(ModelProperty::getName);
        model.setRequired(requiredFields.collect(Collectors.toList()));
        model.setSimple(false);
        model.setType("object");
        model.setTitle(source2.getName());
        if (Maps.isMapType(source2.getType())) {
            Optional<Class> clazz = this.typeOfValue(source2);
            if (clazz.isPresent()) {
                model.additionalProperties(Properties.property(clazz.get().getSimpleName()));
            } else {
                model.additionalProperties(new ObjectProperty());
            }
        }
        return model;
    }

    private Map<String, Property> mapProperties(SortedMap<String, ModelProperty> properties) {
        LinkedHashMap<String, Property> mappedProperties = new LinkedHashMap<String, Property>();
        properties.entrySet().stream().filter(Properties.voidProperties().negate()).forEachOrdered(each -> mappedProperties.put((String)each.getKey(), this.mapProperty((ModelProperty)each.getValue())));
        return mappedProperties;
    }

    private SortedMap<String, ModelProperty> sort(Map<String, ModelProperty> modelProperties) {
        TreeMap<String, ModelProperty> sortedMap = new TreeMap<String, ModelProperty>(Properties.defaultOrdering(modelProperties));
        sortedMap.putAll(modelProperties);
        return sortedMap;
    }

    Optional<Class> typeOfValue(Model source2) {
        Optional<ResolvedType> mapInterface = this.findMapInterface(source2.getType());
        if (mapInterface.isPresent()) {
            if (mapInterface.get().getTypeParameters().size() == 2) {
                return Optional.of(mapInterface.get().getTypeParameters().get(1).getErasedType());
            }
            return Optional.of(Object.class);
        }
        return Optional.empty();
    }

    private Optional<ResolvedType> findMapInterface(ResolvedType type) {
        return Optional.ofNullable(type.findSupertype(Map.class));
    }

    private Property mapProperty(ModelProperty source2) {
        AllowableRangeValues range;
        AllowableValues allowableValues;
        Property property = ModelMapper.modelRefToProperty(source2.getModelRef());
        EnumMapper.maybeAddAllowableValues(property, source2.getAllowableValues());
        if (property instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)property;
            EnumMapper.maybeAddAllowableValues(arrayProperty.getItems(), source2.getAllowableValues());
        }
        if (property instanceof AbstractNumericProperty) {
            AbstractNumericProperty numericProperty = (AbstractNumericProperty)property;
            allowableValues = source2.getAllowableValues();
            if (allowableValues instanceof AllowableRangeValues) {
                range = (AllowableRangeValues)allowableValues;
                numericProperty.maximum(EnumMapper.safeBigDecimal(range.getMax()));
                numericProperty.exclusiveMaximum(range.getExclusiveMax());
                numericProperty.minimum(EnumMapper.safeBigDecimal(range.getMin()));
                numericProperty.exclusiveMinimum(range.getExclusiveMin());
            }
        }
        if (property instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)property;
            allowableValues = source2.getAllowableValues();
            if (allowableValues instanceof AllowableRangeValues) {
                range = (AllowableRangeValues)allowableValues;
                stringProperty.maxLength(ModelMapper.safeInteger(range.getMax()));
                stringProperty.minLength(ModelMapper.safeInteger(range.getMin()));
            }
            if (source2.getPattern() != null) {
                stringProperty.setPattern(source2.getPattern());
            }
            stringProperty.setDefault(source2.getDefaultValue());
        }
        Map<String, Object> extensions = new VendorExtensionsMapper().mapExtensions(source2.getVendorExtensions());
        if (property != null) {
            property.setDescription(source2.getDescription());
            property.setName(source2.getName());
            property.setRequired(source2.isRequired());
            property.setReadOnly(source2.isReadOnly());
            property.setAllowEmptyValue(source2.isAllowEmptyValue());
            property.setExample(source2.getExample());
            property.getVendorExtensions().putAll(extensions);
            property.setXml(this.mapXml(source2.getXml()));
        }
        return property;
    }

    private io.swagger.models.Xml mapXml(Xml xml) {
        if (xml == null) {
            return null;
        }
        return new io.swagger.models.Xml().name(xml.getName()).attribute(xml.getAttribute()).namespace(xml.getNamespace()).prefix(xml.getPrefix()).wrapped(xml.getWrapped());
    }

    static Integer safeInteger(String doubleString) {
        try {
            return Integer.valueOf(doubleString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static Property modelRefToProperty(ModelReference modelRef) {
        if (modelRef == null || "void".equalsIgnoreCase(modelRef.getType())) {
            return null;
        }
        Property responseProperty = modelRef.isCollection() ? Properties.property(modelRef) : (modelRef.isMap() ? new MapProperty(Properties.property(modelRef.itemModel().orElseThrow(() -> new IllegalStateException("ModelRef that is a map should have an itemModel")))) : Properties.property(modelRef.getType()));
        EnumMapper.maybeAddAllowableValues(responseProperty, modelRef.getAllowableValues());
        return responseProperty;
    }
}

