/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.parameter;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.media.Content;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ExampleBuilder;
import springfox.documentation.schema.Example;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.ParameterStyle;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.parameter.Examples;

@Order(value=-2147481648)
@Component
public class OpenApiParameterBuilder
implements ParameterBuilderPlugin {
    private final DescriptionResolver descriptions;

    @Autowired
    public OpenApiParameterBuilder(DescriptionResolver descriptions) {
        this.descriptions = descriptions;
    }

    @Override
    public void apply(ParameterContext context) {
        Optional<Parameter> parameterAnnotation = context.resolvedMethodParameter().findAnnotation(Parameter.class);
        AllowableListValues allowedValues = new AllowableListValues(parameterAnnotation.map(p -> Arrays.asList(p.schema().allowableValues())).orElse(new ArrayList()), "LIST");
        context.parameterBuilder().allowableValues(allowedValues);
        context.requestParameterBuilder().query(q -> q.enumerationFacet(e -> e.allowedValues(allowedValues)));
        if (parameterAnnotation.isPresent()) {
            Parameter annotation = parameterAnnotation.get();
            Example example = null;
            if (annotation.example().length() > 0) {
                example = new ExampleBuilder().value(annotation.example()).build();
            }
            Optional<ScalarType> scalarType = ScalarType.from(annotation.schema().type(), annotation.schema().format());
            context.requestParameterBuilder().name(annotation.name()).description(this.descriptions.resolve(annotation.description())).required(annotation.required()).hidden(annotation.hidden()).precedence(-2147481648).query(q -> q.model(m3 -> scalarType.ifPresent(m3::maybeConvertToScalar)).defaultValue(annotation.schema().defaultValue()).allowEmptyValue(annotation.allowEmptyValue()).explode(this.translateExplodeOption(annotation.explode())).style(this.translateStyle(annotation.style()))).example(example).examples(Examples.allExamples("", annotation.examples())).examples(this.contentExamples(annotation.content()));
        }
    }

    private ParameterStyle translateStyle(io.swagger.v3.oas.annotations.enums.ParameterStyle style) {
        return ParameterStyle.valueOf(style.name());
    }

    private Boolean translateExplodeOption(Explode explode) {
        if (explode == Explode.DEFAULT) {
            return null;
        }
        return explode == Explode.TRUE;
    }

    private Collection<Example> contentExamples(Content[] contents) {
        return Arrays.stream(contents).flatMap(c -> Examples.allExamples(c.mediaType(), c.examples()).stream()).collect(Collectors.toList());
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

