/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.ModelSpecificationProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;

@Component
public class ApiModelSpecificationReader {
    private final ModelSpecificationProvider modelProvider;
    private final DocumentationPluginsManager pluginsManager;
    private final TypeResolver resolver;

    @Autowired
    public ApiModelSpecificationReader(@Qualifier(value="cachedModels") ModelSpecificationProvider modelProvider, DocumentationPluginsManager pluginsManager, TypeResolver resolver) {
        this.modelProvider = modelProvider;
        this.pluginsManager = pluginsManager;
        this.resolver = resolver;
    }

    public Set<ModelSpecification> read(RequestMappingContext context) {
        HashSet<ModelSpecification> specifications = new HashSet<ModelSpecification>();
        Set<ModelContext> modelContexts = this.pluginsManager.modelContexts(context);
        for (ModelContext each : modelContexts) {
            this.markIgnorablesAsHasSeen(context.getIgnorableParameterTypes(), each);
            this.modelProvider.modelSpecificationsFor(each).ifPresent(specifications::add);
            specifications.addAll(this.modelProvider.modelDependenciesSpecifications(each));
        }
        return specifications;
    }

    private void markIgnorablesAsHasSeen(Set<Class> ignorableParameterTypes, ModelContext modelContext) {
        for (Class ignorableParameterType : ignorableParameterTypes) {
            modelContext.seen(this.resolver.resolve(ignorableParameterType, new Type[0]));
        }
    }
}

