/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.ModelSpecificationBuilder;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Enums;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.schema.ScalarTypes;
import springfox.documentation.schema.Types;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.CollectionFormat;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.service.ExpandedParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;

@Component
@Order(value=-2147483648)
public class ExpandedParameterBuilder
implements ExpandedParameterBuilderPlugin {
    private final TypeResolver resolver;
    private final EnumTypeDeterminer enumTypeDeterminer;

    @Autowired
    public ExpandedParameterBuilder(TypeResolver resolver, EnumTypeDeterminer enumTypeDeterminer) {
        this.resolver = resolver;
        this.enumTypeDeterminer = enumTypeDeterminer;
    }

    @Override
    public void apply(ParameterExpansionContext context) {
        ModelSpecification modelSpecification;
        AllowableValues allowable = this.allowableValues(context.getFieldType().getErasedType());
        String name = StringUtils.isEmpty(context.getParentName()) ? context.getFieldName() : String.format("%s.%s", context.getParentName(), context.getFieldName());
        String typeName = context.getDataTypeName();
        ModelRef itemModel = null;
        ResolvedType resolved = this.fieldType(context).orElse(this.resolver.resolve(context.getFieldType(), new Type[0]));
        if (Collections.isContainerType(resolved)) {
            ResolvedType elementType = Collections.collectionElementType(resolved);
            String itemTypeName = Types.typeNameFor(elementType.getErasedType());
            AllowableValues itemAllowables = null;
            if (this.enumTypeDeterminer.isEnum(elementType.getErasedType())) {
                allowable = itemAllowables = Enums.allowableValues(elementType.getErasedType());
                itemTypeName = "string";
            }
            typeName = Collections.containerType(resolved);
            itemModel = new ModelRef(itemTypeName, itemAllowables);
            modelSpecification = new ModelSpecificationBuilder().collectionModel(c -> c.model(m3 -> m3.scalarModel(this.scalarType(elementType)).facets(f -> f.enumerationFacet(e -> e.allowedValues(Enums.allowableValues(elementType.getErasedType()))))).collectionType(Collections.collectionType(resolved)).build()).facets(f -> f.enumerationFacet(e -> e.allowedValues(Enums.allowableValues(elementType.getErasedType())))).build();
        } else if (this.enumTypeDeterminer.isEnum(resolved.getErasedType())) {
            typeName = "string";
            modelSpecification = new ModelSpecificationBuilder().scalarModel(ScalarType.STRING).facets(f -> f.enumerationFacet(e -> e.allowedValues(Enums.allowableValues(resolved.getErasedType())).build())).build();
        } else {
            modelSpecification = new ModelSpecificationBuilder().scalarModel(ScalarTypes.builtInScalarType(resolved).orElse(ScalarType.STRING)).facets(f -> f.enumerationFacet(e -> e.allowedValues(Enums.allowableValues(resolved.getErasedType())).build())).build();
        }
        context.getParameterBuilder().name(name).description(null).defaultValue(null).required(Boolean.FALSE).allowMultiple(Collections.isContainerType(resolved)).type(resolved).modelRef(new ModelRef(typeName, itemModel)).allowableValues(allowable).parameterType(context.getParameterType()).order(0).parameterAccess(null);
        AllowableValues finalAllowable = allowable;
        context.getRequestParameterBuilder().name(name).description(null).required(Boolean.FALSE).in(context.getParameterType()).precedence(0).query(q -> q.collectionFormat(Collections.isContainerType(resolved) ? CollectionFormat.MULTI : null).model(m3 -> m3.copyOf(modelSpecification)).enumerationFacet(e -> e.allowedValues(finalAllowable)));
    }

    private ScalarType scalarType(ResolvedType elementType) {
        ScalarType scalarModelSpecification = ScalarTypes.builtInScalarType(elementType).orElse(ScalarType.STRING);
        if (this.enumTypeDeterminer.isEnum(elementType.getErasedType())) {
            scalarModelSpecification = ScalarType.STRING;
        }
        return scalarModelSpecification;
    }

    private Optional<ResolvedType> fieldType(ParameterExpansionContext context) {
        return Optional.of(context.getFieldType());
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private AllowableValues allowableValues(Class<?> fieldType) {
        AllowableListValues allowable = null;
        if (this.enumTypeDeterminer.isEnum(fieldType)) {
            allowable = new AllowableListValues(this.getEnumValues(fieldType), "LIST");
        }
        return allowable;
    }

    private List<String> getEnumValues(Class<?> subject) {
        return Stream.of(subject.getEnumConstants()).map(Object::toString).collect(Collectors.toList());
    }
}

