/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.RequestParameterBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ParameterStyle;
import springfox.documentation.service.ParameterType;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spring.wrapper.NameValueExpression;

public abstract class AbstractOperationParameterRequestConditionReader
implements OperationBuilderPlugin {
    private final TypeResolver resolver;

    public AbstractOperationParameterRequestConditionReader(TypeResolver resolver) {
        this.resolver = resolver;
    }

    public List<Parameter> getParameters(Set<NameValueExpression<String>> expressions, String parameterType) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (NameValueExpression<String> expression : expressions) {
            if (this.skipParameter(parameters, expression)) continue;
            String paramValue = expression.getValue();
            AllowableListValues allowableValues = null;
            if (!StringUtils.isEmpty(paramValue)) {
                allowableValues = new AllowableListValues(Collections.singletonList(paramValue), "string");
            }
            Parameter parameter = new ParameterBuilder().name(expression.getName()).description(null).defaultValue(paramValue).required(true).allowMultiple(false).type(this.resolver.resolve((Type)((Object)String.class), new Type[0])).modelRef(new ModelRef("string")).allowableValues(allowableValues).parameterType(parameterType).order(0).build();
            parameters.add(parameter);
        }
        return parameters;
    }

    protected Set<RequestParameter> getRequestParameters(Set<NameValueExpression<String>> expressions, ParameterType parameterType) {
        HashSet<RequestParameter> parameters = new HashSet<RequestParameter>();
        for (NameValueExpression<String> expression : expressions) {
            if (this.skipRequestParameter(parameters, expression)) continue;
            String paramValue = expression.getValue();
            AllowableListValues allowableValues = null;
            if (!StringUtils.isEmpty(paramValue)) {
                allowableValues = new AllowableListValues(Collections.singletonList(paramValue), "string");
            }
            AllowableListValues finalAllowableValues = allowableValues;
            RequestParameter parameter = new RequestParameterBuilder().name(expression.getName()).description(null).required(true).query(q -> q.style(ParameterStyle.SIMPLE).explode(false).allowReserved(false).defaultValue(paramValue).enumerationFacet(e -> e.allowedValues(finalAllowableValues)).model(m3 -> m3.name(expression.getName()).scalarModel(ScalarType.STRING))).in(parameterType).precedence(0).build();
            parameters.add(parameter);
        }
        return parameters;
    }

    private boolean skipParameter(List<Parameter> parameters, NameValueExpression<String> expression) {
        return expression.isNegated() || this.parameterHandled(parameters, expression);
    }

    private boolean skipRequestParameter(Set<RequestParameter> parameters, NameValueExpression<String> expression) {
        return expression.isNegated() || parameters.stream().anyMatch(p -> Objects.equals(p.getName(), expression.getName()));
    }

    private boolean parameterHandled(List<Parameter> parameters, NameValueExpression<String> expression) {
        return parameters.stream().anyMatch(input -> expression.getName().equals(input.getName()));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

