/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.util.UriUtils;
import springfox.documentation.spring.web.paths.Paths;

public class ControllerNamingUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerNamingUtils.class);
    private static final String ISO_8859_1 = "ISO-8859-1";

    private ControllerNamingUtils() {
        throw new UnsupportedOperationException();
    }

    public static String pathRoot(String requestPattern) {
        Assert.notNull((Object)requestPattern, "Request pattern is required");
        Assert.hasText(requestPattern, "Request pattern is not empty");
        LOGGER.debug("Resolving path root for {}", (Object)requestPattern);
        String adjustedPattern = requestPattern.startsWith("/") ? requestPattern : "/" + requestPattern;
        int idx = adjustedPattern.indexOf("/", 1);
        if (idx > -1) {
            return adjustedPattern.substring(0, idx);
        }
        return adjustedPattern;
    }

    public static String pathRootEncoded(String requestPattern) {
        return ControllerNamingUtils.encode(ControllerNamingUtils.pathRoot(requestPattern));
    }

    public static String encode(String path) {
        return UriUtils.encodePath((String)path, (String)ISO_8859_1);
    }

    public static String decode(String path) {
        try {
            return UriUtils.decode((String)path, (String)ISO_8859_1);
        }
        catch (Exception e) {
            LOGGER.error("Could not decode:" + path, (Throwable)e);
            return path;
        }
    }

    public static String controllerNameAsGroup(HandlerMethod handlerMethod) {
        Class controllerClass = handlerMethod.getBeanType();
        return Paths.splitCamelCase(controllerClass.getSimpleName(), "-").replace("/", "").toLowerCase();
    }
}

