/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.Tag;

public class Tags {
    private Tags() {
        throw new UnsupportedOperationException();
    }

    public static Set<Tag> toTags(Map<String, List<ApiListing>> apiListings) {
        Iterable allListings = BuilderDefaults.nullToEmptyMultimap(apiListings).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List tags = StreamSupport.stream(allListings.spliterator(), false).map(ApiListing::getTags).flatMap(tagIterable -> StreamSupport.stream(tagIterable.spliterator(), false)).collect(Collectors.toList());
        TreeSet<Tag> tagSet = new TreeSet<Tag>(Tags.tagComparator());
        tagSet.addAll(tags);
        return tagSet;
    }

    public static Comparator<Tag> tagComparator() {
        return Tags.byOrder().thenComparing(Tags.thenByName());
    }

    private static Comparator<Tag> thenByName() {
        return Comparator.comparing(Tag::getName);
    }

    private static Comparator<Tag> byOrder() {
        return Comparator.comparingInt(Tag::getOrder);
    }

    public static Function<String, Tag> toTag(Function<String, String> descriptor) {
        return input -> new Tag((String)input, (String)descriptor.apply((String)input));
    }

    public static Function<String, String> descriptor(Map<String, Tag> tagLookup, String defaultDescription) {
        return input -> Optional.ofNullable((Tag)tagLookup.get(input)).map(Tag::getDescription).orElse(defaultDescription);
    }

    public static Predicate<String> emptyTags() {
        return input -> !StringUtils.isEmpty(input);
    }
}

