/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import java.util.function.Function;
import springfox.documentation.schema.property.BeanPropertyNamingStrategy;
import springfox.documentation.schema.property.PojoPropertyBuilderFactory;

public class BeanPropertyDefinitions {
    private BeanPropertyDefinitions() {
        throw new UnsupportedOperationException();
    }

    public static Function<BeanPropertyDefinition, String> beanPropertyByInternalName() {
        return new Function<BeanPropertyDefinition, String>(){

            @Override
            public String apply(BeanPropertyDefinition input) {
                return input.getInternalName();
            }
        };
    }

    public static String name(BeanPropertyDefinition beanPropertyDefinition, boolean forSerialization, BeanPropertyNamingStrategy namingStrategy, String prefix) {
        String name = forSerialization ? namingStrategy.nameForSerialization(beanPropertyDefinition) : namingStrategy.nameForDeserialization(beanPropertyDefinition);
        return String.format("%s%s", prefix, name);
    }

    public static Function<PropertyNamingStrategy, String> overTheWireName(final BeanPropertyDefinition beanProperty, final MapperConfig<?> config) {
        return new Function<PropertyNamingStrategy, String>(){

            @Override
            public String apply(PropertyNamingStrategy strategy) {
                return BeanPropertyDefinitions.getName(strategy, beanProperty, config);
            }
        };
    }

    private static String getName(PropertyNamingStrategy naming, BeanPropertyDefinition beanProperty, MapperConfig<?> config) {
        PojoPropertyBuilderFactory factory2 = new PojoPropertyBuilderFactory();
        POJOPropertyBuilder prop = factory2.create(config, beanProperty);
        return naming.nameForField(config, prop.getField(), beanProperty.getName());
    }
}

