/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.plugins;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.common.Compatibility;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ReferenceModelSpecification;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.property.ModelSpecificationFactory;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.ModelBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Order(value=-2147483648)
public class PropertyDiscriminatorBasedInheritancePlugin
implements ModelBuilderPlugin {
    private final TypeResolver typeResolver;
    private final TypeNameExtractor typeNameExtractor;
    private final ModelSpecificationFactory modelSpecifications;
    private final EnumTypeDeterminer enumTypeDeterminer;

    @Autowired
    public PropertyDiscriminatorBasedInheritancePlugin(TypeResolver typeResolver, EnumTypeDeterminer enumTypeDeterminer, TypeNameExtractor typeNameExtractor, ModelSpecificationFactory modelSpecifications) {
        this.typeResolver = typeResolver;
        this.enumTypeDeterminer = enumTypeDeterminer;
        this.typeNameExtractor = typeNameExtractor;
        this.modelSpecifications = modelSpecifications;
    }

    @Override
    public void apply(ModelContext context) {
        List<Compatibility<ModelReference, ReferenceModelSpecification>> modelRefs = this.subclassReferences(context);
        if (!modelRefs.isEmpty()) {
            context.getBuilder().discriminator(this.discriminator(context)).subTypes(modelRefs.stream().filter(c -> c.getLegacy().isPresent()).map(c -> (ModelReference)c.getLegacy().get()).collect(Collectors.toList()));
            context.getModelSpecificationBuilder().compoundModel(cm -> cm.discriminator(this.discriminator(context)).subclassReferences(modelRefs.stream().filter(c -> c.getModern().isPresent()).map(c -> (ReferenceModelSpecification)c.getModern().get()).collect(Collectors.toList())));
        }
    }

    private List<Compatibility<ModelReference, ReferenceModelSpecification>> subclassReferences(ModelContext context) {
        JsonSubTypes subTypes = AnnotationUtils.getAnnotation(this.forClass(context), JsonSubTypes.class);
        ArrayList<Compatibility<ModelReference, ReferenceModelSpecification>> modelRefs = new ArrayList<Compatibility<ModelReference, ReferenceModelSpecification>>();
        if (subTypes != null) {
            for (JsonSubTypes.Type each : subTypes.value()) {
                ResolvedType resolvedSubType = this.typeResolver.resolve(each.value(), new Type[0]);
                modelRefs.add(new Compatibility<ModelReference, ReferenceModelSpecification>(ResolvedTypes.modelRefFactory(context, this.enumTypeDeterminer, this.typeNameExtractor).apply(resolvedSubType), this.modelSpecifications.create(context, resolvedSubType).getReference().orElse(null)));
            }
        }
        return modelRefs;
    }

    private String discriminator(ModelContext context) {
        JsonTypeInfo typeInfo = AnnotationUtils.getAnnotation(this.forClass(context), JsonTypeInfo.class);
        if (typeInfo != null && typeInfo.use() == JsonTypeInfo.Id.NAME && typeInfo.include() == JsonTypeInfo.As.PROPERTY) {
            return Optional.ofNullable(typeInfo.property()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(typeInfo.use().getDefaultPropertyName());
        }
        return "";
    }

    private Class<?> forClass(ModelContext context) {
        return this.typeResolver.resolve(context.getType(), new Type[0]).getErasedType();
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

