/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.ModelDependencyProvider;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.ModelSpecificationProvider;
import springfox.documentation.schema.PropertySpecification;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.ScalarTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.schema.property.ModelPropertiesProvider;
import springfox.documentation.schema.property.ModelSpecificationFactory;
import springfox.documentation.schema.property.PackageNames;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Qualifier(value="default")
public class DefaultModelSpecificationProvider
implements ModelSpecificationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultModelSpecificationProvider.class);
    private final TypeResolver resolver;
    private final ModelPropertiesProvider propertiesProvider;
    private final ModelDependencyProvider dependencyProvider;
    private final SchemaPluginsManager schemaPluginsManager;
    private final TypeNameExtractor typeNameExtractor;
    private final EnumTypeDeterminer enumTypeDeterminer;
    private final ModelSpecificationFactory modelSpecifications;

    @Autowired
    public DefaultModelSpecificationProvider(TypeResolver resolver, @Qualifier(value="cachedModelProperties") ModelPropertiesProvider propertiesProvider, @Qualifier(value="cachedModelDependencies") ModelDependencyProvider dependencyProvider, SchemaPluginsManager schemaPluginsManager, TypeNameExtractor typeNameExtractor, EnumTypeDeterminer enumTypeDeterminer, ModelSpecificationFactory modelSpecifications) {
        this.resolver = resolver;
        this.propertiesProvider = propertiesProvider;
        this.dependencyProvider = dependencyProvider;
        this.schemaPluginsManager = schemaPluginsManager;
        this.typeNameExtractor = typeNameExtractor;
        this.enumTypeDeterminer = enumTypeDeterminer;
        this.modelSpecifications = modelSpecifications;
    }

    @Override
    public Optional<ModelSpecification> modelSpecificationsFor(ModelContext modelContext) {
        ResolvedType propertiesHost = modelContext.alternateEvaluatedType();
        if (Collections.isContainerType(propertiesHost) || Maps.isMapType(propertiesHost) || this.enumTypeDeterminer.isEnum(propertiesHost.getErasedType()) || ScalarTypes.builtInScalarType(propertiesHost).isPresent() || modelContext.hasSeenBefore(propertiesHost)) {
            LOG.debug("Skipping model of type {} as its either a container type, map, enum or base type, or its already been handled", (Object)ResolvedTypes.resolvedTypeSignature(propertiesHost).orElse("<null>"));
            return Optional.empty();
        }
        Optional<ModelSpecification> syntheticModel = this.schemaPluginsManager.syntheticModelSpecification(modelContext);
        if (syntheticModel.isPresent()) {
            return Optional.of(this.schemaPluginsManager.modelSpecification(modelContext));
        }
        return this.reflectionBasedModel(modelContext, propertiesHost);
    }

    private Optional<ModelSpecification> reflectionBasedModel(ModelContext modelContext, ResolvedType propertiesHost) {
        Map propertiesIndex = this.properties(modelContext, propertiesHost).stream().collect(Collectors.toMap(PropertySpecification::getName, Function.identity()));
        LOG.debug("Inferred {} properties. Properties found {}", (Object)propertiesIndex.size(), (Object)String.join((CharSequence)", ", propertiesIndex.keySet()));
        return Optional.of(this.modelBuilder(propertiesHost, new TreeMap<String, PropertySpecification>(propertiesIndex), modelContext));
    }

    private ModelSpecification modelBuilder(ResolvedType propertiesHost, Map<String, PropertySpecification> properties, ModelContext modelContext) {
        String typeName = this.typeNameExtractor.typeName(ModelContext.fromParent(modelContext, propertiesHost));
        modelContext.getModelSpecificationBuilder().name(typeName).compoundModel(cm -> cm.modelKey(m3 -> m3.qualifiedModelName(q -> q.namespace(PackageNames.safeGetPackageName(propertiesHost)).name(typeName)).viewDiscriminator(modelContext.getView().orElse(null)).validationGroupDiscriminators(modelContext.getValidationGroups()).isResponse(modelContext.isReturnType()).build()).properties(properties.values()));
        return this.schemaPluginsManager.modelSpecification(modelContext);
    }

    @Override
    public Set<ModelSpecification> modelDependenciesSpecifications(ModelContext modelContext) {
        HashSet<ModelSpecification> models = new HashSet<ModelSpecification>();
        for (ResolvedType resolvedType : this.dependencyProvider.dependentModels(modelContext)) {
            ModelContext parentContext = ModelContext.fromParent(modelContext, resolvedType);
            Optional<ModelSpecification> model = this.modelSpecificationsFor(parentContext);
            if (model.isPresent()) {
                models.add(model.get());
                continue;
            }
            this.mapModel(parentContext, resolvedType).ifPresent(models::add);
        }
        return models;
    }

    private Optional<ModelSpecification> mapModel(ModelContext mapContext, ResolvedType resolvedType) {
        if (Maps.isMapType(resolvedType) && !mapContext.hasSeenBefore(resolvedType)) {
            ResolvedType keyType = this.resolver.resolve((Type)((Object)String.class), new Type[0]);
            ModelContext keyContext = ModelContext.fromParent(mapContext, keyType);
            ResolvedType valueType = Maps.mapValueType(resolvedType);
            ModelContext valueContext = ModelContext.fromParent(mapContext, valueType);
            return Optional.of(mapContext.getModelSpecificationBuilder().mapModel(m3 -> m3.key(k -> k.copyOf(this.modelSpecifications.create(keyContext, keyType))).value(v -> v.copyOf(this.modelSpecifications.create(valueContext, valueType)))).build());
        }
        return Optional.empty();
    }

    private List<PropertySpecification> properties(ModelContext context, ResolvedType propertiesHost) {
        String typeName = this.typeNameExtractor.typeName(context);
        return this.propertiesProvider.propertySpecificationsFor(propertiesHost, context);
    }
}

