/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;
import springfox.documentation.builders.ModelSpecificationBuilder;
import springfox.documentation.builders.ParameterSpecificationContext;
import springfox.documentation.builders.ParameterSpecificationProvider;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.service.ContentSpecification;
import springfox.documentation.service.Encoding;
import springfox.documentation.service.ParameterSpecification;
import springfox.documentation.service.ParameterStyle;
import springfox.documentation.service.Representation;
import springfox.documentation.service.SimpleParameterSpecification;

public class FormParameterSpecificationProvider
implements ParameterSpecificationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormParameterSpecificationProvider.class);

    @Override
    public ParameterSpecification create(ParameterSpecificationContext context) {
        ContentSpecification contentSpecification;
        SimpleParameterSpecification simpleParameter = context.getSimpleParameter();
        ContentSpecification contentParameter = context.getContentParameter();
        MediaType mediaType = MediaType.ALL;
        if (this.supportsFormUrlEncoding(context) || this.noMediaTypeSpecified(context)) {
            mediaType = MediaType.APPLICATION_FORM_URLENCODED;
        } else if (this.supportsMultipartFormData(context)) {
            mediaType = MediaType.MULTIPART_FORM_DATA;
        }
        if (simpleParameter != null && simpleParameter.getModel() != null) {
            MediaType finalMediaType = mediaType;
            contentSpecification = context.getContentSpecificationBuilder().requestBody(true).representation(mediaType).apply(r -> {
                r.model(m3 -> m3.copyOf(simpleParameter.getModel()));
                if (finalMediaType == MediaType.APPLICATION_FORM_URLENCODED) {
                    r.clearEncodings();
                } else {
                    r.encoding(context.getName()).apply(e -> e.contentType("text/plain").style(ParameterStyle.SIMPLE));
                }
            }).build();
        } else if (contentParameter != null) {
            Representation representation = contentParameter.representationFor(mediaType).orElse(contentParameter.representationFor(MediaType.ALL).orElse(null));
            if (representation == null) {
                ModelSpecification model = new ModelSpecificationBuilder().name(context.getName()).scalarModel(ScalarType.STRING).build();
                contentSpecification = context.getContentSpecificationBuilder().requestBody(true).representation(mediaType).apply(r -> r.model(m3 -> m3.copyOf(model)).clearEncodings()).build();
            } else {
                ModelSpecification model = representation.getModel();
                Collection<Encoding> encodings = representation.getEncodings();
                contentSpecification = context.getContentSpecificationBuilder().requestBody(true).representation(mediaType).apply(r -> {
                    r.model(m3 -> m3.copyOf(model));
                    encodings.forEach(each -> r.encoding(each.getPropertyRef()).apply(e -> e.copyOf((Encoding)each)));
                }).build();
            }
        } else {
            LOGGER.warn("Parameter should either be a simple or a content type");
            contentSpecification = context.getContentSpecificationBuilder().representation(mediaType).apply(r -> r.model(m3 -> m3.copyOf(new ModelSpecificationBuilder().name(context.getName()).scalarModel(ScalarType.STRING).build())).clearEncodings()).build();
        }
        return new ParameterSpecification(null, contentSpecification);
    }

    private boolean noMediaTypeSpecified(ParameterSpecificationContext context) {
        return context.getAccepts().isEmpty();
    }

    private boolean supportsFormUrlEncoding(ParameterSpecificationContext context) {
        return context.getAccepts().stream().anyMatch(mediaType -> mediaType.equalsTypeAndSubtype((MimeType)MediaType.APPLICATION_FORM_URLENCODED));
    }

    private boolean supportsMultipartFormData(ParameterSpecificationContext context) {
        return context.getAccepts().stream().anyMatch(mediaType -> mediaType.equalsTypeAndSubtype((MimeType)MediaType.MULTIPART_FORM_DATA) || mediaType.equals((Object)MediaType.MULTIPART_MIXED));
    }
}

