/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.CountingOutputStream;
import org.tukaani.xz.FilterEncoder;
import org.tukaani.xz.FinishableOutputStream;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZIOException;
import org.tukaani.xz.check.Check;
import org.tukaani.xz.common.EncoderUtil;

class BlockOutputStream
extends FinishableOutputStream {
    private final OutputStream out;
    private final CountingOutputStream outCounted;
    private FinishableOutputStream filterChain;
    private final Check check;
    private final int headerSize;
    private final long compressedSizeLimit;
    private long uncompressedSize = 0L;
    private final byte[] tempBuf = new byte[1];

    public BlockOutputStream(OutputStream outputStream2, FilterEncoder[] filterEncoderArray, Check check2, ArrayCache arrayCache) throws IOException {
        this.out = outputStream2;
        this.check = check2;
        this.outCounted = new CountingOutputStream(outputStream2);
        this.filterChain = this.outCounted;
        for (int j = filterEncoderArray.length - 1; j >= 0; --j) {
            this.filterChain = filterEncoderArray[j].getOutputStream(this.filterChain, arrayCache);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(filterEncoderArray.length - 1);
        for (int j = 0; j < filterEncoderArray.length; ++j) {
            EncoderUtil.encodeVLI(byteArrayOutputStream, filterEncoderArray[j].getFilterID());
            byte[] byArray = filterEncoderArray[j].getFilterProps();
            EncoderUtil.encodeVLI(byteArrayOutputStream, byArray.length);
            byteArrayOutputStream.write(byArray);
        }
        while ((byteArrayOutputStream.size() & 3) != 0) {
            byteArrayOutputStream.write(0);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.headerSize = byArray.length + 4;
        if (this.headerSize > 1024) {
            throw new UnsupportedOptionsException();
        }
        byArray[0] = (byte)(byArray.length / 4);
        outputStream2.write(byArray);
        EncoderUtil.writeCRC32(outputStream2, byArray);
        this.compressedSizeLimit = 0x7FFFFFFFFFFFFFFCL - (long)this.headerSize - (long)check2.getSize();
    }

    @Override
    public void write(int n) throws IOException {
        this.tempBuf[0] = (byte)n;
        this.write(this.tempBuf, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.filterChain.write(byArray, n, n2);
        this.check.update(byArray, n, n2);
        this.uncompressedSize += (long)n2;
        this.validate();
    }

    @Override
    public void flush() throws IOException {
        this.filterChain.flush();
        this.validate();
    }

    @Override
    public void finish() throws IOException {
        this.filterChain.finish();
        this.validate();
        long l = this.outCounted.getSize();
        while ((l & 3L) != 0L) {
            this.out.write(0);
            ++l;
        }
        this.out.write(this.check.finish());
    }

    private void validate() throws IOException {
        long l = this.outCounted.getSize();
        if (l < 0L || l > this.compressedSizeLimit || this.uncompressedSize < 0L) {
            throw new XZIOException("XZ Stream has grown too big");
        }
    }

    public long getUnpaddedSize() {
        return (long)this.headerSize + this.outCounted.getSize() + (long)this.check.getSize();
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }
}

