/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.rsocket.context;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.rsocket.context.RSocketServerInitializedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class RSocketPortInfoApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext applicationContext) {
        applicationContext.addApplicationListener((ApplicationListener)new Listener(applicationContext));
    }

    private static class Listener
    implements ApplicationListener<RSocketServerInitializedEvent> {
        private static final String PROPERTY_NAME = "local.rsocket.server.port";
        private final ConfigurableApplicationContext applicationContext;

        Listener(ConfigurableApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        public void onApplicationEvent(RSocketServerInitializedEvent event) {
            if (event.getServer().address() != null) {
                this.setPortProperty((ApplicationContext)this.applicationContext, event.getServer().address().getPort());
            }
        }

        private void setPortProperty(ApplicationContext context, int port) {
            if (context instanceof ConfigurableApplicationContext) {
                this.setPortProperty(((ConfigurableApplicationContext)context).getEnvironment(), port);
            }
            if (context.getParent() != null) {
                this.setPortProperty(context.getParent(), port);
            }
        }

        private void setPortProperty(ConfigurableEnvironment environment, int port) {
            MutablePropertySources sources = environment.getPropertySources();
            MapPropertySource source2 = sources.get("server.ports");
            if (source2 == null) {
                source2 = new MapPropertySource("server.ports", (Map<String, Object>)new HashMap<String, Object>());
                sources.addFirst(source2);
            }
            this.setPortProperty(port, source2);
        }

        private void setPortProperty(int port, PropertySource<?> source2) {
            ((Map)source2.getSource()).put(PROPERTY_NAME, port);
        }
    }
}

