/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.diagnostics;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.SpringBootExceptionReporter;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.boot.diagnostics.FailureAnalysisReporter;
import org.springframework.boot.diagnostics.FailureAnalyzer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.log.LogMessage;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

final class FailureAnalyzers
implements SpringBootExceptionReporter {
    private static final Log logger = LogFactory.getLog(FailureAnalyzers.class);
    private final ClassLoader classLoader;
    private final List<FailureAnalyzer> analyzers;

    FailureAnalyzers(ConfigurableApplicationContext context) {
        this(context, null);
    }

    FailureAnalyzers(ConfigurableApplicationContext context, ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : this.getClassLoader(context);
        this.analyzers = this.loadFailureAnalyzers(context, this.classLoader);
    }

    private ClassLoader getClassLoader(ConfigurableApplicationContext context) {
        return context != null ? context.getClassLoader() : null;
    }

    private List<FailureAnalyzer> loadFailureAnalyzers(ConfigurableApplicationContext context, ClassLoader classLoader) {
        List<String> classNames = SpringFactoriesLoader.loadFactoryNames(FailureAnalyzer.class, classLoader);
        ArrayList<FailureAnalyzer> analyzers = new ArrayList<FailureAnalyzer>();
        for (String className : classNames) {
            try {
                FailureAnalyzer analyzer = this.createAnalyzer(context, className);
                if (analyzer == null) continue;
                analyzers.add(analyzer);
            }
            catch (Throwable ex) {
                logger.trace(LogMessage.format("Failed to load %s", (Object)className), ex);
            }
        }
        AnnotationAwareOrderComparator.sort(analyzers);
        return analyzers;
    }

    private FailureAnalyzer createAnalyzer(ConfigurableApplicationContext context, String className) throws Exception {
        Constructor<?> constructor = ClassUtils.forName(className, this.classLoader).getDeclaredConstructor(new Class[0]);
        ReflectionUtils.makeAccessible(constructor);
        FailureAnalyzer analyzer = (FailureAnalyzer)constructor.newInstance(new Object[0]);
        if (analyzer instanceof BeanFactoryAware || analyzer instanceof EnvironmentAware) {
            if (context == null) {
                logger.trace(LogMessage.format("Skipping %s due to missing context", (Object)className));
                return null;
            }
            if (analyzer instanceof BeanFactoryAware) {
                ((BeanFactoryAware)((Object)analyzer)).setBeanFactory(context.getBeanFactory());
            }
            if (analyzer instanceof EnvironmentAware) {
                ((EnvironmentAware)analyzer).setEnvironment((Environment)context.getEnvironment());
            }
        }
        return analyzer;
    }

    @Override
    public boolean reportException(Throwable failure) {
        FailureAnalysis analysis = this.analyze(failure, this.analyzers);
        return this.report(analysis, this.classLoader);
    }

    private FailureAnalysis analyze(Throwable failure, List<FailureAnalyzer> analyzers) {
        for (FailureAnalyzer analyzer : analyzers) {
            try {
                FailureAnalysis analysis = analyzer.analyze(failure);
                if (analysis == null) continue;
                return analysis;
            }
            catch (Throwable ex) {
                logger.trace(LogMessage.format("FailureAnalyzer %s failed", (Object)analyzer), ex);
            }
        }
        return null;
    }

    private boolean report(FailureAnalysis analysis, ClassLoader classLoader) {
        List<FailureAnalysisReporter> reporters = SpringFactoriesLoader.loadFactories(FailureAnalysisReporter.class, classLoader);
        if (analysis == null || reporters.isEmpty()) {
            return false;
        }
        for (FailureAnalysisReporter reporter : reporters) {
            reporter.report(analysis);
        }
        return true;
    }
}

