/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.web.ConditionalOnEnabledResourceChain;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;

class OnEnabledResourceChainCondition
extends SpringBootCondition {
    private static final String WEBJAR_ASSET_LOCATOR = "org.webjars.WebJarAssetLocator";

    OnEnabledResourceChainCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConfigurableEnvironment environment = (ConfigurableEnvironment)context.getEnvironment();
        String prefix = this.determineResourcePropertiesPrefix(environment);
        boolean fixed = this.getEnabledProperty(environment, prefix, "strategy.fixed.", false);
        boolean content = this.getEnabledProperty(environment, prefix, "strategy.content.", false);
        Boolean chain = this.getEnabledProperty(environment, prefix, "", null);
        Boolean match = WebProperties.Resources.Chain.getEnabled(fixed, content, chain);
        ConditionMessage.Builder message = ConditionMessage.forCondition(ConditionalOnEnabledResourceChain.class, new Object[0]);
        if (match == null) {
            if (ClassUtils.isPresent(WEBJAR_ASSET_LOCATOR, this.getClass().getClassLoader())) {
                return ConditionOutcome.match(message.found("class").items(WEBJAR_ASSET_LOCATOR));
            }
            return ConditionOutcome.noMatch(message.didNotFind("class").items(WEBJAR_ASSET_LOCATOR));
        }
        if (match.booleanValue()) {
            return ConditionOutcome.match(message.because("enabled"));
        }
        return ConditionOutcome.noMatch(message.because("disabled"));
    }

    private String determineResourcePropertiesPrefix(Environment environment) {
        BindResult<ResourceProperties> result = Binder.get(environment).bind("spring.resources", ResourceProperties.class);
        if (result.isBound() && result.get().hasBeenCustomized()) {
            return "spring.resources.chain.";
        }
        return "spring.web.resources.chain.";
    }

    private Boolean getEnabledProperty(ConfigurableEnvironment environment, String prefix, String key, Boolean defaultValue) {
        String name = prefix + key + "enabled";
        return environment.getProperty(name, Boolean.class, defaultValue);
    }
}

