/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.ldap;

import java.util.Collections;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.ldap.LdapProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.DirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.LdapContextSource;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ContextSource.class})
@EnableConfigurationProperties(value={LdapProperties.class})
public class LdapAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public LdapContextSource ldapContextSource(LdapProperties properties, Environment environment, ObjectProvider<DirContextAuthenticationStrategy> dirContextAuthenticationStrategy) {
        LdapContextSource source2 = new LdapContextSource();
        dirContextAuthenticationStrategy.ifUnique(arg_0 -> ((LdapContextSource)source2).setAuthenticationStrategy(arg_0));
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        propertyMapper.from(properties.getUsername()).to(arg_0 -> ((LdapContextSource)source2).setUserDn(arg_0));
        propertyMapper.from(properties.getPassword()).to(arg_0 -> ((LdapContextSource)source2).setPassword(arg_0));
        propertyMapper.from(properties.getAnonymousReadOnly()).to(arg_0 -> ((LdapContextSource)source2).setAnonymousReadOnly(arg_0));
        propertyMapper.from(properties.getBase()).to(arg_0 -> ((LdapContextSource)source2).setBase(arg_0));
        propertyMapper.from(properties.determineUrls(environment)).to(arg_0 -> ((LdapContextSource)source2).setUrls(arg_0));
        propertyMapper.from(properties.getBaseEnvironment()).to(baseEnvironment -> source2.setBaseEnvironmentProperties(Collections.unmodifiableMap(baseEnvironment)));
        return source2;
    }

    @Bean
    @ConditionalOnMissingBean(value={LdapOperations.class})
    public LdapTemplate ldapTemplate(LdapProperties properties, ContextSource contextSource) {
        LdapProperties.Template template = properties.getTemplate();
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        LdapTemplate ldapTemplate = new LdapTemplate(contextSource);
        propertyMapper.from(template.isIgnorePartialResultException()).to(arg_0 -> ((LdapTemplate)ldapTemplate).setIgnorePartialResultException(arg_0));
        propertyMapper.from(template.isIgnoreNameNotFoundException()).to(arg_0 -> ((LdapTemplate)ldapTemplate).setIgnoreNameNotFoundException(arg_0));
        propertyMapper.from(template.isIgnoreSizeLimitExceededException()).to(arg_0 -> ((LdapTemplate)ldapTemplate).setIgnoreSizeLimitExceededException(arg_0));
        return ldapTemplate;
    }
}

