/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms;

import java.time.Duration;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.Assert;

public final class DefaultJmsListenerContainerFactoryConfigurer {
    private DestinationResolver destinationResolver;
    private MessageConverter messageConverter;
    private ExceptionListener exceptionListener;
    private JtaTransactionManager transactionManager;
    private JmsProperties jmsProperties;

    void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    void setTransactionManager(JtaTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    void setJmsProperties(JmsProperties jmsProperties) {
        this.jmsProperties = jmsProperties;
    }

    public void configure(DefaultJmsListenerContainerFactory factory2, ConnectionFactory connectionFactory) {
        Duration receiveTimeout;
        String concurrency;
        Assert.notNull((Object)factory2, "Factory must not be null");
        Assert.notNull((Object)connectionFactory, "ConnectionFactory must not be null");
        factory2.setConnectionFactory(connectionFactory);
        factory2.setPubSubDomain(Boolean.valueOf(this.jmsProperties.isPubSubDomain()));
        if (this.transactionManager != null) {
            factory2.setTransactionManager((PlatformTransactionManager)this.transactionManager);
        } else {
            factory2.setSessionTransacted(Boolean.valueOf(true));
        }
        if (this.destinationResolver != null) {
            factory2.setDestinationResolver(this.destinationResolver);
        }
        if (this.messageConverter != null) {
            factory2.setMessageConverter(this.messageConverter);
        }
        if (this.exceptionListener != null) {
            factory2.setExceptionListener(this.exceptionListener);
        }
        JmsProperties.Listener listener = this.jmsProperties.getListener();
        factory2.setAutoStartup(listener.isAutoStartup());
        if (listener.getAcknowledgeMode() != null) {
            factory2.setSessionAcknowledgeMode(Integer.valueOf(listener.getAcknowledgeMode().getMode()));
        }
        if ((concurrency = listener.formatConcurrency()) != null) {
            factory2.setConcurrency(concurrency);
        }
        if ((receiveTimeout = listener.getReceiveTimeout()) != null) {
            factory2.setReceiveTimeout(Long.valueOf(receiveTimeout.toMillis()));
        }
    }
}

