/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.impl.CredentialsProvider;
import com.rabbitmq.client.impl.CredentialsRefreshService;
import java.time.Duration;
import java.util.stream.Collectors;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitMessagingTemplate;
import org.springframework.amqp.rabbit.core.RabbitOperations;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.amqp.ConnectionFactoryCustomizer;
import org.springframework.boot.autoconfigure.amqp.RabbitAnnotationDrivenConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.amqp.RabbitRetryTemplateCustomizer;
import org.springframework.boot.autoconfigure.amqp.RabbitTemplateConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ResourceLoader;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RabbitTemplate.class, Channel.class})
@EnableConfigurationProperties(value={RabbitProperties.class})
@Import(value={RabbitAnnotationDrivenConfiguration.class})
public class RabbitAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RabbitMessagingTemplate.class})
    @ConditionalOnMissingBean(value={RabbitMessagingTemplate.class})
    @Import(value={RabbitTemplateConfiguration.class})
    protected static class MessagingTemplateConfiguration {
        protected MessagingTemplateConfiguration() {
        }

        @Bean
        @ConditionalOnSingleCandidate(value=RabbitTemplate.class)
        public RabbitMessagingTemplate rabbitMessagingTemplate(RabbitTemplate rabbitTemplate) {
            return new RabbitMessagingTemplate(rabbitTemplate);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={RabbitConnectionFactoryCreator.class})
    protected static class RabbitTemplateConfiguration {
        protected RabbitTemplateConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RabbitTemplateConfigurer rabbitTemplateConfigurer(RabbitProperties properties, ObjectProvider<MessageConverter> messageConverter, ObjectProvider<RabbitRetryTemplateCustomizer> retryTemplateCustomizers) {
            RabbitTemplateConfigurer configurer = new RabbitTemplateConfigurer();
            configurer.setMessageConverter(messageConverter.getIfUnique());
            configurer.setRetryTemplateCustomizers(retryTemplateCustomizers.orderedStream().collect(Collectors.toList()));
            configurer.setRabbitProperties(properties);
            return configurer;
        }

        @Bean
        @ConditionalOnSingleCandidate(value=org.springframework.amqp.rabbit.connection.ConnectionFactory.class)
        @ConditionalOnMissingBean(value={RabbitOperations.class})
        public RabbitTemplate rabbitTemplate(RabbitTemplateConfigurer configurer, org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
            RabbitTemplate template = new RabbitTemplate();
            configurer.configure(template, connectionFactory);
            return template;
        }

        @Bean
        @ConditionalOnSingleCandidate(value=org.springframework.amqp.rabbit.connection.ConnectionFactory.class)
        @ConditionalOnProperty(prefix="spring.rabbitmq", name={"dynamic"}, matchIfMissing=true)
        @ConditionalOnMissingBean
        public AmqpAdmin amqpAdmin(org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
            return new RabbitAdmin(connectionFactory);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={org.springframework.amqp.rabbit.connection.ConnectionFactory.class})
    protected static class RabbitConnectionFactoryCreator {
        protected RabbitConnectionFactoryCreator() {
        }

        @Bean
        public CachingConnectionFactory rabbitConnectionFactory(RabbitProperties properties, ResourceLoader resourceLoader, ObjectProvider<CredentialsProvider> credentialsProvider, ObjectProvider<CredentialsRefreshService> credentialsRefreshService, ObjectProvider<ConnectionNameStrategy> connectionNameStrategy, ObjectProvider<ConnectionFactoryCustomizer> connectionFactoryCustomizers) throws Exception {
            ConnectionFactory connectionFactory = (ConnectionFactory)this.getRabbitConnectionFactoryBean(properties, resourceLoader, credentialsProvider, credentialsRefreshService).getObject();
            connectionFactoryCustomizers.orderedStream().forEach(customizer -> customizer.customize(connectionFactory));
            CachingConnectionFactory factory2 = new CachingConnectionFactory(connectionFactory);
            PropertyMapper map = PropertyMapper.get();
            map.from(properties::determineAddresses).to(arg_0 -> ((CachingConnectionFactory)factory2).setAddresses(arg_0));
            map.from(properties::getAddressShuffleMode).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory2).setAddressShuffleMode(arg_0));
            map.from(properties::isPublisherReturns).to(arg_0 -> ((CachingConnectionFactory)factory2).setPublisherReturns(arg_0));
            map.from(properties::getPublisherConfirmType).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory2).setPublisherConfirmType(arg_0));
            RabbitProperties.Cache.Channel channel = properties.getCache().getChannel();
            map.from(channel::getSize).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory2).setChannelCacheSize(arg_0));
            map.from(channel::getCheckoutTimeout).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((CachingConnectionFactory)factory2).setChannelCheckoutTimeout(arg_0));
            RabbitProperties.Cache.Connection connection = properties.getCache().getConnection();
            map.from(connection::getMode).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory2).setCacheMode(arg_0));
            map.from(connection::getSize).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory2).setConnectionCacheSize(arg_0));
            map.from(connectionNameStrategy::getIfUnique).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory2).setConnectionNameStrategy(arg_0));
            return factory2;
        }

        private RabbitConnectionFactoryBean getRabbitConnectionFactoryBean(RabbitProperties properties, ResourceLoader resourceLoader, ObjectProvider<CredentialsProvider> credentialsProvider, ObjectProvider<CredentialsRefreshService> credentialsRefreshService) {
            RabbitConnectionFactoryBean factory2 = new RabbitConnectionFactoryBean();
            factory2.setResourceLoader(resourceLoader);
            PropertyMapper map = PropertyMapper.get();
            map.from(properties::determineHost).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setHost(arg_0));
            map.from(properties::determinePort).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setPort(arg_0));
            map.from(properties::determineUsername).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setUsername(arg_0));
            map.from(properties::determinePassword).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setPassword(arg_0));
            map.from(properties::determineVirtualHost).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setVirtualHost(arg_0));
            map.from(properties::getRequestedHeartbeat).whenNonNull().asInt(Duration::getSeconds).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setRequestedHeartbeat(arg_0));
            map.from(properties::getRequestedChannelMax).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setRequestedChannelMax(arg_0));
            RabbitProperties.Ssl ssl = properties.getSsl();
            if (ssl.determineEnabled()) {
                factory2.setUseSSL(true);
                map.from(ssl::getAlgorithm).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setSslAlgorithm(arg_0));
                map.from(ssl::getKeyStoreType).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setKeyStoreType(arg_0));
                map.from(ssl::getKeyStore).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setKeyStore(arg_0));
                map.from(ssl::getKeyStorePassword).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setKeyStorePassphrase(arg_0));
                map.from(ssl::getKeyStoreAlgorithm).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setKeyStoreAlgorithm(arg_0));
                map.from(ssl::getTrustStoreType).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setTrustStoreType(arg_0));
                map.from(ssl::getTrustStore).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setTrustStore(arg_0));
                map.from(ssl::getTrustStorePassword).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setTrustStorePassphrase(arg_0));
                map.from(ssl::getTrustStoreAlgorithm).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setTrustStoreAlgorithm(arg_0));
                map.from(ssl::isValidateServerCertificate).to(validate -> factory2.setSkipServerCertificateValidation(validate == false));
                map.from(ssl::getVerifyHostname).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setEnableHostnameVerification(arg_0));
            }
            map.from(properties::getConnectionTimeout).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setConnectionTimeout(arg_0));
            map.from(properties::getChannelRpcTimeout).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setChannelRpcTimeout(arg_0));
            map.from(credentialsProvider::getIfUnique).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setCredentialsProvider(arg_0));
            map.from(credentialsRefreshService::getIfUnique).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setCredentialsRefreshService(arg_0));
            factory2.afterPropertiesSet();
            return factory2;
        }
    }
}

