/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.build.incremental;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.EmptyScanner;

public class DefaultBuildContext
extends AbstractLogEnabled
implements BuildContext {
    public boolean hasDelta(String relpath) {
        return true;
    }

    public boolean hasDelta(File file) {
        return true;
    }

    public boolean hasDelta(List relpaths) {
        return true;
    }

    public OutputStream newFileOutputStream(File file) throws IOException {
        return new FileOutputStream(file);
    }

    public Scanner newScanner(File basedir) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(basedir);
        return ds;
    }

    public void refresh(File file) {
    }

    public Scanner newDeleteScanner(File basedir) {
        return new EmptyScanner(basedir);
    }

    public Scanner newScanner(File basedir, boolean ignoreDelta) {
        return this.newScanner(basedir);
    }

    public boolean isIncremental() {
        return false;
    }

    public Object getValue(String key) {
        return null;
    }

    public void setValue(String key, Object value) {
    }

    private String getMessage(File file, int line, int column, String message) {
        StringBuffer sb = new StringBuffer();
        sb.append(file.getAbsolutePath()).append(" [").append(line).append(':').append(column).append("]: ");
        sb.append(message);
        return sb.toString();
    }

    public void addError(File file, int line, int column, String message, Throwable cause) {
        this.addMessage(file, line, column, message, 2, cause);
    }

    public void addWarning(File file, int line, int column, String message, Throwable cause) {
        this.addMessage(file, line, column, message, 1, cause);
    }

    public void addMessage(File file, int line, int column, String message, int severity, Throwable cause) {
        switch (severity) {
            case 2: {
                this.getLogger().error(this.getMessage(file, line, column, message), cause);
                return;
            }
            case 1: {
                this.getLogger().warn(this.getMessage(file, line, column, message), cause);
                return;
            }
        }
        throw new IllegalArgumentException("severity=" + severity);
    }

    public void removeMessages(File file) {
    }

    public boolean isUptodate(File target, File source2) {
        return target != null && target.exists() && source2 != null && source2.exists() && target.lastModified() > source2.lastModified();
    }
}

