/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.snappy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.iq80.snappy.SnappyInputStream;
import org.iq80.snappy.SnappyOutputStream;

public class HadoopSnappyCodec
implements CompressionCodec {
    public CompressionOutputStream createOutputStream(OutputStream outputStream2) throws IOException {
        return new SnappyCompressionOutputStream(outputStream2);
    }

    public CompressionOutputStream createOutputStream(OutputStream outputStream2, Compressor compressor) throws IOException {
        throw new UnsupportedOperationException("Snappy Compressor is not supported");
    }

    public Class<? extends Compressor> getCompressorType() {
        throw new UnsupportedOperationException("Snappy Compressor is not supported");
    }

    public Compressor createCompressor() {
        throw new UnsupportedOperationException("Snappy Compressor is not supported");
    }

    public CompressionInputStream createInputStream(InputStream inputStream2) throws IOException {
        return new SnappyCompressionInputStream(inputStream2);
    }

    public CompressionInputStream createInputStream(InputStream inputStream2, Decompressor decompressor) throws IOException {
        throw new UnsupportedOperationException("Snappy Decompressor is not supported");
    }

    public Class<? extends Decompressor> getDecompressorType() {
        throw new UnsupportedOperationException("Snappy Decompressor is not supported");
    }

    public Decompressor createDecompressor() {
        throw new UnsupportedOperationException("Snappy Decompressor is not supported");
    }

    public String getDefaultExtension() {
        return ".snappy";
    }

    private static class SnappyCompressionInputStream
    extends CompressionInputStream {
        public SnappyCompressionInputStream(InputStream inputStream2) throws IOException {
            super((InputStream)new SnappyInputStream(inputStream2));
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        public void resetState() throws IOException {
            throw new UnsupportedOperationException("resetState not supported for Snappy");
        }

        public int read() throws IOException {
            return this.in.read();
        }
    }

    private static class SnappyCompressionOutputStream
    extends CompressionOutputStream {
        public SnappyCompressionOutputStream(OutputStream outputStream2) throws IOException {
            super((OutputStream)new SnappyOutputStream(outputStream2));
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void finish() throws IOException {
            this.out.flush();
        }

        public void resetState() throws IOException {
            this.out.flush();
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }
    }
}

