/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.naming.ResourceRef;

public class BeanFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws NamingException {
        if (obj instanceof ResourceRef) {
            try {
                String value;
                Reference ref = (Reference)obj;
                String beanClassName = ref.getClassName();
                Class<?> beanClass = null;
                ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                if (tcl != null) {
                    try {
                        beanClass = tcl.loadClass(beanClassName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                } else {
                    try {
                        beanClass = Class.forName(beanClassName);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                if (beanClass == null) {
                    throw new NamingException("Class not found: " + beanClassName);
                }
                BeanInfo bi = Introspector.getBeanInfo(beanClass);
                PropertyDescriptor[] pda = bi.getPropertyDescriptors();
                Object bean = beanClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                RefAddr ra = ref.get("forceString");
                HashMap<String, Method> forced = new HashMap<String, Method>();
                if (ra != null) {
                    value = (String)ra.getContent();
                    Class[] paramTypes = new Class[]{String.class};
                    for (String param : value.split(",")) {
                        String setterName;
                        int index = (param = param.trim()).indexOf(61);
                        if (index >= 0) {
                            setterName = param.substring(index + 1).trim();
                            param = param.substring(0, index).trim();
                        } else {
                            setterName = "set" + param.substring(0, 1).toUpperCase(Locale.ENGLISH) + param.substring(1);
                        }
                        try {
                            forced.put(param, beanClass.getMethod(setterName, paramTypes));
                        }
                        catch (NoSuchMethodException | SecurityException ex) {
                            throw new NamingException("Forced String setter " + setterName + " not found for property " + param);
                        }
                    }
                }
                Enumeration<RefAddr> e = ref.getAll();
                while (e.hasMoreElements()) {
                    ra = e.nextElement();
                    String propName = ra.getType();
                    if (propName.equals("factory") || propName.equals("scope") || propName.equals("auth") || propName.equals("forceString") || propName.equals("singleton")) continue;
                    value = (String)ra.getContent();
                    Object[] valueArray = new Object[1];
                    Method method = (Method)forced.get(propName);
                    if (method != null) {
                        valueArray[0] = value;
                        try {
                            method.invoke(bean, valueArray);
                            continue;
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                            throw new NamingException("Forced String setter " + method.getName() + " threw exception for property " + propName);
                        }
                    }
                    int i2 = 0;
                    for (i2 = 0; i2 < pda.length; ++i2) {
                        if (!pda[i2].getName().equals(propName)) continue;
                        Class<?> propType = pda[i2].getPropertyType();
                        if (propType.equals(String.class)) {
                            valueArray[0] = value;
                        } else if (propType.equals(Character.class) || propType.equals(Character.TYPE)) {
                            valueArray[0] = Character.valueOf(value.charAt(0));
                        } else if (propType.equals(Byte.class) || propType.equals(Byte.TYPE)) {
                            valueArray[0] = Byte.valueOf(value);
                        } else if (propType.equals(Short.class) || propType.equals(Short.TYPE)) {
                            valueArray[0] = Short.valueOf(value);
                        } else if (propType.equals(Integer.class) || propType.equals(Integer.TYPE)) {
                            valueArray[0] = Integer.valueOf(value);
                        } else if (propType.equals(Long.class) || propType.equals(Long.TYPE)) {
                            valueArray[0] = Long.valueOf(value);
                        } else if (propType.equals(Float.class) || propType.equals(Float.TYPE)) {
                            valueArray[0] = Float.valueOf(value);
                        } else if (propType.equals(Double.class) || propType.equals(Double.TYPE)) {
                            valueArray[0] = Double.valueOf(value);
                        } else if (propType.equals(Boolean.class) || propType.equals(Boolean.TYPE)) {
                            valueArray[0] = Boolean.valueOf(value);
                        } else {
                            throw new NamingException("String conversion for property " + propName + " of type '" + propType.getName() + "' not available");
                        }
                        Method setProp = pda[i2].getWriteMethod();
                        if (setProp != null) {
                            setProp.invoke(bean, valueArray);
                            break;
                        }
                        throw new NamingException("Write not allowed for property: " + propName);
                    }
                    if (i2 != pda.length) continue;
                    throw new NamingException("No set method found for property: " + propName);
                }
                return bean;
            }
            catch (IntrospectionException ie) {
                NamingException ne = new NamingException(ie.getMessage());
                ne.setRootCause(ie);
                throw ne;
            }
            catch (ReflectiveOperationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ThreadDeath) {
                    throw (ThreadDeath)cause;
                }
                if (cause instanceof VirtualMachineError) {
                    throw (VirtualMachineError)cause;
                }
                NamingException ne = new NamingException(e.getMessage());
                ne.setRootCause(e);
                throw ne;
            }
        }
        return null;
    }
}

