/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainFactory;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=ToolchainManager.class)
public class DefaultToolchainManager
implements ToolchainManager {
    @Requirement
    Logger logger;
    @Requirement(role=ToolchainFactory.class)
    Map<String, ToolchainFactory> factories;

    @Override
    public Toolchain getToolchainFromBuildContext(String type, MavenSession session) {
        List<Toolchain> toolchains;
        Map<String, Object> context = this.retrieveContext(session);
        ToolchainModel model = (ToolchainModel)context.get(DefaultToolchainManager.getStorageKey(type));
        if (model != null && !(toolchains = this.selectToolchains(Collections.singletonList(model), type, null)).isEmpty()) {
            return toolchains.get(0);
        }
        return null;
    }

    @Override
    public List<Toolchain> getToolchains(MavenSession session, String type, Map<String, String> requirements) {
        List<ToolchainModel> models = session.getRequest().getToolchains().get(type);
        return this.selectToolchains(models, type, requirements);
    }

    private List<Toolchain> selectToolchains(List<ToolchainModel> models, String type, Map<String, String> requirements) {
        ArrayList<Toolchain> toolchains = new ArrayList<Toolchain>();
        if (models != null) {
            ToolchainFactory fact = this.factories.get(type);
            if (fact == null) {
                this.logger.error("Missing toolchain factory for type: " + type + ". Possibly caused by misconfigured project.");
            } else {
                for (ToolchainModel model : models) {
                    try {
                        ToolchainPrivate toolchain = fact.createToolchain(model);
                        if (requirements != null && !toolchain.matchesRequirements(requirements)) continue;
                        toolchains.add(toolchain);
                    }
                    catch (MisconfiguredToolchainException ex) {
                        this.logger.error("Misconfigured toolchain.", ex);
                    }
                }
            }
        }
        return toolchains;
    }

    Map<String, Object> retrieveContext(MavenSession session) {
        Map<Object, Object> context = null;
        if (session != null) {
            PluginDescriptor desc = new PluginDescriptor();
            desc.setGroupId(PluginDescriptor.getDefaultPluginGroupId());
            desc.setArtifactId(PluginDescriptor.getDefaultPluginArtifactId((String)"toolchains"));
            MavenProject current = session.getCurrentProject();
            if (current != null) {
                context = session.getPluginContext(desc, current);
            }
        }
        return context != null ? context : new HashMap();
    }

    public static final String getStorageKey(String type) {
        return "toolchain-" + type;
    }
}

