/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

final class XMLEncode {
    private static final int CDATA_BLOCK_THRESHOLD_LENGTH = 12;
    private static final char DEFAULT_QUOTE_CHAR = '\"';

    XMLEncode() {
    }

    public static boolean isWhiteSpace(String text) {
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c = text.charAt(i2);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static String xmlEncodeTextForAttribute(String text, char quoteChar) {
        if (text == null) {
            return null;
        }
        return XMLEncode.xmlEncodeTextAsPCDATA(text, true, quoteChar);
    }

    public static String xmlEncodeText(String text) {
        if (text == null) {
            return null;
        }
        StringWriter writer = new StringWriter(text.length() * 2);
        XMLEncode.xmlEncodeText(text, writer);
        return writer.toString();
    }

    public static void xmlEncodeText(String text, Writer writer) {
        if (text == null) {
            return;
        }
        try {
            String cdata;
            if (!XMLEncode.needsEncoding(text)) {
                writer.write(text);
                return;
            }
            if (text.length() > 12 && (cdata = XMLEncode.xmlEncodeTextAsCDATABlock(text)) != null) {
                writer.write(cdata);
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        XMLEncode.xmlEncodeTextAsPCDATA(text, false, '\"', writer);
    }

    public static String xmlEncodeTextAsPCDATA(String text) {
        if (text == null) {
            return null;
        }
        return XMLEncode.xmlEncodeTextAsPCDATA(text, false);
    }

    public static String xmlEncodeTextAsPCDATA(String text, boolean forAttribute) {
        return XMLEncode.xmlEncodeTextAsPCDATA(text, forAttribute, '\"');
    }

    public static String xmlEncodeTextAsPCDATA(String text, boolean forAttribute, char quoteChar) {
        if (text == null) {
            return null;
        }
        StringWriter writer = new StringWriter(text.length() * 2);
        XMLEncode.xmlEncodeTextAsPCDATA(text, forAttribute, quoteChar, writer);
        return writer.toString();
    }

    public static void xmlEncodeTextAsPCDATA(String text, boolean forAttribute, char quoteChar, Writer n) {
        if (text == null) {
            return;
        }
        try {
            int length = text.length();
            if (forAttribute) {
                n.append(quoteChar);
            }
            block11: for (int i2 = 0; i2 < length; ++i2) {
                char c = text.charAt(i2);
                switch (c) {
                    case '&': {
                        n.append("&amp;");
                        continue block11;
                    }
                    case '<': {
                        n.append("&lt;");
                        continue block11;
                    }
                    case '>': {
                        n.append("&gt;");
                        continue block11;
                    }
                    case '\"': {
                        if (forAttribute) {
                            n.append("&quot;");
                            continue block11;
                        }
                        n.append(c);
                        continue block11;
                    }
                    case '\'': {
                        if (forAttribute) {
                            n.append("&apos;");
                            continue block11;
                        }
                        n.append(c);
                        continue block11;
                    }
                    case '\r': {
                        if (forAttribute) {
                            if (i2 != length - 1 && text.charAt(i2 + 1) == '\n') continue block11;
                            n.append("&#13;");
                            continue block11;
                        }
                        n.append(c);
                        continue block11;
                    }
                    case '\n': {
                        if (!forAttribute) continue block11;
                        n.append("&#10;");
                        continue block11;
                    }
                    default: {
                        n.append(c);
                    }
                }
            }
            if (forAttribute) {
                n.append(quoteChar);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String xmlEncodeTextAsCDATABlock(String text) {
        if (text == null) {
            return null;
        }
        if (XMLEncode.isCompatibleWithCDATABlock(text)) {
            return "<![CDATA[" + text + "]]>";
        }
        return null;
    }

    public static boolean needsEncoding(String text) {
        return XMLEncode.needsEncoding(text, false);
    }

    public static boolean needsEncoding(String data, boolean checkForAttr) {
        if (data == null) {
            return false;
        }
        for (int i2 = 0; i2 < data.length(); ++i2) {
            char c = data.charAt(i2);
            if (c != '&' && c != '<' && (!checkForAttr || c != '\"' && c != '\'')) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompatibleWithCDATABlock(String text) {
        return text != null && !text.contains("]]>");
    }

    public static String xmlDecodeTextToCDATA(String pcdata) {
        if (pcdata == null) {
            return null;
        }
        StringBuilder n = new StringBuilder(pcdata.length());
        for (int i2 = 0; i2 < pcdata.length(); ++i2) {
            char c = pcdata.charAt(i2);
            if (c == '&') {
                char c1 = XMLEncode.lookAhead(1, i2, pcdata);
                char c2 = XMLEncode.lookAhead(2, i2, pcdata);
                char c3 = XMLEncode.lookAhead(3, i2, pcdata);
                char c4 = XMLEncode.lookAhead(4, i2, pcdata);
                char c5 = XMLEncode.lookAhead(5, i2, pcdata);
                if (c1 == 'a' && c2 == 'm' && c3 == 'p' && c4 == ';') {
                    n.append("&");
                    i2 += 4;
                    continue;
                }
                if (c1 == 'l' && c2 == 't' && c3 == ';') {
                    n.append("<");
                    i2 += 3;
                    continue;
                }
                if (c1 == 'g' && c2 == 't' && c3 == ';') {
                    n.append(">");
                    i2 += 3;
                    continue;
                }
                if (c1 == 'q' && c2 == 'u' && c3 == 'o' && c4 == 't' && c5 == ';') {
                    n.append("\"");
                    i2 += 5;
                    continue;
                }
                if (c1 == 'a' && c2 == 'p' && c3 == 'o' && c4 == 's' && c5 == ';') {
                    n.append("'");
                    i2 += 5;
                    continue;
                }
                n.append("&");
                continue;
            }
            n.append(c);
        }
        return n.toString();
    }

    private static char lookAhead(int la, int offset, String data) {
        try {
            return data.charAt(offset + la);
        }
        catch (StringIndexOutOfBoundsException e) {
            return '\u0000';
        }
    }
}

