/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import org.apache.maven.shared.utils.Os;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.maven.shared.utils.io.IOUtil;

public class FileUtils {
    private static final int ONE_KB = 1024;
    private static final int ONE_MB = 0x100000;
    private static final int FILE_COPY_BUFFER_SIZE = 0x1E00000;
    private static final String FS = System.getProperty("file.separator");
    private static final String[] INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME = new String[]{":", "*", "?", "\"", "<", ">", "|"};

    protected FileUtils() {
    }

    @Nonnull
    public static String[] getDefaultExcludes() {
        return DirectoryScanner.DEFAULTEXCLUDES;
    }

    @Nonnull
    public static List<String> getDefaultExcludesAsList() {
        return Arrays.asList(FileUtils.getDefaultExcludes());
    }

    @Nonnull
    public static String getDefaultExcludesAsString() {
        return StringUtils.join(DirectoryScanner.DEFAULTEXCLUDES, ",");
    }

    @Deprecated
    @Nonnull
    public static String dirname(@Nonnull String path) {
        int i2 = path.lastIndexOf(File.separator);
        return i2 >= 0 ? path.substring(0, i2) : "";
    }

    @Deprecated
    @Nonnull
    public static String filename(@Nonnull String path) {
        int i2 = path.lastIndexOf(File.separator);
        return i2 >= 0 ? path.substring(i2 + 1) : path;
    }

    @Deprecated
    @Nonnull
    public static String extension(@Nonnull String path) {
        int lastDot;
        int lastSep = path.lastIndexOf(File.separatorChar);
        if (lastSep < 0) {
            lastDot = path.lastIndexOf(46);
        } else {
            lastDot = path.substring(lastSep + 1).lastIndexOf(46);
            if (lastDot >= 0) {
                lastDot += lastSep + 1;
            }
        }
        if (lastDot >= 0 && lastDot > lastSep) {
            return path.substring(lastDot + 1);
        }
        return "";
    }

    @Deprecated
    public static boolean fileExists(@Nonnull String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    @Deprecated
    @Nonnull
    public static String fileRead(@Nonnull String file) throws IOException {
        return FileUtils.fileRead(file, null);
    }

    @Deprecated
    @Nonnull
    private static String fileRead(@Nonnull String file, @Nullable String encoding) throws IOException {
        return FileUtils.fileRead(new File(file), encoding);
    }

    @Deprecated
    @Nonnull
    public static String fileRead(@Nonnull File file) throws IOException {
        return FileUtils.fileRead(file, null);
    }

    @Deprecated
    @Nonnull
    public static String fileRead(@Nonnull File file, @Nullable String encoding) throws IOException {
        Charset charset = FileUtils.charset(encoding);
        StringBuilder buf = new StringBuilder();
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), charset);){
            int count;
            char[] b = new char[512];
            while ((count = reader.read(b)) >= 0) {
                buf.append(b, 0, count);
            }
        }
        return buf.toString();
    }

    @Deprecated
    @Nonnull
    public static String[] fileReadArray(@Nonnull File file) throws IOException {
        List<String> lines = FileUtils.loadFile(file);
        return lines.toArray(new String[lines.size()]);
    }

    @Deprecated
    public static void fileAppend(@Nonnull String fileName, @Nonnull String data) throws IOException {
        FileUtils.fileAppend(fileName, null, data);
    }

    @Deprecated
    public static void fileAppend(@Nonnull String fileName, @Nullable String encoding, @Nonnull String data) throws IOException {
        Charset charset = FileUtils.charset(encoding);
        try (FileOutputStream out = new FileOutputStream(fileName, true);){
            ((OutputStream)out).write(data.getBytes(charset));
        }
    }

    @Deprecated
    public static void fileWrite(@Nonnull String fileName, @Nonnull String data) throws IOException {
        FileUtils.fileWrite(fileName, null, data);
    }

    @Deprecated
    public static void fileWrite(@Nonnull String fileName, @Nullable String encoding, @Nonnull String data) throws IOException {
        File file = new File(fileName);
        FileUtils.fileWrite(file, encoding, data);
    }

    @Deprecated
    public static void fileWrite(@Nonnull File file, @Nullable String encoding, @Nonnull String data) throws IOException {
        Charset charset = FileUtils.charset(encoding);
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), charset, new OpenOption[0]);){
            writer.write(data);
        }
    }

    @Deprecated
    public static void fileWriteArray(@Nonnull File file, String ... data) throws IOException {
        FileUtils.fileWriteArray(file, null, data);
    }

    @Deprecated
    public static void fileWriteArray(@Nonnull File file, @Nullable String encoding, String ... data) throws IOException {
        Charset charset = FileUtils.charset(encoding);
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), charset, new OpenOption[0]);){
            for (int i2 = 0; data != null && i2 < data.length; ++i2) {
                writer.write(data[i2]);
                if (i2 >= data.length) continue;
                writer.write("\n");
            }
        }
    }

    @Deprecated
    public static void fileDelete(@Nonnull String fileName) {
        File file = new File(fileName);
        FileUtils.deleteLegacyStyle(file);
    }

    public static String[] getFilesFromExtension(@Nonnull String directory, String ... extensions) {
        List<String> files = new ArrayList<String>();
        File currentDir = new File(directory);
        String[] unknownFiles = currentDir.list();
        if (unknownFiles == null) {
            return new String[0];
        }
        for (String unknownFile : unknownFiles) {
            String currentFileName = directory + System.getProperty("file.separator") + unknownFile;
            File currentFile = new File(currentFileName);
            if (currentFile.isDirectory()) {
                if (currentFile.getName().equals("CVS")) continue;
                String[] fetchFiles = FileUtils.getFilesFromExtension(currentFileName, extensions);
                files = FileUtils.blendFilesToList(files, fetchFiles);
                continue;
            }
            String add = currentFile.getAbsolutePath();
            if (!FileUtils.isValidFile(add, extensions)) continue;
            files.add(add);
        }
        String[] foundFiles = new String[files.size()];
        files.toArray(foundFiles);
        return foundFiles;
    }

    @Nonnull
    private static List<String> blendFilesToList(@Nonnull List<String> v, String ... files) {
        Collections.addAll(v, files);
        return v;
    }

    private static boolean isValidFile(@Nonnull String file, String ... extensions) {
        String extension = FileUtils.extension(file);
        for (String extension1 : extensions) {
            if (!extension1.equals(extension)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static void mkdir(@Nonnull String dir) {
        File file = new File(dir);
        if (Os.isFamily("windows") && !FileUtils.isValidWindowsFileName(file)) {
            throw new IllegalArgumentException("The file (" + dir + ") cannot contain any of the following characters: \n" + StringUtils.join(INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME, " "));
        }
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean contentEquals(@Nonnull File file1, @Nonnull File file2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static File toFile(@Nullable URL url) {
        if (url == null || !url.getProtocol().equalsIgnoreCase("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        int pos = -1;
        while ((pos = filename.indexOf(37, pos + 1)) >= 0) {
            if (pos + 2 >= filename.length()) continue;
            String hexStr = filename.substring(pos + 1, pos + 3);
            char ch = (char)Integer.parseInt(hexStr, 16);
            filename = filename.substring(0, pos) + ch + filename.substring(pos + 3);
        }
        return new File(filename);
    }

    @Nonnull
    public static URL[] toURLs(File ... files) throws IOException {
        URL[] urls2 = new URL[files.length];
        for (int i2 = 0; i2 < urls2.length; ++i2) {
            urls2[i2] = files[i2].toURI().toURL();
        }
        return urls2;
    }

    @Deprecated
    @Nonnull
    public static String removeExtension(@Nonnull String filename) {
        String ext = FileUtils.extension(filename);
        if ("".equals(ext)) {
            return filename;
        }
        int index = filename.lastIndexOf(ext) - 1;
        return filename.substring(0, index);
    }

    @Deprecated
    @Nonnull
    public static String getExtension(@Nonnull String filename) {
        return FileUtils.extension(filename);
    }

    @Deprecated
    public static void copyFileToDirectory(@Nonnull File source2, @Nonnull File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IOException("Destination is not a directory");
        }
        FileUtils.copyFile(source2, new File(destinationDirectory, source2.getName()));
    }

    private static void copyFileToDirectoryIfModified(@Nonnull File source2, @Nonnull File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtils.copyFileIfModified(source2, new File(destinationDirectory, source2.getName()));
    }

    @Deprecated
    public static void copyFile(@Nonnull File source2, @Nonnull File destination) throws IOException {
        if (!source2.exists()) {
            String message = "File " + source2 + " does not exist";
            throw new IOException(message);
        }
        if (Files.isSymbolicLink(source2.toPath())) {
            File target = Files.readSymbolicLink(source2.toPath()).toFile();
            FileUtils.createSymbolicLink(destination, target);
            return;
        }
        if (source2.getCanonicalPath().equals(destination.getCanonicalPath())) {
            return;
        }
        FileUtils.mkdirsFor(destination);
        FileUtils.doCopyFile(source2, destination);
        if (source2.length() != destination.length()) {
            String message = "Failed to copy full contents from " + source2 + " to " + destination;
            throw new IOException(message);
        }
    }

    private static void mkdirsFor(@Nonnull File destination) {
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
    }

    private static void doCopyFile(@Nonnull File source2, @Nonnull File destination) throws IOException {
        try (FileInputStream fis = new FileInputStream(source2);
             FileOutputStream fos = new FileOutputStream(destination);
             FileChannel input = fis.getChannel();
             FileChannel output = fos.getChannel();){
            long count;
            long size = input.size();
            for (long pos = 0L; pos < size; pos += output.transferFrom(input, pos, count)) {
                count = size - pos > 0x1E00000L ? 0x1E00000L : size - pos;
            }
        }
        FileUtils.copyFilePermissions(source2, destination);
    }

    private static boolean copyFileIfModified(@Nonnull File source2, @Nonnull File destination) throws IOException {
        if (destination.lastModified() < source2.lastModified()) {
            FileUtils.copyFile(source2, destination);
            return true;
        }
        return false;
    }

    public static void copyURLToFile(@Nonnull URL source2, @Nonnull File destination) throws IOException {
        FileUtils.copyStreamToFile(source2.openStream(), destination);
    }

    @Deprecated
    private static void copyStreamToFile(@Nonnull @WillClose InputStream source2, @Nonnull File destination) throws IOException {
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        if (destination.exists() && !destination.canWrite()) {
            String message = "Unable to open file " + destination + " for writing.";
            throw new IOException(message);
        }
        try (FileOutputStream out = new FileOutputStream(destination);
             InputStream in = source2;){
            IOUtil.copy(in, (OutputStream)out);
        }
    }

    @Deprecated
    @Nonnull
    public static String normalize(@Nonnull String path) {
        int index;
        String normalized = path;
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    @Nonnull
    public static File resolveFile(File baseFile, @Nonnull String filename) {
        String filenm = filename;
        if ('/' != File.separatorChar) {
            filenm = filename.replace('/', File.separatorChar);
        }
        if ('\\' != File.separatorChar) {
            filenm = filename.replace('\\', File.separatorChar);
        }
        if (filenm.startsWith(File.separator) || Os.isFamily("windows") && filenm.indexOf(":") > 0) {
            File file = new File(filenm);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return file;
        }
        char[] chars = filename.toCharArray();
        StringBuilder sb = new StringBuilder();
        int start = 0;
        if ('\\' == File.separatorChar) {
            sb.append(filenm.charAt(0));
            ++start;
        }
        for (int i2 = start; i2 < chars.length; ++i2) {
            boolean doubleSeparator;
            boolean bl = doubleSeparator = File.separatorChar == chars[i2] && File.separatorChar == chars[i2 - 1];
            if (doubleSeparator) continue;
            sb.append(chars[i2]);
        }
        filenm = sb.toString();
        File file = new File(baseFile, filenm).getAbsoluteFile();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    @Deprecated
    public static void forceDelete(@Nonnull String file) throws IOException {
        FileUtils.forceDelete(new File(file));
    }

    @Deprecated
    public static void forceDelete(@Nonnull File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectory(file);
        } else {
            boolean filePresent = file.getCanonicalFile().exists();
            if (!FileUtils.deleteFile(file) && filePresent) {
                String message = "File " + file + " unable to be deleted.";
                throw new IOException(message);
            }
        }
    }

    @Deprecated
    public static void delete(@Nonnull File file) throws IOException {
        Files.delete(file.toPath());
    }

    @Deprecated
    public static boolean deleteLegacyStyle(@Nonnull File file) {
        try {
            Files.delete(file.toPath());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean deleteFile(@Nonnull File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("File " + file + " isn't a file.");
        }
        if (!FileUtils.deleteLegacyStyle(file)) {
            if (Os.isFamily("windows")) {
                file = file.getCanonicalFile();
            }
            try {
                Thread.sleep(10L);
                return FileUtils.deleteLegacyStyle(file);
            }
            catch (InterruptedException ex) {
                return FileUtils.deleteLegacyStyle(file);
            }
        }
        return true;
    }

    public static void forceMkdir(@Nonnull File file) throws IOException {
        if (Os.isFamily("windows") && !FileUtils.isValidWindowsFileName(file)) {
            throw new IllegalArgumentException("The file (" + file.getAbsolutePath() + ") cannot contain any of the following characters: \n" + StringUtils.join(INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME, " "));
        }
        if (file.exists()) {
            if (file.isFile()) {
                String message = "File " + file + " exists and is not a directory. Unable to create directory.";
                throw new IOException(message);
            }
        } else if (!file.mkdirs()) {
            String message = "Unable to create directory " + file;
            throw new IOException(message);
        }
    }

    @Deprecated
    public static void deleteDirectory(@Nonnull String directory) throws IOException {
        FileUtils.deleteDirectory(new File(directory));
    }

    @Deprecated
    public static void deleteDirectory(@Nonnull File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        if (FileUtils.deleteLegacyStyle(directory)) {
            return;
        }
        FileUtils.cleanDirectory(directory);
        if (!FileUtils.deleteLegacyStyle(directory)) {
            String message = "Directory " + directory + " unable to be deleted.";
            throw new IOException(message);
        }
    }

    @Deprecated
    public static void cleanDirectory(@Nonnull File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        IOException exception = null;
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            try {
                FileUtils.forceDelete(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    @Deprecated
    public static long sizeOfDirectory(@Nonnull String directory) {
        return FileUtils.sizeOfDirectory(new File(directory));
    }

    @Deprecated
    public static long sizeOfDirectory(@Nonnull File directory) {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        long size = 0L;
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("Problems reading directory");
        }
        for (File file : files) {
            if (file.isDirectory()) {
                size += FileUtils.sizeOfDirectory(file);
                continue;
            }
            size += file.length();
        }
        return size;
    }

    @Nonnull
    public static List<File> getFiles(@Nonnull File directory, @Nullable String includes, @Nullable String excludes) throws IOException {
        return FileUtils.getFiles(directory, includes, excludes, true);
    }

    @Nonnull
    public static List<File> getFiles(@Nonnull File directory, @Nullable String includes, @Nullable String excludes, boolean includeBasedir) throws IOException {
        List<String> fileNames = FileUtils.getFileNames(directory, includes, excludes, includeBasedir);
        ArrayList<File> files = new ArrayList<File>();
        for (String filename : fileNames) {
            files.add(new File(filename));
        }
        return files;
    }

    @Nonnull
    public static List<String> getFileNames(@Nonnull File directory, @Nullable String includes, @Nullable String excludes, boolean includeBasedir) throws IOException {
        return FileUtils.getFileNames(directory, includes, excludes, includeBasedir, true);
    }

    @Nonnull
    private static List<String> getFileNames(@Nonnull File directory, @Nullable String includes, @Nullable String excludes, boolean includeBasedir, boolean isCaseSensitive) throws IOException {
        return FileUtils.getFileAndDirectoryNames(directory, includes, excludes, includeBasedir, isCaseSensitive, true, false);
    }

    @Nonnull
    public static List<String> getDirectoryNames(@Nonnull File directory, @Nullable String includes, @Nullable String excludes, boolean includeBasedir) throws IOException {
        return FileUtils.getDirectoryNames(directory, includes, excludes, includeBasedir, true);
    }

    @Nonnull
    public static List<String> getDirectoryNames(@Nonnull File directory, @Nullable String includes, @Nullable String excludes, boolean includeBasedir, boolean isCaseSensitive) throws IOException {
        return FileUtils.getFileAndDirectoryNames(directory, includes, excludes, includeBasedir, isCaseSensitive, false, true);
    }

    @Nonnull
    public static List<String> getFileAndDirectoryNames(File directory, @Nullable String includes, @Nullable String excludes, boolean includeBasedir, boolean isCaseSensitive, boolean getFiles, boolean getDirectories) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        if (includes != null) {
            scanner.setIncludes(StringUtils.split(includes, ","));
        }
        if (excludes != null) {
            scanner.setExcludes(StringUtils.split(excludes, ","));
        }
        scanner.setCaseSensitive(isCaseSensitive);
        scanner.scan();
        ArrayList<String> list = new ArrayList<String>();
        if (getFiles) {
            String[] files;
            for (String file : files = scanner.getIncludedFiles()) {
                if (includeBasedir) {
                    list.add(directory + FS + file);
                    continue;
                }
                list.add(file);
            }
        }
        if (getDirectories) {
            String[] directories = scanner.getIncludedDirectories();
            for (String directory1 : directories) {
                if (includeBasedir) {
                    list.add(directory + FS + directory1);
                    continue;
                }
                list.add(directory1);
            }
        }
        return list;
    }

    @Deprecated
    public static void copyDirectory(@Nonnull File sourceDirectory, @Nonnull File destinationDirectory) throws IOException {
        Objects.requireNonNull(sourceDirectory);
        Objects.requireNonNull(destinationDirectory);
        if (destinationDirectory.equals(sourceDirectory)) {
            throw new IOException("Can't copy directory " + sourceDirectory + " to itself.");
        }
        if (!destinationDirectory.exists() && !destinationDirectory.mkdirs()) {
            throw new IOException("Can't create directory " + destinationDirectory);
        }
        FileUtils.copyDirectoryStructure(sourceDirectory, destinationDirectory);
    }

    @Deprecated
    public static void copyDirectory(@Nonnull File sourceDirectory, @Nonnull File destinationDirectory, @Nullable String includes, @Nullable String excludes) throws IOException {
        if (!sourceDirectory.exists()) {
            return;
        }
        if (!sourceDirectory.isDirectory()) {
            throw new IOException(sourceDirectory + " is not a directory.");
        }
        List<File> files = FileUtils.getFiles(sourceDirectory, includes, excludes);
        for (File file : files) {
            FileUtils.copyFileToDirectory(file, destinationDirectory);
        }
    }

    @Deprecated
    public static void copyDirectoryStructure(@Nonnull File sourceDirectory, @Nonnull File destinationDirectory) throws IOException {
        FileUtils.copyDirectoryStructure(sourceDirectory, destinationDirectory, destinationDirectory, false);
    }

    private static void copyDirectoryStructure(@Nonnull File sourceDirectory, @Nonnull File destinationDirectory, File rootDestinationDirectory, boolean onlyModifiedFiles) throws IOException {
        if (sourceDirectory == null) {
            throw new IOException("source directory can't be null.");
        }
        if (destinationDirectory == null) {
            throw new IOException("destination directory can't be null.");
        }
        if (sourceDirectory.equals(destinationDirectory)) {
            throw new IOException("source and destination are the same directory.");
        }
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exist (" + sourceDirectory.getAbsolutePath() + ").");
        }
        File[] files = sourceDirectory.listFiles();
        if (files == null) {
            return;
        }
        String sourcePath = sourceDirectory.getAbsolutePath();
        for (File file : files) {
            if (file.equals(rootDestinationDirectory)) continue;
            String dest = file.getAbsolutePath();
            dest = dest.substring(sourcePath.length() + 1);
            File destination = new File(destinationDirectory, dest);
            if (file.isFile()) {
                destination = destination.getParentFile();
                if (onlyModifiedFiles) {
                    FileUtils.copyFileToDirectoryIfModified(file, destination);
                    continue;
                }
                FileUtils.copyFileToDirectory(file, destination);
                continue;
            }
            if (file.isDirectory()) {
                if (!destination.exists() && !destination.mkdirs()) {
                    throw new IOException("Could not create destination directory '" + destination.getAbsolutePath() + "'.");
                }
                FileUtils.copyDirectoryStructure(file, destination, rootDestinationDirectory, onlyModifiedFiles);
                continue;
            }
            throw new IOException("Unknown file type: " + file.getAbsolutePath());
        }
    }

    @Deprecated
    public static void rename(@Nonnull File from, @Nonnull File to) throws IOException {
        if (to.exists() && !FileUtils.deleteLegacyStyle(to)) {
            throw new IOException("Failed to delete " + to + " while trying to rename " + from);
        }
        File parent = to.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Failed to create directory " + parent + " while trying to rename " + from);
        }
        if (!from.renameTo(to)) {
            FileUtils.copyFile(from, to);
            if (!FileUtils.deleteLegacyStyle(from)) {
                throw new IOException("Failed to delete " + from + " while trying to rename it.");
            }
        }
    }

    @Deprecated
    public static File createTempFile(@Nonnull String prefix, @Nonnull String suffix, @Nullable File parentDir) {
        File result;
        String parent = System.getProperty("java.io.tmpdir");
        if (parentDir != null) {
            parent = parentDir.getPath();
        }
        DecimalFormat fmt = new DecimalFormat("#####");
        SecureRandom secureRandom = new SecureRandom();
        long secureInitializer = secureRandom.nextLong();
        Random rand = new Random(secureInitializer + Runtime.getRuntime().freeMemory());
        while ((result = new File(parent, prefix + fmt.format(FileUtils.positiveRandom(rand)) + suffix)).exists()) {
        }
        return result;
    }

    private static int positiveRandom(Random rand) {
        int a = rand.nextInt();
        while (a == Integer.MIN_VALUE) {
            a = rand.nextInt();
        }
        return Math.abs(a);
    }

    public static void copyFile(@Nonnull File from, @Nonnull File to, @Nullable String encoding, FilterWrapper ... wrappers) throws IOException {
        FileUtils.copyFile(from, to, encoding, wrappers, false);
    }

    public static void copyFile(@Nonnull File from, @Nonnull File to, @Nullable String encoding, @Nullable FilterWrapper[] wrappers, boolean overwrite) throws IOException {
        block48: {
            if (wrappers == null || wrappers.length == 0) {
                if (overwrite || to.lastModified() < from.lastModified()) {
                    FileUtils.copyFile(from, to);
                }
            } else {
                Charset charset = FileUtils.charset(encoding);
                try (BufferedReader fileReader = Files.newBufferedReader(from.toPath(), charset);){
                    Reader wrapped = fileReader;
                    for (FilterWrapper wrapper : wrappers) {
                        wrapped = wrapper.getReader(wrapped);
                    }
                    if (overwrite || !to.exists()) {
                        try (BufferedWriter fileWriter = Files.newBufferedWriter(to.toPath(), charset, new OpenOption[0]);){
                            IOUtil.copy(wrapped, (Writer)fileWriter);
                            break block48;
                        }
                    }
                    CharsetEncoder encoder = charset.newEncoder();
                    int totalBufferSize = 0x1E00000;
                    int charBufferSize = (int)Math.floor((float)totalBufferSize / (2.0f + 2.0f * encoder.maxBytesPerChar()));
                    int byteBufferSize = (int)Math.ceil((float)charBufferSize * encoder.maxBytesPerChar());
                    CharBuffer newChars = CharBuffer.allocate(charBufferSize);
                    ByteBuffer newBytes = ByteBuffer.allocate(byteBufferSize);
                    ByteBuffer existingBytes = ByteBuffer.allocate(byteBufferSize);
                    boolean writing = false;
                    try (RandomAccessFile existing = new RandomAccessFile(to, "rw");){
                        int n;
                        while (-1 != (n = wrapped.read(newChars))) {
                            ((Buffer)newChars).flip();
                            CoderResult coderResult = encoder.encode(newChars, newBytes, n != 0);
                            if (coderResult.isError()) {
                                coderResult.throwException();
                            }
                            ((Buffer)newBytes).flip();
                            if (!writing) {
                                int existingRead = existing.read(existingBytes.array(), 0, newBytes.remaining());
                                ((Buffer)existingBytes).position(existingRead);
                                ((Buffer)existingBytes).flip();
                                if (newBytes.compareTo(existingBytes) != 0) {
                                    writing = true;
                                    if (existingRead > 0) {
                                        existing.seek(existing.getFilePointer() - (long)existingRead);
                                    }
                                }
                            }
                            if (writing) {
                                existing.write(newBytes.array(), 0, newBytes.remaining());
                            }
                            ((Buffer)newChars).clear();
                            ((Buffer)newBytes).clear();
                            ((Buffer)existingBytes).clear();
                        }
                        if (existing.length() > existing.getFilePointer()) {
                            existing.setLength(existing.getFilePointer());
                        }
                    }
                }
            }
        }
        FileUtils.copyFilePermissions(from, to);
    }

    private static void copyFilePermissions(@Nonnull File source2, @Nonnull File destination) throws IOException {
        try {
            Files.setPosixFilePermissions(destination.toPath(), Files.getPosixFilePermissions(source2.toPath(), new LinkOption[0]));
        }
        catch (UnsupportedOperationException e) {
            destination.setExecutable(source2.canExecute());
            destination.setReadable(source2.canRead());
            destination.setWritable(source2.canWrite());
        }
    }

    @Deprecated
    @Nonnull
    public static List<String> loadFile(@Nonnull File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        if (file.exists()) {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath(), Charset.defaultCharset());){
                String line = reader.readLine();
                while (line != null) {
                    if (!(line = line.trim()).startsWith("#") && line.length() != 0) {
                        lines.add(line);
                    }
                    line = reader.readLine();
                }
            }
        }
        return lines;
    }

    private static Charset charset(String encoding) {
        if (encoding == null || encoding.isEmpty()) {
            return Charset.defaultCharset();
        }
        return Charset.forName(encoding);
    }

    private static boolean isValidWindowsFileName(@Nonnull File f) {
        if (Os.isFamily("windows")) {
            if (StringUtils.indexOfAny(f.getName(), INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME) != -1) {
                return false;
            }
            if (f.getParentFile() != null) {
                return FileUtils.isValidWindowsFileName(f.getParentFile());
            }
        }
        return true;
    }

    @Deprecated
    public static boolean isSymbolicLink(@Nonnull File file) throws IOException {
        return Files.isSymbolicLink(file.toPath());
    }

    @Deprecated
    public static boolean isSymbolicLinkForSure(@Nonnull File file) throws IOException {
        return Files.isSymbolicLink(file.toPath());
    }

    @Nonnull
    public static File createSymbolicLink(@Nonnull File symlink, @Nonnull File target) throws IOException {
        Path symlinkPath = symlink.toPath();
        if (Files.exists(symlinkPath, new LinkOption[0])) {
            if (target.equals(Files.readSymbolicLink(symlinkPath).toFile())) {
                return symlink;
            }
            Files.delete(symlinkPath);
        }
        return Files.createSymbolicLink(symlinkPath, target.toPath(), new FileAttribute[0]).toFile();
    }

    public static abstract class FilterWrapper {
        public abstract Reader getReader(Reader var1);
    }
}

