/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.injection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.project.ModelUtils;
import org.apache.maven.project.injection.ProfileInjector;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class DefaultProfileInjector
implements ProfileInjector {
    public void inject(Profile profile, Model model) {
        this.injectDependencies(profile, model);
        this.injectModules(profile, model);
        model.setRepositories(ModelUtils.mergeRepositoryLists(profile.getRepositories(), model.getRepositories()));
        model.setPluginRepositories(ModelUtils.mergeRepositoryLists(profile.getPluginRepositories(), model.getPluginRepositories()));
        this.injectReporting(profile, model);
        this.injectDependencyManagement(profile, model);
        this.injectDistributionManagement(profile, model);
        this.injectBuild(profile, model);
        Properties props = new Properties();
        ((Hashtable)props).putAll(model.getProperties());
        ((Hashtable)props).putAll(profile.getProperties());
        model.setProperties(props);
    }

    private void injectBuild(Profile profile, Model model) {
        BuildBase profileBuild = profile.getBuild();
        Build modelBuild = model.getBuild();
        if (profileBuild != null) {
            if (modelBuild == null) {
                modelBuild = new Build();
                model.setBuild(modelBuild);
            }
            if (profileBuild.getDirectory() != null) {
                modelBuild.setDirectory(profileBuild.getDirectory());
            }
            if (profileBuild.getDefaultGoal() != null) {
                modelBuild.setDefaultGoal(profileBuild.getDefaultGoal());
            }
            if (profileBuild.getFinalName() != null) {
                modelBuild.setFinalName(profileBuild.getFinalName());
            }
            ModelUtils.mergeFilterLists(modelBuild.getFilters(), profileBuild.getFilters());
            ModelUtils.mergeResourceLists(modelBuild.getResources(), profileBuild.getResources());
            ModelUtils.mergeResourceLists(modelBuild.getTestResources(), profileBuild.getTestResources());
            this.injectPlugins(profileBuild, modelBuild);
            PluginManagement profilePM = profileBuild.getPluginManagement();
            PluginManagement modelPM = modelBuild.getPluginManagement();
            if (modelPM == null) {
                modelBuild.setPluginManagement(profilePM);
            } else {
                this.injectPlugins(profilePM, modelPM);
            }
        }
    }

    private void injectPlugins(PluginContainer profileContainer, PluginContainer modelContainer) {
        List<Plugin> modelPlugins = modelContainer.getPlugins();
        if (modelPlugins == null) {
            modelContainer.setPlugins(profileContainer.getPlugins());
        } else if (profileContainer.getPlugins() != null) {
            TreeMap<String, Plugin> mergedPlugins = new TreeMap<String, Plugin>();
            Map<String, Plugin> profilePlugins = profileContainer.getPluginsAsMap();
            Iterator<Plugin> it = modelPlugins.iterator();
            while (it.hasNext()) {
                Plugin modelPlugin;
                Plugin mergedPlugin = modelPlugin = it.next();
                Plugin profilePlugin = profilePlugins.get(modelPlugin.getKey());
                if (profilePlugin != null) {
                    mergedPlugin = modelPlugin;
                    this.injectPluginDefinition(profilePlugin, modelPlugin);
                }
                mergedPlugins.put(mergedPlugin.getKey(), mergedPlugin);
            }
            it = profilePlugins.values().iterator();
            while (it.hasNext()) {
                Plugin profilePlugin = it.next();
                if (mergedPlugins.containsKey(profilePlugin.getKey())) continue;
                mergedPlugins.put(profilePlugin.getKey(), profilePlugin);
            }
            modelContainer.setPlugins(new ArrayList<Plugin>(mergedPlugins.values()));
            modelContainer.flushPluginMap();
        }
    }

    private void injectPluginDefinition(Plugin profilePlugin, Plugin modelPlugin) {
        if (profilePlugin == null || modelPlugin == null) {
            return;
        }
        if (profilePlugin.isExtensions()) {
            modelPlugin.setExtensions(true);
        }
        if (profilePlugin.getVersion() != null) {
            modelPlugin.setVersion(profilePlugin.getVersion());
        }
        this.injectConfigurationContainer(profilePlugin, modelPlugin);
        List<PluginExecution> modelExecutions = modelPlugin.getExecutions();
        if (modelExecutions == null || modelExecutions.isEmpty()) {
            modelPlugin.setExecutions(profilePlugin.getExecutions());
        } else {
            TreeMap<String, PluginExecution> executions = new TreeMap<String, PluginExecution>();
            Map<String, PluginExecution> profileExecutions = profilePlugin.getExecutionsAsMap();
            Iterator<Object> it = modelExecutions.iterator();
            while (it.hasNext()) {
                PluginExecution modelExecution = it.next();
                PluginExecution profileExecution = profileExecutions.get(modelExecution.getId());
                if (profileExecution != null) {
                    this.injectConfigurationContainer(profileExecution, modelExecution);
                    if (profileExecution.getPhase() != null) {
                        modelExecution.setPhase(profileExecution.getPhase());
                    }
                    List<String> profileGoals = profileExecution.getGoals();
                    List<String> modelGoals = modelExecution.getGoals();
                    ArrayList<String> goals = new ArrayList<String>();
                    if (modelGoals != null && !modelGoals.isEmpty()) {
                        goals.addAll(modelGoals);
                    }
                    if (profileGoals != null) {
                        Iterator<String> goalIterator = profileGoals.iterator();
                        while (goalIterator.hasNext()) {
                            String goal = goalIterator.next();
                            if (goals.contains(goal)) continue;
                            goals.add(goal);
                        }
                    }
                    modelExecution.setGoals(goals);
                }
                executions.put(modelExecution.getId(), modelExecution);
            }
            it = profileExecutions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String id = (String)entry.getKey();
                if (executions.containsKey(id)) continue;
                executions.put(id, (PluginExecution)entry.getValue());
            }
            modelPlugin.setExecutions(new ArrayList<PluginExecution>(executions.values()));
            modelPlugin.flushExecutionMap();
        }
    }

    private void injectConfigurationContainer(ConfigurationContainer profileContainer, ConfigurationContainer modelContainer) {
        Xpp3Dom configuration = (Xpp3Dom)profileContainer.getConfiguration();
        Xpp3Dom parentConfiguration = (Xpp3Dom)modelContainer.getConfiguration();
        configuration = Xpp3Dom.mergeXpp3Dom(configuration, parentConfiguration);
        modelContainer.setConfiguration(configuration);
    }

    private void injectModules(Profile profile, Model model) {
        List<String> profileModules;
        ArrayList<String> modules = new ArrayList<String>();
        List<String> modelModules = model.getModules();
        if (modelModules != null && !modelModules.isEmpty()) {
            modules.addAll(modelModules);
        }
        if ((profileModules = profile.getModules()) != null) {
            Iterator<String> it = profileModules.iterator();
            while (it.hasNext()) {
                String module = it.next();
                if (modules.contains(module)) continue;
                modules.add(module);
            }
        }
        model.setModules(modules);
    }

    private void injectDistributionManagement(Profile profile, Model model) {
        DistributionManagement pDistMgmt = profile.getDistributionManagement();
        DistributionManagement mDistMgmt = model.getDistributionManagement();
        if (mDistMgmt == null) {
            model.setDistributionManagement(pDistMgmt);
        } else if (pDistMgmt != null) {
            if (pDistMgmt.getRepository() != null) {
                mDistMgmt.setRepository(pDistMgmt.getRepository());
            }
            if (pDistMgmt.getSnapshotRepository() != null) {
                mDistMgmt.setSnapshotRepository(pDistMgmt.getSnapshotRepository());
            }
            if (StringUtils.isNotEmpty(pDistMgmt.getDownloadUrl())) {
                mDistMgmt.setDownloadUrl(pDistMgmt.getDownloadUrl());
            }
            if (pDistMgmt.getRelocation() != null) {
                mDistMgmt.setRelocation(pDistMgmt.getRelocation());
            }
            if (pDistMgmt.getSite() != null) {
                mDistMgmt.setSite(pDistMgmt.getSite());
            }
        }
    }

    private void injectDependencyManagement(Profile profile, Model model) {
        DependencyManagement modelDepMgmt = model.getDependencyManagement();
        DependencyManagement profileDepMgmt = profile.getDependencyManagement();
        if (profileDepMgmt != null) {
            if (modelDepMgmt == null) {
                model.setDependencyManagement(profileDepMgmt);
            } else {
                Dependency dependency;
                Iterator<Dependency> it;
                HashMap<String, Dependency> depsMap = new HashMap<String, Dependency>();
                List<Dependency> deps = modelDepMgmt.getDependencies();
                if (deps != null) {
                    it = deps.iterator();
                    while (it.hasNext()) {
                        dependency = it.next();
                        depsMap.put(dependency.getManagementKey(), dependency);
                    }
                }
                if ((deps = profileDepMgmt.getDependencies()) != null) {
                    it = deps.iterator();
                    while (it.hasNext()) {
                        dependency = it.next();
                        depsMap.put(dependency.getManagementKey(), dependency);
                    }
                }
                modelDepMgmt.setDependencies(new ArrayList<Dependency>(depsMap.values()));
            }
        }
    }

    private void injectReporting(Profile profile, Model model) {
        Reporting profileReporting = profile.getReporting();
        Reporting modelReporting = model.getReporting();
        if (profileReporting != null) {
            if (modelReporting == null) {
                model.setReporting(profileReporting);
            } else {
                Iterator<Object> it;
                if (StringUtils.isEmpty(modelReporting.getOutputDirectory())) {
                    modelReporting.setOutputDirectory(profileReporting.getOutputDirectory());
                }
                HashMap<String, ReportPlugin> mergedReportPlugins = new HashMap<String, ReportPlugin>();
                Map<String, ReportPlugin> profileReportersByKey = profileReporting.getReportPluginsAsMap();
                List<ReportPlugin> modelReportPlugins = modelReporting.getPlugins();
                if (modelReportPlugins != null) {
                    it = modelReportPlugins.iterator();
                    while (it.hasNext()) {
                        ReportPlugin modelReportPlugin = (ReportPlugin)it.next();
                        String inherited = modelReportPlugin.getInherited();
                        if (!StringUtils.isEmpty(inherited) && !Boolean.valueOf(inherited).booleanValue()) continue;
                        ReportPlugin profileReportPlugin = profileReportersByKey.get(modelReportPlugin.getKey());
                        ReportPlugin mergedReportPlugin = modelReportPlugin;
                        if (profileReportPlugin != null) {
                            mergedReportPlugin = profileReportPlugin;
                            this.mergeReportPlugins(profileReportPlugin, modelReportPlugin);
                        } else if (StringUtils.isEmpty(inherited)) {
                            mergedReportPlugin.unsetInheritanceApplied();
                        }
                        mergedReportPlugins.put(mergedReportPlugin.getKey(), mergedReportPlugin);
                    }
                }
                it = profileReportersByKey.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    String key = (String)entry.getKey();
                    if (mergedReportPlugins.containsKey(key)) continue;
                    mergedReportPlugins.put(key, (ReportPlugin)entry.getValue());
                }
                modelReporting.setPlugins(new ArrayList<ReportPlugin>(mergedReportPlugins.values()));
                modelReporting.flushReportPluginMap();
            }
        }
    }

    private void mergeReportPlugins(ReportPlugin dominant, ReportPlugin recessive) {
        if (StringUtils.isEmpty(recessive.getVersion())) {
            recessive.setVersion(dominant.getVersion());
        }
        Xpp3Dom dominantConfig = (Xpp3Dom)dominant.getConfiguration();
        Xpp3Dom recessiveConfig = (Xpp3Dom)recessive.getConfiguration();
        recessive.setConfiguration(Xpp3Dom.mergeXpp3Dom(dominantConfig, recessiveConfig));
        HashMap<String, ReportSet> mergedReportSets = new HashMap<String, ReportSet>();
        Map<String, ReportSet> dominantReportSetsById = dominant.getReportSetsAsMap();
        Iterator<ReportSet> it = recessive.getReportSets().iterator();
        while (it.hasNext()) {
            List<String> dominantRSReports;
            ReportSet recessiveReportSet = it.next();
            ReportSet dominantReportSet = dominantReportSetsById.get(recessiveReportSet.getId());
            ReportSet merged = recessiveReportSet;
            if (dominantReportSet == null) continue;
            merged = recessiveReportSet;
            Xpp3Dom dominantRSConfig = (Xpp3Dom)dominantReportSet.getConfiguration();
            Xpp3Dom mergedRSConfig = (Xpp3Dom)merged.getConfiguration();
            merged.setConfiguration(Xpp3Dom.mergeXpp3Dom(dominantRSConfig, mergedRSConfig));
            List<String> mergedReports = merged.getReports();
            if (mergedReports == null) {
                mergedReports = new ArrayList<String>();
                merged.setReports(mergedReports);
            }
            if ((dominantRSReports = dominantReportSet.getReports()) != null) {
                Iterator<String> reportIterator = dominantRSReports.iterator();
                while (reportIterator.hasNext()) {
                    String report = reportIterator.next();
                    if (mergedReports.contains(report)) continue;
                    mergedReports.add(report);
                }
            }
            mergedReportSets.put(merged.getId(), merged);
        }
        Iterator<Map.Entry<String, ReportSet>> rsIterator = dominantReportSetsById.entrySet().iterator();
        while (rsIterator.hasNext()) {
            Map.Entry<String, ReportSet> entry = rsIterator.next();
            String key = entry.getKey();
            if (mergedReportSets.containsKey(key)) continue;
            mergedReportSets.put(key, entry.getValue());
        }
        recessive.setReportSets(new ArrayList<ReportSet>(mergedReportSets.values()));
        recessive.flushReportSetMap();
    }

    private void injectDependencies(Profile profile, Model model) {
        Dependency dependency;
        Iterator<Dependency> it;
        HashMap<String, Dependency> depsMap = new HashMap<String, Dependency>();
        List<Dependency> deps = model.getDependencies();
        if (deps != null) {
            it = deps.iterator();
            while (it.hasNext()) {
                dependency = it.next();
                depsMap.put(dependency.getManagementKey(), dependency);
            }
        }
        if ((deps = profile.getDependencies()) != null) {
            it = deps.iterator();
            while (it.hasNext()) {
                dependency = it.next();
                depsMap.put(dependency.getManagementKey(), dependency);
            }
        }
        model.setDependencies(new ArrayList<Dependency>(depsMap.values()));
    }
}

