/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

class ReactorModelPool {
    private final Map<CacheKey, File> pomFiles = new HashMap<CacheKey, File>();

    ReactorModelPool() {
    }

    public File get(String groupId, String artifactId, String version2) {
        return this.pomFiles.get(new CacheKey(groupId, artifactId, version2));
    }

    public void put(String groupId, String artifactId, String version2, File pomFile) {
        this.pomFiles.put(new CacheKey(groupId, artifactId, version2), pomFile);
    }

    private static final class CacheKey {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final int hashCode;

        CacheKey(String groupId, String artifactId, String version2) {
            this.groupId = groupId != null ? groupId : "";
            this.artifactId = artifactId != null ? artifactId : "";
            this.version = version2 != null ? version2 : "";
            int hash = 17;
            hash = hash * 31 + this.groupId.hashCode();
            hash = hash * 31 + this.artifactId.hashCode();
            this.hashCode = hash = hash * 31 + this.version.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)obj;
            return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.version.equals(that.version);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(this.groupId).append(':').append(this.artifactId).append(':').append(this.version);
            return buffer.toString();
        }
    }
}

