/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.model.building.ModelCache;

class ReactorModelCache
implements ModelCache {
    private final Map<CacheKey, Object> models = new ConcurrentHashMap<CacheKey, Object>(256);

    ReactorModelCache() {
    }

    @Override
    public Object get(String groupId, String artifactId, String version2, String tag) {
        return this.models.get(new CacheKey(groupId, artifactId, version2, tag));
    }

    @Override
    public void put(String groupId, String artifactId, String version2, String tag, Object data) {
        this.models.put(new CacheKey(groupId, artifactId, version2, tag), data);
    }

    private static final class CacheKey {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String tag;
        private final int hashCode;

        CacheKey(String groupId, String artifactId, String version2, String tag) {
            this.groupId = groupId != null ? groupId : "";
            this.artifactId = artifactId != null ? artifactId : "";
            this.version = version2 != null ? version2 : "";
            this.tag = tag != null ? tag : "";
            int hash = 17;
            hash = hash * 31 + this.groupId.hashCode();
            hash = hash * 31 + this.artifactId.hashCode();
            hash = hash * 31 + this.version.hashCode();
            this.hashCode = hash = hash * 31 + this.tag.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)obj;
            return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.version.equals(that.version) && this.tag.equals(that.tag);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

