/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.transform;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.AbstractRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.transform.ArtifactTransformation;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public abstract class AbstractVersionTransformation
extends AbstractLogEnabled
implements ArtifactTransformation {
    protected RepositoryMetadataManager repositoryMetadataManager;
    protected WagonManager wagonManager;

    protected String resolveVersion(Artifact artifact, ArtifactRepository localRepository, List remoteRepositories) throws RepositoryMetadataResolutionException {
        AbstractRepositoryMetadata metadata = !artifact.isSnapshot() || "LATEST".equals(artifact.getBaseVersion()) ? new ArtifactRepositoryMetadata(artifact) : new SnapshotArtifactRepositoryMetadata(artifact);
        this.repositoryMetadataManager.resolve(metadata, remoteRepositories, localRepository);
        Metadata repoMetadata = metadata.getMetadata();
        String version2 = null;
        if (repoMetadata != null && repoMetadata.getVersioning() != null) {
            version2 = this.constructVersion(repoMetadata.getVersioning(), artifact.getBaseVersion());
        }
        if (version2 == null) {
            version2 = artifact.getBaseVersion();
        }
        if (this.getLogger().isDebugEnabled()) {
            if (!version2.equals(artifact.getBaseVersion())) {
                String message = artifact.getArtifactId() + ": resolved to version " + version2;
                message = artifact.getRepository() != null ? message + " from repository " + artifact.getRepository().getId() : message + " from local repository";
                this.getLogger().debug(message);
            } else {
                this.getLogger().debug(artifact.getArtifactId() + ": using locally installed snapshot");
            }
        }
        return version2;
    }

    protected abstract String constructVersion(Versioning var1, String var2);

    public abstract /* synthetic */ void transformForDeployment(Artifact var1, ArtifactRepository var2, ArtifactRepository var3) throws ArtifactDeploymentException;

    public abstract /* synthetic */ void transformForInstall(Artifact var1, ArtifactRepository var2) throws ArtifactInstallationException;

    public abstract /* synthetic */ void transformForResolve(Artifact var1, List var2, ArtifactRepository var3) throws ArtifactResolutionException, ArtifactNotFoundException;
}

